#include <stdio.h>
#include <ncurses.h>
#include <getopt.h>
#include "mkmk.h" 

int include=0;
char DEFTARGET[255]="none";
char DEFCC[255]="gcc";
char DEFLIBS[255]="none";
char DEFOBJECTS[255]="none";
char DEFCFLAGS[255]="none";
char DEFLIBDIR[255]="none";
char DEFINCDIR[255]="none";

main(int argc,char *argv[])
{
  FILE *Makefile,*mgrc;
  char CCFlags[255];
  char ProgName[255];
  char ObjName[255];
  char Libs[255];
  char CC[255];
  char IncDir[255];
  char LibDir[255];
  char INSTALLDIR[255];
  char MODE[255];

  char path[255];
  int option=0;
  int private=0;
  char y;
  while ((option = getopt(argc, argv, "hlm:")) != EOF)
    switch(option)
      {
      case 'm':
	private=1;
	sprintf(path,"%s",optarg);
	if((mgrc=fopen(path,"r"))!=NULL)
	  read_mgrc(mgrc);   
	break;
      case 'h':
      default:
	printf("usage: %s [-h] [-m rcfile]\n",argv[0]);
	exit(0); 
      }

  sprintf(path,"%s/.mkrc",getenv("HOME"));

  if(!private)
    if((mgrc=fopen(path,"r"))!=NULL)
      read_mgrc(mgrc);
    else if((mgrc=fopen("/usr/lib/mkrc","r"))!=NULL)
      read_mgrc(mgrc);   

  init_curses();

  credits();
  boundary_input(ProgName,"TARGET","no default",0,"(Enter the target program name)");
  boundary_input(ObjName,"OBJECTS","no default",0,"(Enter the object files to be used [.o])");
  boundary_input(CCFlags,"CFLAGS",DEFCFLAGS,1,"(Enter any compiler flags to be used)");
  boundary_input(CC,"CC",DEFCC,1,"(Enter the name of the compiler to be used)");
  boundary_input(Libs,"LIBS",DEFLIBS,1,"(Enter any addition libraries needed. Precede them with \"-l\")");
  boundary_input(LibDir,"LIBDIR",DEFLIBDIR,1,"(Enter any additional library search paths. Precede each with \"-L\")");
  boundary_input(IncDir,"INCDIR",DEFINCDIR,1,"(Enter any addition header search paths. Precede each with \"-I\")");
  printw("\nInstall Procedure? [y]"); 
  stdscr->_curx=stdscr->_curx-2;
  y=getch();
  delch();
  insch(y);
  stdscr->_curx=stdscr->_curx+2;
  wrefresh(stdscr);
  switch(y)
    {
    case 'n':
      printf("\n");
      break;
    case 'y':
    case '\n':
      printw("\n");
      include=1;
      boundary_input(INSTALLDIR,"INSTALLDIR","no default",0,"(Enter the full path in which to install the program)");
      boundary_input(MODE,"MODE","no default",0,"(Enter the permissions for the program)");
      break;
    }
  makefile_create(ProgName,ObjName,CCFlags,CC,Libs,LibDir,IncDir,INSTALLDIR,MODE); 
  endwin(); 
}






