'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) bindtags.n 1.5 95/05/06 15:30:44
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.3 95/05/06 15:19:04
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.TH bindtags n 4.0 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
bindtags \- Determine which bindings apply to a window, and order of evaluation
.SH SYNOPSIS
\fBbindtags \fIwindow \fR?\fItagList\fR?
.BE

.SH DESCRIPTION
.PP
When a binding is created with the \fBbind\fR command, it is
associated either with a particular window such as \fB.a.b.c\fR,
a class name such as \fBButton\fR, the keyword \fBall\fR, or any
other string.
All of these forms are called \fIbinding tags\fR.
Each window contains a list of binding tags that determine how
events are processed for the window.
When an event occurs in a window, it is applied to each of the
window's tags in order:  for each tag, the most specific binding
that matches the given tag and event is executed.
See the \fBbind\fR command for more information on the matching
process.
.PP
By default, each window has four binding tags consisting of the
name of the window, the window's class name, the name of the window's
nearest toplevel ancestor, and \fBall\fR, in that order.
Toplevel windows have only three tags by default, since the toplevel
name is the same as that of the window.
The \fBbindtags\fR command allows the binding tags for a window to be
read and modified.
.PP
If \fBbindtags\fR is invoked with only one argument, then the
current set of binding tags for \fIwindow\fR is returned as a list.
If the \fItagList\fR argument is specified to \fBbindtags\fR,
then it must be a proper list; the tags for \fIwindow\fR are changed
to the elements of the list.
The elements of \fItagList\fR may be arbitrary strings;  however,
any tag starting with a dot is treated as the name of a window;  if
no window by that name exists at the time an event is processed,
then the tag is ignored for that event.
The order of the elements in \fItagList\fR determines the order in
which binding scripts are executed in response to events.
For example, the command
.DS
\fBbindtags .b {all . Button .b}\fR
.DE
reverses the order in which binding scripts will be evaluated for
a button named \fB.b\fR so that \fBall\fR bindings are invoked
first, following by bindings for \fB.b\fR's toplevel (``.''), followed by
class bindings, followed by bindings for \fB.b\fR.
.PP
The \fBbindtags\fR command may be used to introduce arbitrary
additional binding tags for a window, or to remove standard tags.
For example, the command
.DS
\fBbindtags .b {.b TrickyButton . all}\fR
.DE
replaces the \fBButton\fR tag for \fB.b\fR with \fBTrickyButton\fR.
This means that the default widget bindings for buttons, which are
associated with the \fBButton\fR tag, will no longer apply to \fB.b\fR,
but any bindings associated with \fBTrickyButton\fR (perhaps some
new button behavior) will apply.

.SH "SEE ALSO"
bind

.SH KEYWORDS
binding, event, tag
