/* main.c --
 *
 * 			----> PLEASE READ <-----
 *
 *	This is the main file for the program "tixwish". It uses a different
 *	method than the standard Tcl_AppInit() function to initialize
 *	the Tix library. THIS METHOD IS NOT INTENDED FOR GENERAL USE IN
 *	APPLICATION PROGRAMS. IF YOU ARE WRITTING AN APPLICATION PROGRAM
 *	THAT USES TIX, PLEASE READ THE DEMO FILES IN
 *
 *		Tix$(VERSION)/demos-c/
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

#include <tk.h>
#include <tix.h>

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

extern int matherr();
int *tclDummyMathPtr = (int *) matherr;


#ifdef TIX_DEBUG

main(argc, argv)
    int argc;
    char ** argv;
{
    Tcl_Interp * interp;

    /* Initialize the Tix wish shell:
     *	- create an interpreter
     *  - create the main window [in Tk_MainWindow(interp)]
     *
     * The third argument is the application run-time command (rc) file.
     *
     * The fourth argument specifies whether wish should prompt and read
     * from the standard input. Possible values are:
     *
     * 		TIX_STDIN_ALWAYS
     *		TIX_STDIN_OPTIONAL
     *		TIX_STDIN_NONE
     *
     */
#if 0
    /*
     * don't prompt, don't parse command-line, argv, don't read rc file
     */
    interp = Tix_WishInit(0, 0, 0, TIX_STDIN_NONE);
#else
    /*
     * parse command-line, argv, read rc file
     * always prompt required.
     */
    interp = Tix_WishInit(&argc, argv, "~/.tixwishrc", TIX_STDIN_ALWAYS);
#endif

    /*
     * Initialize other optional modules here
     */

    /*
     * Loop infinitely, waiting for commands to execute.  When there
     * are no windows left, Tk_MainLoop returns and we exit.
     */

    Tix_MainLoop(interp);

    /*
     * Don't exit directly, but rather invoke the Tcl "exit" command.
     * This gives the application the opportunity to redefine "exit"
     * to do additional cleanup.
     */

    Tix_Exit(interp, 0);
}

#else

/* 
 * tkAppInit.c --
 *
 *	Provides a default version of the Tcl_AppInit procedure for
 *	use in wish and similar Tk-based applications.
 *
 * Copyright (c) 1993 The Regents of the University of California.
 * Copyright (c) 1994 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */


/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tk_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

int
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
{
    Tk_Main(argc, argv, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{
    Tk_Window main;

    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Tix_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

    /*
     * Call the init procedures for included packages.  Each call should
     * look like this:
     *
     * if (Mod_Init(interp) == TCL_ERROR) {
     *     return TCL_ERROR;
     * }
     *
     * where "Mod" is the name of the module.
     */

    /*
     * Call Tcl_CreateCommand for application-specific commands, if
     * they weren't already created by the init procedures called above.
     */

    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     */

    tcl_RcFileName = "~/.tixwishrc";
    return TCL_OK;
}

#endif
