.so man.macros
'----------------------------------------------------------------------
.HS tixForm tix 4.0
.BS
'
'
.SH NAME
tixForm \- Geometry manager based on attachment rules
'
'
'
.SH SYNOPSIS
.PP
\fBtixForm\fI option arg ?arg ...?\fR
.BE
.PP
.SH DESCRIPTION
.PP
'
The \fBtixForm\fR command is used to communicate with the
\fBtixForm\fR Geometry Manager, a geometry manager that arrange the
geometry of the children in a parent window according to attachment
rules. The \fBtixForm\fR command can have any of several forms,
depending on the option argument:
.TP
\fBtixForm\fR slave ?options?
If the first argument to \fBtixForm\fR is a window name (any value
starting with ``.''), then the command is processed in the same way as
\fBtixForm configure\fR.
'
.TP
\fBtixForm check \fImaster\fI
'
This command checks whether there is circular dependency in the
attachments of the master's slaves (see the section \fBCIRCULAR
DEPENDENCY\fR below). It returns the Boolean value \fBTRUE\fR if it
discover circular dependency and \fBFALSE\fR otherwise.
'
.TP
\fBtixForm configure\fI slave ?-flag value ...?\fR
'
Sets or adjusts the attachment values of the slave window
according to the \fI-flag value\fR argument pairs. 
'
.RS
.TP
\fB-in\fR master
'
Places the slave window into the specified master window. If the slave
was originally in another master window, all attachment values with
respect to the original master window are discarded. Even if the
attachment values are the same as in the original master window, they
need to be specified again.
The -in flag, when needed, must appear as the first flag after the
name of the slave. Otherwise an error is generated.
'
.TP
\fB-top\fR attachment
.TP
\fB-left\fR attachment
.TP
\fB-right\fR attachment
.TP
\fB-bottom\fR attachment
'
The attachment value can be one of any following form:
'
.RS
.TP
\fBPixel Attachment\fR
'
The pixel attachment is given by an integer number. If the integer is
zero or positive, it specifies a displacement from the top or left
edge of the master window. If the integer is negative or "\fB-0\fR",
it specifies a displacement from the bottom or right edges of the
master.  For example, "\fB-top 0\fR" specifies that the top side of
the slave window should be attached to the top edge of the master.
"\fB-right -0\fR" means the right side of the slave should be attached
to the right edge of the master. Moreover, "\fB-top 4\fR" attaches the
top side of the slave to 4 pixels lower than the top edge of the
master. "\fB-right -100\fR" attaches the right side of the slave to
100 pixels to the left of the right side of the master.
'
.TP
\fBOpposite Widget Attachment\fR
'
It attaches the specified side of the slave to the \fIopposite\fR side
of another slave widget, which must be managed by the same master
window. For example, "\fBtixForm .c -top .b\fR" attaches the top side
of the slave \fB.c\fR to the bottom side of the slave .b. "\fB-left .b\fR"
attaches the left side of the slave to the right side of the
slave \fB.b\fR.
'
.TP
\fBParallel Widget Alignment\fR
'
It aligns the specified side of the slave to the \fIsame\fR side of
another slave widget, which must be managed by the same master window.
Parallel attachment is specified by putting the & prefix at the front
of the pathname of the other widget. For example, "\fBtixForm .c -top
&.b\fR" aligns the top side of \fB.c\fR to the top side of \fB.b\fR.
"\fB-right &.b\fR" aligns the right side of the slave to the right
side of the slave \fB.b\fR.
'
.TP
\fB"None" Attachment\fR
'
This specifies a side of the slave to be attached to nothing. The
syntax is, "\fB-top none\fR", "\fB-bottom none\fR", "\fB-left none\fR"
and "\fB-right none\fR".

When a side of a slave is attached to "\fBnone\fR", the position of
this side is calculated by the position of the other side and the
natural size of the slave. For example, if a the left side of a widget
is attached to pixel \fB100\fR and the natural size of the widget is
\fB50\fR pixels, the right side of the widget will be positioned at
pixel \fB149\fR.

When both \fB-top\fR and \fB-bottom\fR are attached to \fBnone\fR,
then by default \fB-top\fR will be attached to the top edge of the
master. When both \fB-left\fR and \fB-right\fR are attached to none,
then by default \fB-left\fR will be attached to the left edge of the
master.

.TP
\fBgrid attachment\fR
'
This attachment is specified by a non-negative integer prefixed by the
character "\fB%\fR". 

By default the grid of a master window is divided into a 100x100 grid,
and hence the grid attachment is percentage attachment. The grid of a
master can be changed by the \fBtixForm grid\fR command.

For example, "\fBtixForm .b -left %20\fR" attaches the left side of \fB.b\fR
to 20% of the horizontal dimension of the master. "\fB-top
%70\fR" attaches the top side of the slave to 90% of the vertical
dimension of the master.

The grid value must not exceed the number of grids in the master
window. Otherwise an error is generated.
'
.TP
\fBdefault attachment values\fR
'
By default, a slave is attached by "\fB-top none -left none -bottom
none -right none\fR".
.RE
'
.TP
\fB-padleft\fR pixels
.TP
\fB-padright\fR pixels
.TP
\fB-padtop\fR pixels
.TP
\fB-padbottom\fR pixels
.TP
\fB-padx\fR pixels
.TP
\fB-pady\fR pixels
'
These options specifies the amount of external padding to leave on
each side of the slave. \fB-padx\fR is simply a shorthand for both
\fB-padleft\fR and \fB-padright\fR. \fB-pady\fR is simply a shorthand
for both \fB-padtop\fR and \fB-padbottom\fR.
'
.RE
.TP
\fBtixForm forget\fI slave ?slave ...?\fR
'
Removes each of the slaves from its master and unmaps their windows.
The slaves will no longer be managed by tixForm. All attachment values
with respect to their master windows are discarded.
'
.TP
\fBtixForm grid \fImaster ?x_size y_size?\fR
'
When \fIx_size\fR and \fIy_size\fR are given, this command returns the
number of grids of the master window in a pair of integers of the form
{x_size y_size}.

When both \fIx_size\fR and \fIy_size\fR are given, this command
changes the number of horizontal and vertical grids on the master
window.
.TP
\fBtixForm info\fI slave\fR ?\fIoption\fR?
'
Queries the attachment options of a slave window. \fIoption\fR can be
any of the options accepted by the \fBtixForm configure\fR command. If
\fIoption\fR is given, only the value of that option is returned.
Otherwise, this command returns a list whose elements are the current
configuration state of the slave given in the same flag-value form
that might be specified to \fBtixForm configure\fR. The first two
elements in this list list are "\fB-in\fI master\fR" where
\fImaster\fR is the slave's master window.
'
.TP
\fBtixForm slaves \fImaster\fR
'
Returns a list of all of the slaves for the master window. The order
of the slaves in the list is the same as their order in the packing
order. If master has no slaves then an empty string is returned.
'
'
.SH ALGORITHM OF TIXFORM
'
TixForm starts with any slave in the list of slaves of the master
window. Then it tries to determine the position of each side of the
slave.

If the attachment of a side of the slave is "concrete" (pixel
or grid attachment), the position of the side is readily determined.

If the attachment of this side is "none", then tixForm tries to
determine the position of the opposite side first, and then use the
position of the opposite side and the natural size of the slave to
determine the position of this side.

If the attachment is opposite or parallel widget attachments, then
tixForm tries to determine the positions of the other widget first,
and then use the positions of the other widget and the natural size of
the slave determine the position of this side. This recursive
algorithmis carried on until the positions of all slaves are
determined.

.SH CIRCULAR DEPENDENCY

The algorithm of tixForm will fail if a circular dependency exists in
the attachments of the slaves. For example:
.nf
	tixForm .c -left .b
	tixForm .b -right .c
.fi
In this example, the position of the left side of .b depends on the
right side of .c, which in turn depends on the left side of .b.

When a circular dependency is discovered during the execution of the
tixForm algorithm, tixForm will generate a background error and the
geometry of the slaves are undefined (and will be arbitrary). Notice
that tixForm only executes the algorithm when the specification of the
slaves' attachments is complete.  Therefore, it allows intermediate
states of circular dependency during the specification of the slaves'
attachments.  Also, unlike the Motif Form manager widget, tixForm
defines circular dependency as "dependency in the same dimension".
Therefore, the following code fragment will does not have circular
dependency because the two widgets do not depend on each other in the
same dimension (.b depends .c in the horizontal dimension and .c
depends on .b in the vertical dimension):

.nf
        tixForm .b -left .c
        tixForm .c -top .b
.fi

.PP
.SH KEYWORDS
Tix, Form, Geometry Management
