.so man.macros
'----------------------------------------------------------------------
.HS tixOptionMenu tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixOptionMenu \- Create and manipulate tixOptionMenu widgets
'
'
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixOptionMenu\fI \fIpathName ?\fIoptions\fR?
'
'
'----------------------------------------------------------------------
.PP
.SH SUPER-CLASS
The \fBTixOptionMenu\fR class is derived from the \fBTixLabelWidget\fR
class and inherits all the commands, options and
subwidgets of its super-class.
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'
The OptionMenu widget supports all the standard options of a frame
widget. See the \fBoptions(n)\fR manual entry for details on the
standard options.
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'
'----------BEGIN
.LP
.nf
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Switch:		\fB\-command\fR
.fi
.IP
Specifies the command to be called when the \fB\-value\fR option of
the OptionMenu is changed. The command will be called with one
arguments -- the new value of the OptionMenu widget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBdisableCallback\fR
Class:		\fBDisableCallback\fR
Switch:		\fB\-disablecallback\fR
.fi
.IP
A boolean value indicating whether callbacks should be disabled. When
set to true, the TCL command specified by the \fB\-command\fR option
is not executed when the \fB\-value\fR of the OptionMenu widget
changes.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBlabel\fR
Class:		\fBLabel\fR
Switch:		\fB\-label\fR
.fi
.IP
Specifies the string to display as the label of this OptionMenu widget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBlabelSide\fR
Class:		\fBLabelSide\fR
Switch:		\fB\-labelside\fR
.fi
.IP
Specifies where the label should be displayed relative to the entry
subwidget. Valid options are: \fBtop\fR, \fBleft\fR, \fBright\fR,
\fBbottom\fR, \fBnone\fR or \fBacrosstop\fR.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBstate\fR
Class:		\fBState\fR
Switch:		\fB\-state\fR
.fi
.IP
Specifies the whether the OptionMenu widget is normal or disabled. Only
the values "normal" and "disabled" are recognized.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBvalue\fR
Class:		\fBValue\fR
Switch:		\fB\-value\fR
.fi
.IP
Specifies the value of the OptionMenu. The value of the OptionMenu
widget is the name of the item currently displayed by its
\fBmenubutton\fR subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBvariable\fR
Class:		\fBVariable\fR
Switch:		\fB\-variable\fR
.fi
.IP
Specifies the global variable in which the value of the OptionMenu
should be stored. The value of the OptionMenu will be automatically
updated when this variable is changed.
'----------END
'
'----------------------------------------------------------------------
.SH SUBWIDGETS
'----------BEGIN
.LP
.nf
Name:		\fBmenu\fR
Class:		\fBMenu\fR
.fi
.IP
The menu subwidget, which is popped up when the user press the
\fBmenubutton\fR subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBmenubutton\fR
Class:		\fBMenubutton\fR
.fi
.IP
The menubutton subwidget.
'----------END
.BE
'
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixOptionMenu\fR command creates a new window (given by
the \fIpathName\fR argument) and makes it into a OptionMenu
widget. Additional options, described above, may be specified on the
command line or in the option database to configure aspects of the
OptionMenu such as its cursor and relief.
'
'
'----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'
The \fBtixOptionMenu\fR command creates a new Tcl command whose
name is the same as the path name of the OptionMenu's
window. This command may be used to invoke various operations on the
widget. It has the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?
.PP
.DE
'
\fIPathName\fR is the name of the command, which is the same as the
OptionMenu widget's path name. \fIOption\fR and the
\fIarg\fRs determine the exact behavior of the command. The following
commands are possible for OptionMenu widgets:
'
'
.TP
\fIpathName \fBadd\fR \fItype name \fR?\fIoption value ...\fR?
'
Adds a new item into the OptionMenu widget. \fItype\fR must be either
\fBcommand\fR or \fBseparator\fR. The \fIoptions\fR may be any of the
valid options for the \fBcommand\fR or \fBseparator\fR menu entry
types for the TK \fBmenu\fR widget class, except \fB\-command\fR.
'
.TP
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixOptionMenu\fR command.
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string. \fIOption\fR may have
any of the values accepted by the \fBtixOptionMenu\fR command.
'
'
.TP
\fIpathName \fBsubwidget \fIname ?args?\fR 
'
When no options are given, this command returns the pathname of the
subwidget of the specified name.

When options are given, the widget command of the specified subwidget
will be called with these options.
'
'
'
'----------------------------------------------------------------------
'.SH BINDINGS
'.PP
'
'
'
'----------------------------------------------------------------------
.SH KEYWORDS
Tix(n)
