.so man.macros
'----------------------------------------------------------------------
.HS tixFileEntry tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixFileEntry \- Create and manipulate tixFileEntry widgets
'
'
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixFileEntry\fI \fIpathName ?\fIoptions\fR?
'
'
'----------------------------------------------------------------------
.PP
.SH SUPER-CLASS
The \fBTixFileEntry\fR class is derived from the \fBTixLabelWidget\fR
class and inherits all the commands, options and
subwidgets of its super-class.
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'
The FileEntry widget supports all the standard options of a frame
widget. See the \fBoptions(n)\fR manual entry for details on the
standard options.
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'
'----------BEGIN
.LP
.nf
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Switch:		\fB\-command\fR
.fi
.IP
Specifies the command to be called when the \fB\-value\fR option of
the FileEntry is changed. This usually happens when the user inputs a
filename into the entry subwidget and hits the <Return> key. The
command will be called with one arguments -- the new value of the
FileEntry widget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBdialogType\fR
Class:		\fBDialogType\fR
Switch:		\fB\-dialogtype\fR
.fi
.IP
Specifies which type of file selection dialog should be popped up when
the user invokes the \fBbutton\fR subwidget. Current only two values
are valid: \fBtixFileSelectDialog\fR or \fBtixExFileSelectDialog\fR.
'----------END
'----------BEGIN
.LP
.nf
Name:		\fBdisableCallback\fR
Class:		\fBDisableCallback\fR
Switch:		\fB\-disablecallback\fR
.fi
.IP
A boolean value indicating whether callbacks should be disabled. When
set to true, the TCL command specified by the \fB\-command\fR option
is not executed when the \fB\-value\fR of the FileEntry widget
changes.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBdisableForeground\fR
Class:		\fBDisableForeground\fR
Switch:		\fB\-disableforeground\fR
.fi
.IP
The foreground color to use for of the entry subwidget when the
FileEntry widget is disabled.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBfileBitmap\fR
Class:		\fBFileBitmap\fR
Switch:		\fB\-filebitmap\fR
.fi
.IP
Specifies the bitmap to display in side the \fBbutton\fR subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBlabel\fR
Class:		\fBLabel\fR
Switch:		\fB\-label\fR
.fi
.IP
Specifies the string to display as the label of this FileEntry widget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBlabelSide\fR
Class:		\fBLabelSide\fR
Switch:		\fB\-labelside\fR
.fi
.IP
Specifies where the label should be displayed relative to the entry
subwidget. Valid options are: \fBtop\fR, \fBleft\fR, \fBright\fR,
\fBbottom\fR, \fBnone\fR or \fBacrosstop\fR.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBstate\fR
Class:		\fBState\fR
Switch:		\fB\-state\fR
.fi
.IP
Specifies the whether the FileEntry widget is normal or disabled. Only
the values "normal" and "disabled" are recognized.
'----------END
''
'----------BEGIN
.LP
.nf
Name:		\fBvalidateCmd\fR
Class:		\fBValidateCmd\fR
Switch:		\fB\-validatecmd\fR
.fi
.IP
Specifies a TCL command to be called when the -value of the
FileEntry widget is about to change. This command is called
with one parameter -- the new \fB\-value\fR entered by the user. This
command is to validate this new value by returning a value it deems
valid.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBvalue\fR
Class:		\fBValue\fR
Switch:		\fB\-value\fR
.fi
.IP
Specifies the value of the FileEntry.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBvariable\fR
Class:		\fBVariable\fR
Switch:		\fB\-variable\fR
.fi
.IP
Specifies the global variable in which the value of the FileEntry
should be stored. The value of the FileEntry will be automatically
updated when this variable is changed.
'----------END
'
'----------------------------------------------------------------------
.SH SUBWIDGETS
'----------BEGIN
.LP
.nf
Name:		\fBbutton\fR
Class:		\fBButton\fR
.fi
.IP
The button subwidget next to the entry subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBentry\fR
Class:		\fBEntry\fR
.fi
.IP
The entry subwidget in which the user can type in a filename.
'----------END
.BE
'
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixFileEntry\fR command creates a new window (given by
the \fIpathName\fR argument) and makes it into a FileEntry
widget. Additional options, described above, may be specified on the
command line or in the option database to configure aspects of the
FileEntry such as its cursor and relief.
.PP
The FileEntry widget can be used to input a filename. The user can
type in the filename manually. Alternatively, the user can press the
button widget that sits next to the entry, which will bring up a file
selection dialog of the type specified by the \fB\-dialogtype\fR option.
'
'
'----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'
The \fBtixFileEntry\fR command creates a new Tcl command whose
name is the same as the path name of the FileEntry's
window. This command may be used to invoke various operations on the
widget. It has the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?
.PP
.DE
'
\fIPathName\fR is the name of the command, which is the same as the
FileEntry widget's path name. \fIOption\fR and the
\fIarg\fRs determine the exact behavior of the command. The following
commands are possible for FileEntry widgets:
'
.TP
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixFileEntry\fR command.
'
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fBtixFileEntry\fR command.
'
'
.TP
\fIpathName \fBinvoke\fR 
'
Forces the FileEntry widget to act as if the user has pressed the
<return> key inside the entry subwidget.
'
.TP
\fIpathName \fBfiledialog\fR 
'
Returns the pathname of the file dialog box associated with this
FileEnt widget.
'
'
.TP
\fIpathName \fBsubwidget \fIname ?args?\fR 
'
When no options are given, this command returns the pathname of the
subwidget of the specified name.

When options are given, the widget command of the specified subwidget
will be called with these options.
'
'
'
'----------------------------------------------------------------------
'.SH BINDINGS
'.PP
'
'
'
'----------------------------------------------------------------------
.SH KEYWORDS
Tix(n)
