# Undocumented command. Don't use it.
#
# Usage:
# 
# 	tixmkpref < name.src > name.tcl
#
proc tixDefOption {classes specs} {
    foreach class $classes {
	foreach spec $specs {
	    # Trick.
	    # Since the spec is quoated by curly brackets,
	    # they were not substituted. The uplevel command
	    # force this to be evaluted in the previous level,
	    # so that $spec can be substituted.
	    #
	    puts option add *$class$spec 79
	}
    }
}


proc tixInitOptionDatabase {strictTK} {

    # This command is quite important. Without it the options for
    # the subwidgets inside TIX widgets will be completely crazy

    global tixOption

    # Specific to all TK Widgets

    set tixWidgets {
	TixComboBox
	TixControl
	TixButtonBox
	TixDirList
	TixDirTree
	TixFileSelectBox
	TixHList
	TixLabelFrame
	TixMwmClient
	TixPanedWindow
	TixPopupMenu
	TixScrolledHList
	TixScrolledListBox
	TixScrolledText
	TixScrolledWindow
	TixSelect
	TixStdButtonBox
    }

    set tkWidgets {
	Button
	Canvas
	Checkbutton
	Entry
	Frame
	Label
	Listbox
	Radiobutton
	Menu
	Menubutton
	Scale
	Scrollbar
	Text
    }

    if {$strictTK} {
	# Just want to set options for TIX widgets
	#
	set allWidgets $tixWidgets
    } else {
	# Set options for both TK and TIX widgets
	#
	set allWidgets [concat $tkWidgets $tixWidgets ]
    }

    # general stuff, everything gets these defaults unless otherwise specified
    #-------------------------------------------------------------------------

    option add *background $tixOption(bg) 10

    tixDefOption $allWidgets {
	{*Font			$tixOption(font)}
	{*Background		$tixOption(bg)}
	{*HighlightBackground	$tixOption(bg)}
	{*Foreground		$tixOption(fg)}
	{*font			$tixOption(font)}
	{*background		$tixOption(bg)}
	{*foreground		$tixOption(fg)}
	{*activeBackground	$tixOption(active_bg)}
	{*activeForeground	$tixOption(active_fg)}
	{*disabledForeground	$tixOption(disabled_fg)}
	{*anchor		w}
	{*selectBackground	$tixOption(select_bg)}
	{*selectForeground	$tixOption(select_fg)}
	{*selectBorderWidth	0}
    }

    if {$strictTK == 0}  {
    #----------------------------------------
    # Standard TK Widget Options
    #
    # We set up the options for the TK widgets only if
    # the strictTK option is not selected.
    #----------------------------------------

    tixDefOption {Button} {
	{.borderWidth		2}
	{.buff			true}
	{.anchor		c}
    }

    tixDefOption {Checkbutton Radiobutton} {
	{.selectColor		$tixOption(selector)}
	{.borderWidth		$tixOption(border1)}
    }

    tixDefOption {Entry} {
	{.relief		sunken}
	{.highlightBacground		$tixOption(bg)}
	{.background		$tixOption(input1_bg)}
	{.foreground		black}
	{.insertBackground	black}
    }

    tixDefOption {Label} {
	{.anchor		w}
	{.borderWidth		0}
	{.font              	$tixOption(bold_font)}
    }

    tixDefOption {Listbox} {
	{.background		$tixOption(dark1_bg)}
	{.relief		sunken}
    }

    tixDefOption {Menu TixMenu} {
	{*font			$tixOption(menu_font)}
	{*selectColor		$tixOption(selector)}
    }

    tixDefOption {Menubutton} {
	{*font		$tixOption(menu_font)}
    }

    tixDefOption {Scale} {
	{.foreground	$tixOption(fg)}
	{.activeForeground	$tixOption(bg)}
	{.background	$tixOption(bg)}
	{.sliderForeground	$tixOption(bg)}
	{.sliderBackground	$tixOption(dark1_bg)}
	{.font		$tixOption(italic_font)}
    }

    tixDefOption {Scrollbar} {
	{.foreground	$tixOption(bg)}
	{.activeForeground	$tixOption(bg)}
	{.background	$tixOption(dark1_bg)}
	{.relief		sunken}
    }

    tixDefOption {Text} {
	{.background	$tixOption(input1_bg)}
	{.relief		sunken}
	{.borderWidth	$tixOption(border1)}
    }
    }

    #----------------------------------------------------------------------
    # TIX WIDGETS
    #----------------------------------------------------------------------

    tixDefOption $tixWidgets {
	{.label.anchor			c}
	{.label.borderWidth		0}
	{.label.padX              	0}
	{.label.padY              	0}
    }

    tixDefOption {TixBalloon} {
	{*background 			#ffff60}
	{*foreground 			black}
	{*borderWidth 			0}
	{.borderWidth 			1}
	{.background 			black}
    }

    tixDefOption {TixBitmapButton} {
	{*label.font 			$tixOption(font)}
    }

    tixDefOption {TixControl} {
	{.borderWidth 			0}
	{.value 			0}
	{.value 			0}
	{*entry.highlightBacground		$tixOption(bg)}
	{*entry.background		$tixOption(input1_bg)}
	{*entry.foreground		black}
	{*entry.relief			sunken}
	{*entry.width			5}
	{*entry.insertBackground	black}
	{*label.anchor			e}
	{*label.borderWidth		0}
	{*Button.buff			false}
	{*Button.anchor			c}
	{*Button.borderWidth		2}
	{*Button.highlightThickness	1}
	{*label.font              	$tixOption(bold_font)}
    }

    # DLG_BTNS
    #
    tixDefOption {TixButtonBox TixStdButtonBox} {
	{.borderWidth 	1}
	{.relief 	raised}
	{.padX 		5}
	{.padY 		10}
	{*Button.background $tixOption(bg)}
	{*Button.anchor	c}
	{*Button.padX	5}
    }

    # DIR_LIST
    #
    tixDefOption {TixDirList TixDirTree} {
	{*Scrollbar.background		$tixOption(bg)}
	{*Scrollbar.troughColor		$tixOption(dark1_bg)}
	{*Scrollbar.relief		sunken}
	{*Scrollbar.width		15}
	{*hlist.highlightBacground	$tixOption(bg)}
	{*hlist.relief			sunken}
	{*hlist.background		$tixOption(dark1_bg)}
	{*hlist.height			10}
	{*hlist.width			10}
	{*hlist.padX			2}
	{*hlist.padY			0}
	{*hlist.drawBranch		0}
	{*borderWidth			1}

    }
    tixDefOption {TixDirList} {
	{*hlist.indent			7}
	
    }
    tixDefOption {TixDirTree} {
	{*hlist.indent			14}
    }

    tixDefOption {TixFileEntry} {
	{*frame.borderWidth		2}
	{*frame.relief			sunken}
	{*Button.highlightThickness	0}
	{*Entry.highlightThickness	0}
	{*Entry.borderWidth 		0}
    }

    tixDefOption {TixHList} {
    }

    tixDefOption {TixLabelFrame} {
	{*label.font 	 	$tixOption(bold_font)}
	{*label.anchor 	 	w}
	{.frame.relief 	 	groove}
	{.frame.borderWidth 	2}
	{.border.relief 	groove}
	{.border.borderWidth 	2}
	{.borderWidth 	 	2}
	{.padX 		 	2}
	{.padY 		 	2}
	{.anchor 	 	sw}
    }
    tixDefOption {TixMultiList} {
	{*Listbox.borderWidth		0}
	{*Listbox.highlightThickness	0}
	{*Scrollbar.background		$tixOption(bg)}
	{*Scrollbar.troughColor		$tixOption(dark1_bg)}
	{*Scrollbar.relief		sunken}
	{*Scrollbar.width		15}
	{*f1.borderWidth		2}
	{*f1.relief			sunken}
	{*f1.highlightThickness		2}
    }

    # MwmClient
    #
    tixDefOption {TixMwmClient} {
	{*title.font		$tixOption(menu_font)}
    }

    tixDefOption {TixMDIMenuBar} {
	{*menubar.relief		raised}
	{*menubar.borderWidth		2}
	{*Menubutton.padY 		2}
    }

    # NoteBook
    #
    tixDefOption {TixNoteBook} {
	{.relief		raised}
	{.borderWidth		2}
	{.Background		$tixOption(bg)}
	{.nbframe.tabPadX	4}
	{.nbframe.tabPadY	3}
	{.nbframe.borderWidth	2}
	{.nbframe.relief	raised}
	{.nbframe.Background	$tixOption(bg)}
	{.nbframe.font		$tixOption(menu_font)}
	{.nbframe.backPageColor	$tixOption(bg)}
    }
 
    # OPTION_MENU
    #
    tixDefOption {TixOptionMenu} {
	{*menubutton.font		$tixOption(font)}
	{*menubutton.borderWidth	2}
	{*menubutton.relief		raised}
    }

    # PANED_WINDOW
    #
    tixDefOption {TixPanedWindow} {
	{.handleActiveBg $tixOption(active_bg)}
	{.seperatorBg    $tixOption(bg)}
	{.handleBg       $tixOption(bg)}
    }

    # POPUP MENU
    #
    tixDefOption {TixPopupMenu} {
	{*menubutton.background $tixOption(dark1_bg)}
	{*Menu.tearOff		0}
    }

    # SCROLLED_HLIST
    #
    tixDefOption {TixScrolledHList TixDirTree TixDirList} {
	{*Scrollbar.background		$tixOption(bg)}
	{*Scrollbar.troughColor		$tixOption(dark1_bg)}
	{*Scrollbar.relief		sunken}
	{*Scrollbar.width		15}
	{*hlist.highlightBacground	$tixOption(bg)}
	{*hlist.relief			sunken}
	{*hlist.background		$tixOption(dark1_bg)}
	{*borderWidth			1}
	{.scrollbar			auto}
    }

    # SCROLLED_LISTBOX, .. ETC
    #
    tixDefOption {TixScrolledListBox TixScrolledText} {
	{*Scrollbar.background		$tixOption(bg)}
	{*Scrollbar.troughColor		$tixOption(dark1_bg)}
	{*Scrollbar.relief		sunken}
	{*Scrollbar.width		15}
	{*borderWidth			1}
    }

    tixDefOption {TixScrolledText} {
	{.scrollbar			both}
    }

    tixDefOption {TixScrolledListBox} {
	{*listbox.highlightBacground	$tixOption(bg)}
	{*listbox.relief		sunken}
	{*listbox.background		$tixOption(dark1_bg)}
	{.scrollbar			auto}
    }

    # SCROLLED_WINDOW
    #
    tixDefOption {TixScrolledWindow} {
	{*Scrollbar.background		$tixOption(bg)}
	{*Scrollbar.troughColor		$tixOption(dark1_bg)}
	{*Scrollbar.relief		sunken}
	{*Scrollbar.width		15}
	{.frame.relief			sunken}
	{.frame.background		$tixOption(dark1_bg)}
	{*borderWidth			1}
	{.scrollbar			auto}
    }


    # SELECT
    #
    tixDefOption {TixSelect} {
	{*frame.borderWidth			1}
	{*frame.relief				sunken}
	{*Button.borderWidth			2}
	{*Button.highlightThickness		0}
    }

    # NON ALPHABETICAL ORDER WIDGETS

    # Since TK's option database follows the order-of-declaration rule, not
    # specific-vs-general rule, the options of the widgets below depends on
    # the options of the widget above, so their options must be defined here

    # COMBOBOX
    tixDefOption {TixComboBox} {
	{*Entry.font				$tixOption(font)}
	{*Entry.relief				sunken}
	{*Entry.highlightBacground		$tixOption(bg)}
	{*Entry.background			$tixOption(input1_bg)}
	{*Entry.foreground			black}
	{*Entry.insertBackground		black}
	{*TixScrolledListBox.scrollbar		auto}
	{*Listbox.exportSelection		false}
	{*Listbox.takeFocus			false}
	{*shell.borderWidth			2}
	{*shell.relief				raised}
	{*shell.cursor				arrow}
	{*Button.buff				false}
	{*Button.anchor				c}
	{*Button.borderWidth			1}
	{*Button.highlightThickness		0}
	{*Button.padX				0}
	{*Button.padY				0}
	{*tick.width				18}
	{*tick.height				18}
	{*cross.width				18}
	{*cross.height				18}
	{*arrow.anchor				c}
	{*arrow.width				15}
	{*arrow.height				18}
    }

    # FILE_SELECT_BOX

    tixDefOption {TixFileSelectBox} {
	{.relief			raised}
	{.borderWidth 			1}
	{*Label.anchor			w}
	{*Label.borderWidth		0}
	{*Label.font            	$tixOption(bold_font)}
	{*TixComboBox*scrollbar		auto}
	{*TixScrolledListBox.scrollbar	auto}
	{*Listbox.exportSelection	false}
	{*filelist*Listbox.takeFocus	true}
    }
    tixDefOption {TixExFileSelectBox} {
	{*filelist*Listbox.takeFocus	true}
    }
}
