# Util.tcl -
#
#	The Tix utility commands. Some of these commands are replacement of
# or extensions to the existing TK commands. Occasionaly, you have to use
# the commands inside this file instead of thestandard TK commands to make
# your applicatiion work better with Tix. Please read the documentations
# (programmer's guide, man pages) for information about these utility
# commands.
#


#
# kludge: should be able to handle all kinds of flags
#         now only handles "-flag value" pairs.
#
proc tixHandleArgv {p_argv p_options validFlags} {
    upvar $p_options opt
    upvar $p_argv    argv

    set old_argv $argv
    set argv {}

    tixForEach {flag value} $old_argv {
	if {[lsearch $validFlags $flag] != "-1"} {
	    # The caller will handle this option exclusively
	    # It won't be added back to the original arglist
	    #
	    eval $opt($flag,action) $value
	} else {
	    # The caller does not handle this option
	    #
	    lappend argv $flag
	    lappend argv $value
	}
    }
}

#-----------------------------------------------------------------------
# tixDisableAll -
#
# 	Disable all members in a sub widget tree
#
proc tixDisableAll {w} {
    foreach x [tixDescendants $w] {
	catch {$x config -state disabled}
    }
}

#----------------------------------------------------------------------
# tixEnableAll -
#
# 	enable all members in a sub widget tree
#
proc tixEnableAll {w} {
    foreach x [tixDescendants $w] {
	catch {$x config -state normal}
    }
}

#----------------------------------------------------------------------
# tixDescendants -
#
#	Return a list of all the member of a widget subtree, including
# the tree's root widget.
#
proc tixDescendants {parent} {
    set des {}
    lappend des $parent

    foreach w [winfo children $parent] {
	foreach x [tixDescendants $w] {
	    lappend des $x
	}
    }
    return $des
}


#----------------------------------------------------------------------
# tixForEach -
#
#	 Extension of foreach, can handle more than one names
#
#
proc tixForEach {names list body} {
    set len [llength $list]
    set i 0

    while {$i < $len} {
	foreach name $names {
	    uplevel 1 [list set $name [lindex $list $i]]
	    incr i
	}

	if {$i > $len} {
	    error "incorrect number of items in the list \{$list\}"
	}

	uplevel 1 $body
    }
}

#----------------------------------------------------------------------
# tixTopLevel -
#
#	Create a toplevel widget and unmap it immediately. This will ensure
# that this toplevel widgets will not be popped up prematurely when you
# create Tix widgets inside it.
#
#	"tixTopLevel" also provide options for you to specify the appearance
# and behavior of this toplevel.
#
#
#
proc tixTopLevel {w args} {
    set opt (-geometry) {}
    set opt (-minsize)  {}
    set opt (-maxsize)  {}
    set opt (-width)    {}
    set opt (-height)   {}

    eval toplevel $w $args
    wm withdraw $w
}

# This is a big kludge
#
#	Substitutes all [...] and $.. in the string in $args
#
proc tixInt_Expand {args} {
    return $args
}

# Print out all the config options of a widget
#
proc tixPrintConfig {w} {
    foreach opt [$w config] {
	puts $opt
    }
}

proc tixAppendBindTag {w tag} {
    bindtags $w [concat [bindtags $w] $tag]
}

proc tixAddBindTag {w tag} {
    bindtags $w [concat $tag [bindtags $w] ]
}

proc tixDeleteBindTag {w tag} {
    set newtags {}

    foreach t [bindtags $w] {
	if {$t != $tag} {
	    lappend newtags $t
	}
    }
    bindtags $w $newtags
}

proc tixSubwidgetRef {sub} {
    global tixSRef

    return $tixSRef($sub)
}

proc tixSubwidgetRetCreate {sub ref} {
    global tixSRef

    set tixSRef($sub) $ref
}

proc tixSubwidgetRetDelete {sub} {
    global tixSRef

    catch {unset tixSRef($sub)}
}

proc tixListboxGetCurrent {listbox} {
    set index [lindex [$listbox curselection] 0]

    if {$index == {}} {
	return {}
    } else {
	return [$listbox get $index]
    }

}

#----------------------------------------------------------------------
# Associate a subwidget with its mega widget "owner"
#
proc tixGetMegaWidget {w} {
    global tixMega

    return $tixMega($w)
}

proc tixSetMegaWidget {w mega} {
    global tixMega

    set tixMega($w) $mega
}

proc tixUnsetMegaWidget {w} {
    global tixMega

    catch {unset tixMega($w)}
}

# tixBusy : display busy cursors on a window
#
#
# There is a lot of kludge here because: if we simply put up a
# readonly window, that will lose double-click events
#
# ToDo: should take some additional windows to raise
#
proc tixBusy {w flag {focuswin {}}} {
    global tixBusy
    set toplevel [winfo toplevel $w]

    if {![info exists tixBusy(cursor)]} {
	set tixBusy(cursor) "[tix getbitmap hourglass] \
	    [string range [tix getbitmap hourglass.mask] 1 end]\
 	    black white"
    }

    if {$toplevel == "."} {
	set inputonly0 .__tix__busy0
	set inputonly1 .__tix__busy1
	set inputonly2 .__tix__busy2
	set inputonly3 .__tix__busy3
    } else {
	set inputonly0 $toplevel.__tix__busy0
	set inputonly1 $toplevel.__tix__busy1
	set inputonly2 $toplevel.__tix__busy2
	set inputonly3 $toplevel.__tix__busy3
    }

    if {![winfo exists $inputonly0]} {
	for {set i 0} {$i < 4} {incr i} {
	    tixInputOnly [set inputonly$i] -cursor $tixBusy(cursor)
	}
    }

    case $flag {
	on {
	    if {$focuswin != {} && [winfo id $focuswin] != 0} {
		if [info exists tixBusy($focuswin,oldcursor)] {
		    return
		}
		set tixBusy($focuswin,oldcursor) [$focuswin cget -cursor]
		$focuswin config -cursor $tixBusy(cursor)

		set x1 [expr [winfo rootx $focuswin]-[winfo rootx $toplevel]]
		set y1 [expr [winfo rooty $focuswin]-[winfo rooty $toplevel]]

		set W  [winfo width $focuswin]
		set H  [winfo height $focuswin]
		set x2 [expr $x1 + $W]
		set y2 [expr $y1 + $H]


		if {$y1 > 0} {
		    tixMoveResizeWindow $inputonly0 0   0   10000 $y1
		}
		if {$x1 > 0} {
		    tixMoveResizeWindow $inputonly1 0   0   $x1   10000
		}
		tixMoveResizeWindow $inputonly2 0   $y2 10000 10000
		tixMoveResizeWindow $inputonly3 $x2 0   10000 10000

		for {set i 0} {$i < 4} {incr i} {
		    tixMapWindow [set inputonly$i] 
		    tixRaiseWindow [set inputonly$i]
		}
		tixFlushX $w
	    } else {
		tixMoveResizeWindow $inputonly0 0 0 10000 10000
		tixMapWindow $inputonly0
		tixRaiseWindow $inputonly0
	    }
	}
	off {
	    tixUnmapWindow $inputonly0
	    tixUnmapWindow $inputonly1
	    tixUnmapWindow $inputonly2
	    tixUnmapWindow $inputonly3

	    if {$focuswin != {} && [winfo id $focuswin] != 0} {
		if [info exists tixBusy($focuswin,oldcursor)] {
		    $focuswin config -cursor $tixBusy($focuswin,oldcursor)
		    catch {unset tixBusy($focuswin,oldcursor)}
		}
	    }
	}
    }
   
}

proc tixOptionName {w} {
    return [string range $w 1 [expr [string length $w]-1]]
}

proc tixSetSilent {chooser value} {
    $chooser config -disablecallback true
    $chooser config -value $value
    $chooser config -disablecallback false
}

proc tixSetChooser {chooser value} {

    puts "obsolete command tixSetChooser, call tixSetSilent instead"

    $chooser config -disablecallback true
    $chooser config -value $value
    $chooser config -disablecallback false
}

# This command is useful if you want to ingore the arguments
# passed by the -command or -browsecmd options of the Tix widgets. E.g
#
# tixFileSelectDialog .c -command "puts foo; tixBreak"
#
#
proc tixBreak {args} {}
