tixWidgetClass tixOptionMenu {
    -classname TixOptionMenu
    -superclass tixLabelWidget
    -method {
	add disable enable 
    }
    -flag {
	-command -disablecallback -value -variable -state
    }
    -forcecall {
	-variable -state
    }
    -configspec {
	{-command command Command {}}
	{-disablecallback disableCallback DisableCallback false}
	{-state state State normal}
	{-value value Value {}}
	{-variable variable Variable {}}
    }
    -default {
	{.highlightThickness			0}
	{.takeFocus				0}
	{.frame.menubutton.relief		raised}
	{.frame.menubutton.borderWidth		2}
	{.frame.menubutton.anchor		w}
	{.frame.menubutton.highlightThickness	2}
	{.frame.menubutton.takeFocus		1}
    }
}

proc tixOptionMenu::InitWidgetRec {w} {
    upvar #0 $w data

    tixChainMethod $w InitWidgetRec
 
    set data(nItems)	0
    set data(posted)	0
    set data(varInited)	  0
}

proc tixOptionMenu::ConstructFramedWidget {w frame} {
    upvar #0 $w data

    tixChainMethod $w ConstructFramedWidget $frame

    set data(w:menubutton) [menubutton $frame.menubutton -indicatoron 1]
    set data(w:menu)       [menu $frame.menubutton.menu -tearoff 0]
    pack $data(w:menubutton) -side left -expand yes -fill both

    $data(w:menubutton) config -menu $data(w:menu)

    bind $data(w:menubutton) <Up>   [bind Menubutton <space>]
    bind $data(w:menubutton) <Down> [bind Menubutton <space>]

    tixSetMegaWidget $data(w:menubutton) $w
}

proc tixOptionMenu::SetBindings {w} {
    upvar #0 $w data

    tixChainMethod $w SetBindings
}

#----------------------------------------------------------------------
# Private methods
#----------------------------------------------------------------------
proc tixOptionMenu::Invoke {w name} {
    upvar #0 $w data

    if {"$data(-state)" == "normal"} {
	tixOptionMenu::SetValue $w $name
    }
}

proc tixOptionMenu::SetValue {w value {noUpdate 0}} {
    upvar #0 $w data

    set name $value

    if [info exists data($name,index)] {
       $data(w:menubutton) config -text $data($name,label)

       set data(-value) $value

       if {! $noUpdate} {
	   tixVariable:UpdateVariable $w
       }

       if {$data(-command) != {} && ![tixGetBoolean $data(-disablecallback)]} {
	   if {![info exists data(varInited)]} {
	       eval $data(-command) $value
	   }
       }
    } else {
	error "item \"$value\" does not exist"
    }
}

#----------------------------------------------------------------------
# Configuration
#----------------------------------------------------------------------
proc tixOptionMenu::config-state {w value} {
    upvar #0 $w data

    if {$value == "normal"} {
	$data(w:menubutton) config -state $value
    } else {
	$data(w:menubutton) config -state $value
    }
}

proc tixOptionMenu::config-value {w value} {
    upvar #0 $w data

    tixOptionMenu::SetValue $w $value

    # This will tell the Intrinsics: "Please use this value"
    # because "value" might be altered by SetValues
    #
    return $data(-value)
}

proc tixOptionMenu::config-variable {w arg} {
    upvar #0 $w data

    if [tixVariable:ConfigVariable $w $arg] {
       # The value of data(-value) is changed if tixVariable:ConfigVariable 
       # returns true
       tixOptionMenu::SetValue $w $data(-value) 1
    }
    catch {
	unset data(varInited)
    }
    set data(-variable) $arg
}

#----------------------------------------------------------------------
# Public Methdos
#----------------------------------------------------------------------
proc tixOptionMenu::add {w type name args} {
    upvar #0 $w data

    if [info exists data($name,index)] {
	error "item $name already exists in the option menu $w"
    }

    case $type {
	"command" {
	    set validOptions {
		-command -label
	    }
	    set opt(-command)		{}
	    set opt(-label)		$name

	    tixHandleOptions -nounknown  opt $validOptions $args

	    if {$opt(-command)	!= {}} {
		error "option -command cannot be specified"
	    }

	    # Create a new item inside the menu
	    #
	    eval $data(w:menu) add command $args \
		[list -label $opt(-label) \
		-command "tixOptionMenu::Invoke $w \{$name\}"]
	    set index $data(nItems)

	    # Store info about this item
	    #
	    set data($index,name) $name
	    set data($name,label) $opt(-label)
	    set data($name,index) $index

	    if {$index == 0} {
		$data(w:menubutton) config -text $data($name,label)
		set data(-value) $name
	    }

	    incr data(nItems)
	}
	"separator" {
	    $data(w:menu) add separator
	    incr data(nItems)
	}
	default {
	    error "only types \"separator\" and \"command\" are allowed"
	}
    }
}

#
# Obsolete
#
proc tixOptionMenu::Post {w} {
    upvar #0 $w data

    set rootx [winfo rootx $data(w:frame)]
    set rooty [winfo rooty $data(w:frame)]

    # adjust for the border of the menu and frame
    #
    incr rootx [lindex [$data(w:menu)  config -border] 4]
    incr rooty [lindex [$data(w:frame) config -border] 4]
    incr rooty [lindex [$data(w:menu)  config -border] 4]

    set value $data(-value)
    set y [$data(w:menu) yposition $data($value,index)]

    $data(w:menu) post $rootx [expr $rooty - $y]
    $data(w:menu) activate $data($value,index)
    grab -global $data(w:menubutton)
    set data(posted) 1
}

proc tixOptionMenu::Destructor {w} {

    tixVariable:DeleteVariable $w

    # Chain this to the superclass
    #
    tixChainMethod $w Destructor
}
