# tixMwmClient --
#
#	The MDI Client with decorations silimar to the Motif Window Manager.
#	These are dockable windows: they can be captured or released
#	dynamically.
#

tixWidgetClass tixMwmClient {
    -classname TixMwmClient
    -superclass tixVResize
    -method {
	capture borderinfo release
    }
    -flag {
	-borderbg -command -cursorfg -cursorbg -framewidth -handlesize
	-title -titlebd -titleheight -hintwidth	-parent
	-sysbitmap -minbitmap -maxbitmap -resbitmap
    }
    -configspec {
	{-borderbg borderBg BorderBg gray}
	{-command command Command {}}
	{-cursorfg cursorFg CursorColor white}
	{-cursorbg cursorBg CursorColor red}
	{-foreground foreground Foreground lightgray}
	{-framewidth frameWidth FrameWidth 3}
	{-handlesize handleSize HandleSize 32}
	{-hintwidth hintWidth HintWidth 1}
	{-parent parent Parent {}}
	{-title title Title {}}
	{-titlebd titleBd BorderWidth 1}
	{-titleheight titleHeight titleHeight {}}
	{-sysbitmap sysBitmap SysBitmap [tix getbitmap system]}
	{-minbitmap minBitmap MinBitmap [tix getbitmap minimize]}
	{-maxbitmap maxBitmap MaxBitmap [tix getbitmap maximize]}
	{-resbitmap resBitmap ResBitmap [tix getbitmap restore]}

	{-borderwidth borderWidth BorderWidth 1}
	{-height height Height 150}
	{-minheight minHeight MinHeight 40}
	{-minwidth minWidth MinWidth 120}
        {-width width Width 230}
    }
}

#----------------------------------------------------------------------
# Initialization
#----------------------------------------------------------------------
proc tixMwmClient::InitWidgetRec {w} {
    upvar #0 $w data

    tixChainMethod $w InitWidgetRec
}

proc tixMwmClient::ConstructWidget {w} {
    upvar #0 $w data

    tixChainMethod $w ConstructWidget

    $data(rootCmd) config -bd 1 -bg black

    # the four corner handles
    set r00 [frame $w.r00 -relief raised -bd $data(-borderwidth) \
	     -cursor "top_left_corner $data(-cursorbg) $data(-cursorfg)"\
	     -bg $data(-borderbg)]
    set r01 [frame $w.r01 -relief raised -bd $data(-borderwidth)\
	     -cursor "bottom_left_corner $data(-cursorbg) $data(-cursorfg)"\
	     -bg $data(-borderbg)]
    set r10 [frame $w.r10 -relief raised -bd $data(-borderwidth)\
	     -cursor "top_right_corner $data(-cursorbg) $data(-cursorfg)"\
	     -bg $data(-borderbg)]
    set r11 [frame $w.r11 -relief raised -bd $data(-borderwidth)\
	     -cursor "bottom_right_corner $data(-cursorbg) $data(-cursorfg)"\
	     -bg $data(-borderbg)]

    # the four border handles
    set bt [frame $w.bt -relief raised -bd $data(-borderwidth) \
	     -cursor "top_side $data(-cursorbg) $data(-cursorfg)"\
	     -bg $data(-borderbg)]
    set bb [frame $w.bb -relief raised -bd $data(-borderwidth)\
	     -cursor "bottom_side $data(-cursorbg) $data(-cursorfg)"\
	     -bg $data(-borderbg)]
    set br [frame $w.br -relief raised -bd $data(-borderwidth)\
	     -cursor "right_side $data(-cursorbg) $data(-cursorfg)"\
	     -bg $data(-borderbg)]
    set bl [frame $w.bl -relief raised -bd $data(-borderwidth)\
	     -cursor "left_side $data(-cursorbg) $data(-cursorfg)"\
	     -bg $data(-borderbg)]

    # the inner sunken frame
    set sunken [frame $w.sunken -relief sunken -bd $data(-borderwidth)]

    # the top bar
    set bar [frame $sunken.bar]

    # Do the buttons inside the title. they are packed, not placed
    set title [label $bar.title -anchor sw -pady 0 -padx 8\
	       -text $data(-title) -relief raised -bd $data(-titlebd)\
	     -bg $data(-borderbg) -highlightthickness 0]
    set sys [menubutton $bar.sys -relief raised -bd $data(-titlebd)\
	     -bitmap $data(-sysbitmap) -padx 0 -pady 0 -anchor center\
	     -menu $bar.sys.m\
	     -bg $data(-borderbg) -highlightthickness 0]
    set min [menubutton $bar.min -relief raised -bd $data(-titlebd)\
	     -bitmap $data(-minbitmap) -padx 0 -pady 0 -anchor center\
	     -bg $data(-borderbg) -highlightthickness 0]
    set max [menubutton $bar.max -relief raised -bd $data(-titlebd)\
	     -bitmap $data(-maxbitmap) -padx 0 -pady 0 -anchor center\
	     -bg $data(-borderbg) -highlightthickness 0]

    pack $sys -side left -fill y
    pack $max $min -side right -fill y
    pack $title -side left -fill both -expand yes

    tixMwmClient::MkSysMenu $w $bar.sys.m

    # the frame for user to use
    set frame [frame $sunken.frame]

    # Record the internal widget pathnames
    set data(w:title) $title
    set data(w:r00)   $w.r00
    set data(w:r01)   $w.r01
    set data(w:r10)   $w.r10
    set data(w:r11)   $w.r11
    set data(w:bt)    $w.bt
    set data(w:bb)    $w.bb
    set data(w:bl)    $w.bl
    set data(w:br)    $w.br
    set data(w:sys)   $sys
    set data(w:min)   $min
    set data(w:max)   $max
    set data(w:frame) $w.sunken.frame
} 

proc tixMwmClient::MkSysMenu {w menu} {
    upvar #0 $w data

    menu $menu

    $menu add command -under 0 -label "Restore    "
    $menu add command -under 0 -label "Move       "
    $menu add command -under 0 -label "Size       "
}

proc tixMwmClient::SetBindings {w} {
    upvar #0 $w data

    tixChainMethod $w SetBindings

    bind $w <Configure> "tixMwmClient::ComposeWindow $w"

    bind $data(w:r00)   <1> \
	"tixMwmClient::dragstart $w $data(w:r00)   0 %X %Y  {1  1 -1 -1}"
    bind $data(w:r01)   <1> \
	"tixMwmClient::dragstart $w $data(w:r01)   0 %X %Y  {1  0 -1  1}"
    bind $data(w:r10)   <1> \
	"tixMwmClient::dragstart $w $data(w:r10)   0 %X %Y  {0  1  1 -1}"
    bind $data(w:r11)   <1> \
	"tixMwmClient::dragstart $w $data(w:r11)   0 %X %Y  {0  0  1  1}"
    bind $data(w:bt)    <1> \
	"tixMwmClient::dragstart $w $data(w:bt)    0 %X %Y  {0  1  0 -1}"
    bind $data(w:bb)    <1> \
	"tixMwmClient::dragstart $w $data(w:bb)    0 %X %Y  {0  0  0  1}"
    bind $data(w:bl)    <1> \
	"tixMwmClient::dragstart $w $data(w:bl)    0 %X %Y  {1  0 -1  0}"
    bind $data(w:br)    <1> \
	"tixMwmClient::dragstart $w $data(w:br)    0 %X %Y  {0  0  1  0}"

    foreach win [list \
		 $data(w:r00)\
		 $data(w:r01)\
		 $data(w:r10)\
		 $data(w:r11)\
		 $data(w:bt)\
		 $data(w:bb)\
		 $data(w:bl)\
		 $data(w:br)\
		 ] {
	bind $win <B1-Motion>       "tixVResize::drag    $w %X %Y"
	bind $win <ButtonRelease-1> "tixMwmClient::dragend $w %W 0 %X %Y"
	bind $win <Any-Escape>      "tixMwmClient::dragend $w %W 1  0  0"
    }

    # special attention for the title bar
    #
    bind $data(w:title) <1> "\
	$data(w:title) config -cursor \
	    {fleur $data(-cursorbg) $data(-cursorfg)}; update idletasks;\
	tixMwmClient::dragstart $w $data(w:title) 0 %X %Y  {1  1  0  0}"
    bind $data(w:title) <ButtonRelease-1> "\
	tixMwmClient::dragend $w %W 0 %X %Y; %W config -cursor {}"
    bind $data(w:title) <B1-Motion>\
	"tixVResize::drag    $w %X %Y"
    bind $data(w:title) <Any-Escape>\
	"tixMwmClient::dragend $w %W 1  0  0"

    # the menu of the system button
    #
    bind $data(w:sys) <1> "%W config -relief sunken"
    bind $data(w:sys) <Any-ButtonRelease-1> \
	"%W config -relief raised"

    bind $data(w:max) <1> "%W config -relief sunken"
    bind $data(w:min) <1> "%W config -relief sunken"

    bind $data(w:max) <Any-ButtonRelease-1> "tixMwmClient::MaxButton $w %X %Y"
    bind $data(w:min) <Any-ButtonRelease-1> "tixMwmClient::MinButton $w %X %Y"
}

#----------------------------------------------------------------------
#                    Public methods
#----------------------------------------------------------------------
proc tixMwmClient::release {w} {
    upvar #0 $w data

    set x [winfo rootx $data(w:frame)]
    set y [winfo rooty $data(w:frame)]
    set width  [winfo width $data(w:frame)]
    set height [winfo height $data(w:frame)]

    wm release $data(w:frame) -x $x -y $y -width $width -height $height
    wm geometry $data(w:frame) "$width\x$height+$x+$y"
    wm deiconify $data(w:frame)

    tixUnmapWindow $w
}

proc tixMwmClient::borderinfo {w} {
    upvar #0 $w data

    return {6 33 6 6}
}

proc tixMwmClient::capture {w} {
    upvar #0 $w data

    wm capture $data(w:frame)
    raise $data(w:frame)
    tixMwmClient::ComposeWindow $w
    tixMapWindow $w
}


#----------------------------------------------------------------------
#                  Event Handlers
#----------------------------------------------------------------------
proc tixMwmClient::MaxButton {w x y} {
    upvar #0 $w data


    $data(w:max) config -relief raised
    if {[winfo containing $x $y] == $data(w:max)} {
	if {$data(-command) != {}} {
	    eval $data(-command) maximize
	}
    }
}

proc tixMwmClient::MinButton {w x y} {
    upvar #0 $w data

    $data(w:min) config -relief raised
    if {[winfo containing $x $y] == $data(w:min)} {
	if {$data(-command) != {}} {
	    eval $data(-command) minimize
	}
    }
}

#----------------------------------------------------------------------
#                    Internal methods
#----------------------------------------------------------------------
proc tixMwmClient::dragstart {w win depress rootx rooty mrect} {
    upvar #0 $w data

    raise $w
    update

    set wx [winfo x      $w]
    set wy [winfo y      $w]
    set ww [winfo width  $w]
    set wh [winfo height $w]

    tixVResize::dragstart $w $win $depress $rootx $rooty \
	[list $wx $wy $ww $wh] $mrect
}

proc tixMwmClient::dragend {w win isAbort x y} {
    upvar #0 $w data
    
    tixChainMethod $w dragend $win $isAbort $x $y

    if {! $isAbort} {
	set data(mdi_x)      [winfo x $w]
	set data(mdi_y)      [winfo y $w]
	set data(mdi_width)  [winfo width  $w]
	set data(mdi_height) [winfo height $w]
    }
}

proc tixMwmClient::DrawTmpLines {w} {
    upvar #0 $w data

    set x1 $data(hf:x1)
    set y1 $data(hf:y1)
    set x2 $data(hf:x2)
    set y2 $data(hf:y2)

    tixTmpLine $x1 $y1 $x2 $y1
    tixTmpLine $x1 $y2 $x2 $y2
    tixTmpLine $x1 $y1 $x1 $y2
    tixTmpLine $x2 $y1 $x2 $y2

    # One additional line to indicate the position of the title
    #
    set yh [expr "$y1+$data(-handlesize)"]
    tixTmpLine $x1 $yh $x2 $yh
}

# Place the hint frame to indicate the changes
#
proc tixMwmClient::SetHintFrame {w x1 y1 width height} {
    upvar #0 $w data

    # The four sides of the window
    #
    set x2 [expr "$x1+$width"]
    set y2 [expr "$y1+$height"]

    set rx [winfo rootx [winfo parent $w]]
    set ry [winfo rooty [winfo parent $w]]

    incr x1 $rx
    incr y1 $ry
    incr x2 $rx
    incr y2 $ry

    if {[info exists data(hf:x1)]} {
	tixMwmClient::DrawTmpLines $w
    }

    set data(hf:x1) $x1
    set data(hf:y1) $y1
    set data(hf:x2) $x2
    set data(hf:y2) $y2

    tixMwmClient::DrawTmpLines $w
}

proc tixMwmClient::ShowHintFrame {w} {
    upvar #0 $w data

    
}

proc tixMwmClient::HideHintFrame {w} {
    upvar #0 $w data

    tixMwmClient::DrawTmpLines $w
    unset data(hf:x1)
    unset data(hf:y1)
    unset data(hf:x2)
    unset data(hf:y2)
}

proc tixMwmClient::UpdateSize {w x y width height} {
    place $w -x $x -y $y -width $width	-height $height
}

# TK calls this command each time the window is resized
#
proc tixMwmClient::ComposeWindow {w} {
    upvar #0 $w data

    set width  [expr [winfo width  $w] - 2]
    set height [expr [winfo height $w] - 2]

    # place the corner handlers
    set size $data(-handlesize)

    set rx [expr "$width-$size"]
    set ry [expr "$height-$size"]

    place $w.r00 -x 0   -y 0   -width $size -height $size \
	    -bordermode inside
    place $w.r01 -x 0   -y $ry -width $size -height $size \
	    -bordermode inside
    place $w.r10 -x $rx -y 0   -width $size -height $size \
	    -bordermode inside
    place $w.r11 -x $rx -y $ry -width $size -height $size \
	    -bordermode inside

    # Place the border handlers
    #
    set size2 [expr "2 * $size"]
    set bw [expr "$width-$size2"]
    set bh [expr "$height-$size2"]

    place $w.bt  -x $size -y 0      -width $bw   -height $size \
	    -bordermode inside
    place $w.bb  -x $size -y $ry    -width $bw   -height $size \
	    -bordermode inside
    place $w.bl  -x 0     -y $size  -width $size -height $bh \
	    -bordermode inside
    place $w.br  -x $rx   -y $size  -width $size -height $bh \
	    -bordermode inside

    # Place the sunken frame
    #
    set fw [expr "$data(-framewidth) + $data(-borderwidth)"]
    set sw [expr "$width  - (2 * $fw)"]
    set sh [expr "$height - (2 * $fw)"]
    place $w.sunken -x $fw -y $fw -width $sw  -height $sh \
	    -bordermode inside

    # Place the title bar
    set tw [expr "$data(-framewidth) + (2 * $data(-borderwidth) )"]
    set aw [expr "$width - (2 * $tw)"]

    if {$data(-titleheight) == {}} {
      set data(-titleheight) \
	[expr $data(-handlesize) -$data(-framewidth) - (2*$data(-borderwidth))]
    }
    place $w.sunken.bar -x 0 -y 0 -width $aw -height $data(-titleheight)
    $data(w:sys) config -width [expr "$data(-titleheight) - 2*$data(-titlebd)"]
    $data(w:max) config -width [expr "$data(-titleheight) - 3*$data(-titlebd)"]
    $data(w:min) config -width [expr "$data(-titleheight) - 3*$data(-titlebd)"]

    # Place the user frame
    set fh [expr $sh - $data(-titleheight) - $data(-borderwidth) * 2]
    tixMoveResizeWindow $w.sunken.frame \
	$data(-borderwidth)\
	[expr $data(-titleheight) + $data(-borderwidth)] \
	$aw $fh 
    tixMapWindow $w.sunken.frame
}


