tixWidgetClass tixMatEdit {
    -classname TixMatEdit
    -superclass tixPrimitive
    -method {
	get render pick
    }
    -flag {
	-background -bg -foreground -fg
	-command -state -disabledforeground
	-ambient -diffuse -emission -specular
	-alpha -shininess
    }
    -configspec {
	{-background background Background #ffe4c4}
	{-foreground foreground Foreground black}
	{-command command Command {}}
	{-state state State normal}
	{-disabledforeground -disabledForeground DisabledForeground #606060}

	{-ambient ambient Ambient {0 0 0}}
	{-diffuse diffuse Diffuse {0 0 0}}
	{-emission emission Emission {0 0 0}}
	{-specular specular Specular {0 0 0}}
	{-alpha alpha Alpha 0}
	{-shininess shininess Shininess 10.0}
    }
    -alias {
	{-bg -background}
	{-fg -foreground}
    }
}

proc tixMatEdit::InitWidgetRec {w} {
    upvar #0 $w data

    tixChainMethod $w InitWidgetRec

    set data(active)    1
    set data(radio)     0
    set data(flag)      0
    set data(dialog)    .edit_color_mat
    set data(amb_v)     1
    set data(dif_v)     1
    set data(spe_v)     1
}

#--------------------------
# CREATE WIDGET
#--------------------------
proc tixMatEdit::ConstructWidget {w} {
    upvar #0 $w data
 
    tixChainMethod $w ConstructWidget

    #1 create the Material Sphere
    #-------------------
    tixMatSphere $w.matd -relief raised -borderwidth 4
    set data(matd) $w.matd

    #2 create the scales
    #-------------------
    frame $w.f4

    #2.1 amb
    #-------
    frame $w.f1
    radiobutton $w.b1 -relief flat -variable [format "%s(radio)" $w]\
 	-command "tixMatEdit::EditColor $w -ambient"
    set data(w:amb) [scale $w.amb -from 0 -to 100 -length 5c \
	-orient horizontal\
        -label "Ambient" -command "tixMatEdit::ScaleChanged $w -ambient"]
    pack append $w.f1 $w.b1 {left} $data(w:amb) {right expand fill}

    #2.2 dif
    #-------
    frame $w.f2
    radiobutton $w.b2 -relief flat -variable [format "%s(radio)" $w]\
	-command "tixMatEdit::EditColor $w -diffuse"
    set data(w:dif) [scale $w.dif -from 0 -to 100 -length 5c \
	-orient horizontal\
	-label "Diffuse" -command "tixMatEdit::ScaleChanged $w -diffuse"]
    pack append $w.f2 $w.b2 {left} $data(w:dif) {right expand fill}

    #2.3 spe
    #-------
    frame $w.f3
    radiobutton $w.b3 -relief flat -variable [format "%s(radio)" $w]\
	-command "tixMatEdit::EditColor $w -specular"
    set data(w:spe) [scale $w.spe -from 0 -to 100 -length 5c \
	-orient horizontal\
	-label "Specular" -command "tixMatEdit::ScaleChanged $w -specular"]
    pack append $w.f3 $w.b3 {left} $data(w:spe) {right expand fill}

    #3 pack the scales
    #-----------------
    pack append $w.f4 \
	$w.f1 {top expand fill}\
	$w.f2 {top expand fill}\
	$w.f3 {top expand fill}

    pack append $w $w.matd {left padx 10 pady 10} $w.f4 {right expand fill}

    tixMatEdit::SetScales $w
}

proc tixMatEdit::SetBindings {w} {
    upvar #0 $w data

    tixChainMethod $w SetBindings

    bind $w <Destroy> "tixMatEdit::Destroy $w"
}

#----------------------------------------------------------------------
#                           CONFIG OPTIONS
#----------------------------------------------------------------------
proc tixMatEdit::config-state {w arg} {
    upvar #0 $w data

    if {$arg == "normal"} {
	$data(w:amb) config -state normal -fg $data(-foreground)
	$data(w:dif) config -state normal -fg $data(-foreground)
	$data(w:spe) config -state normal -fg $data(-foreground)

	$w.b1 config -state normal
	$w.b2 config -state normal
	$w.b3 config -state normal

	if [winfo exists $data(dialog)] {
	    $data(coledit) config -state normal
	}
    } else {
	$data(w:amb) config -state disabled -fg $data(-disabledforeground)
	$data(w:dif) config -state disabled -fg $data(-disabledforeground)
	$data(w:spe) config -state disabled -fg $data(-disabledforeground)

	$w.b1 config -state disabled
	$w.b2 config -state disabled
	$w.b3 config -state disabled

	if [winfo exists $data(dialog)] {
	    $data(coledit) config -state disabled
	}
    }
}

proc tixMatEdit::config-ambient {w arg} {
    tixMatEdit::ConfigMat $w -ambient  amb_v $arg
}

proc tixMatEdit::config-diffuse {w arg} {
    tixMatEdit::ConfigMat $w -diffuse  dif_v $arg
}

proc tixMatEdit::config-specular {w arg} {
    tixMatEdit::ConfigMat $w -specular spe_v $arg
}

proc max3 {a b c} {
    if {$a > $b} {
	if {$a > $c} {
	    return $a
	} else {
	    return $c
	}
    } else {
	if {$b > $c} {
	    return $b
	} else {
	    return $c
	}
    }
}

#----------------------------------------------------------------------
#                           INTERNAL METHODS
#----------------------------------------------------------------------
proc tixMatEdit::ConfigMat {w flag flagv arg} {
    upvar #0 $w data
    
    set r [lindex $arg 0]
    set g [lindex $arg 1]
    set b [lindex $arg 2]
    set m [max3 $r $g $b]

    if {$m > "0.0"} {
	set data($flag) [list \
	    [expr "$r / $m"] \
	    [expr "$g / $m"] \
	    [expr "$b / $m"]]
	set data($flagv) $m
    } else {
	set data($flag) {1 1 1}
	set data($flagv) 0
    }

    tixMatEdit::SetScales $w
    $data(matd) config $flag $arg

    if {[winfo exists $data(dialog)] && $flag == $data(flag)} {
	$data(coledit) config -rgb $data($flag)
    }
}

proc tixMatEdit::SetScales {w} {
    upvar #0 $w data

    $data(w:amb) set [expr "int($data(amb_v) * 100)"]
    $data(w:dif) set [expr "int($data(dif_v) * 100)"]
    $data(w:spe) set [expr "int($data(spe_v) * 100)"]
}

# $$temp : no one calls this proc?
proc tixMatEdit::ResetAll {w} {
    upvar #0 $w data

    set data(active) 0

    set r [lindex $data(-ambient) 0]
    set g [lindex $data(-ambient) 1]
    set b [lindex $data(-ambient) 2]
    $data(matd) config -ambient \
	[list \
	     [expr $r*$data(amb_v)]\
	     [expr $g*$data(amb_v)]\
	     [expr $b*$data(amb_v)]\
	]

    set r [lindex $data(-diffuse) 0]
    set g [lindex $data(-diffuse) 1]
    set b [lindex $data(-diffuse) 2]
    $data(matd) config -diffuse \
	[list \
	     [expr $r*$data(dif_v)]\
	     [expr $g*$data(dif_v)]\
	     [expr $b*$data(dif_v)]\
	]
 
    set r [lindex $data(-specular) 0]
    set g [lindex $data(-specular) 1]
    set b [lindex $data(-specular) 2]
    $data(matd) config -specular \
	[list \
	     [expr $r*$data(spe_v)]\
	     [expr $g*$data(spe_v)]\
	     [expr $b*$data(spe_v)]\
	]

    tixMatEdit::SetScales $w
    set data(active) 1
}

# This proc does two things
# 1: update the mat diagram to reflect the change.
# 2: acknowledge the owner of the material editor of the change. 
proc tixMatEdit::ScaleChanged {w flag scale_val} {
    upvar #0 $w data

    if {$data(active) == "0"} {
	return
    } else {
	case $flag in {
	    -ambient {
		set data(amb_v) [expr $scale_val/100.0]
		set r [lindex $data(-ambient) 0]
		set g [lindex $data(-ambient) 1]
		set b [lindex $data(-ambient) 2]
		set ambValues [list \
		    [expr $r*$data(amb_v)]\
		    [expr $g*$data(amb_v)]\
		    [expr $b*$data(amb_v)]]
		$data(matd) config $flag $ambValues
	    }
	    -diffuse {
		set data(dif_v) [expr $scale_val/100.0]
		set r [lindex $data(-diffuse) 0]
		set g [lindex $data(-diffuse) 1]
		set b [lindex $data(-diffuse) 2]
		set difValues [list \
		    [expr $r*$data(dif_v)]\
		    [expr $g*$data(dif_v)]\
		    [expr $b*$data(dif_v)]]
		$data(matd) config $flag $difValues
	    }
	    -specular {
		set data(spe_v) [expr $scale_val/100.0]
		set r [lindex $data(-specular) 0]
		set g [lindex $data(-specular) 1]
		set b [lindex $data(-specular) 2]
		set speValues [list \
		    [expr $r*$data(spe_v)]\
		    [expr $g*$data(spe_v)]\
		    [expr $b*$data(spe_v)]]
		$data(matd) config $flag $speValues
	    }
	}

	if {$data(-command) != {}} {
	    set r1 [lindex $data(-ambient) 0]
	    set g1 [lindex $data(-ambient) 1]
	    set b1 [lindex $data(-ambient) 2]

	    set r2 [lindex $data(-diffuse) 0]
	    set g2 [lindex $data(-diffuse) 1]
	    set b2 [lindex $data(-diffuse) 2]

	    set r3 [lindex $data(-specular) 0]
	    set g3 [lindex $data(-specular) 1]
	    set b3 [lindex $data(-specular) 2]

	    set matValues [list \
		    [expr $r1 * $data(amb_v)]\
		    [expr $g1 * $data(amb_v)]\
		    [expr $b1 * $data(amb_v)]\
		    [expr $r2 * $data(dif_v)]\
		    [expr $g2 * $data(dif_v)]\
		    [expr $b2 * $data(dif_v)]\
		    [expr $r3 * $data(spe_v)]\
		    [expr $g3 * $data(spe_v)]\
		    [expr $b3 * $data(spe_v)]]
	    eval $data(-command) $flag {$matValues}
	}
    }
}

# Pops up a color dialog and change the base color of a, d or sp
#----------------------------------------------------------------------
proc tixMatEdit::EditColor {w flag} {
    upvar #0 $w data

    if {$data(active) == "0"} {
	return
    } else {

	if {$data(flag) == $flag} {
	    tixDialogWithdraw $data(dialog) -xy
	    set data(flag) 0
	    set data(active) 1
	    set data(radio) 0
	    return
	}

	set data(active) 0

	 set data(dialog) .color_edit_mat
	 if [winfo exists $data(dialog)] {
	     tixDialogRestore $data(dialog) -xy
	 } else {
	     toplevel $data(dialog)

	     tixColorEdit $data(dialog).edit -relief raised

	     tixDlgBtns $data(dialog).btns
	     $data(dialog).btns add ok -text "OK" \
		 -width 6 -command "tixMatEdit::EditColor $w $flag"

	     pack $data(dialog).edit -fill both -expand yes
	     pack $data(dialog).btns -fill x

	     set data(coledit) $data(dialog).edit
	     set data(colbtns) $data(dialog).btns
	 }

	 wm protocol $data(dialog) WM_DELETE_WINDOW \
	    "tixMatEdit::EditColor $w $flag"

	 $data(coledit) config -rgb $data($flag)
	 $data(coledit) config -command "tixMatEdit::ColorChanged $w"
	 $data(colbtns) subwidget ok \
	    config -command "tixMatEdit::EditColor $w $flag"

	 set data(flag) $flag
	 tixDialogRestore $data(dialog) -xy

	set data(active) 1
    }
}

# Respond to the changes in the color dialog
#-------------------------------------------
proc tixMatEdit::ColorChanged {w r g b} {
    upvar #0 $w data

    if {$data(active) == "0"} {
	return
    }

    set data($data(flag)) "$r $g $b"

    case $data(flag) in {
	-ambient {
	    tixMatEdit::ScaleChanged $w $data(flag) [$data(w:amb) get]
	}
	-diffuse {
	    tixMatEdit::ScaleChanged $w $data(flag) [$data(w:dif) get]
	}
	-specular {
	    tixMatEdit::ScaleChanged $w $data(flag) [$data(w:spe) get]
	}
    }
}

proc tixMatEdit::Destroy {w} {
    upvar #0 $w data

    if [winfo exists $data(dialog)] {
	tixDialogDestroy $data(dialog) -xy
    }
}
