tixWidgetClass tixBuffButton {
    -classname tixBuffButton
    -superclass tixPrimitive
    -method {
	invoke
    }
    -flag {
	-text
    }
    -static {
    }
    -configspec {
	{-text text Text {}}
    }
    -alias {
    }
    -default {
    }
}

proc tixBuffButton::InitWidgetRec {w} {
    upvar #0 $w data

    tixChainMethod $w InitWidgetRec

}

proc tixBuffButton::ConstructWidget {w} {
    upvar #0 $w data

    tixChainMethod $w ConstructWidget

    $data(rootCmd) config -bd 1 -bg black -highlightthickness 1 \
	-takefocus 1
	
    set data(w:f1) [frame $w.f1 -bg #404040 -bd 1 -relief raised]
    set data(w:button)  [button $w.button -highlightthickness 0 -takefocus 0 \
	-text $data(-text)]

    pack $data(w:f1) -in $w -expand yes -fill both
    pack $data(w:button) -in $data(w:f1) -expand yes -fill both
}

#----------------------------------------------------------------------
#                           CONFIG OPTIONS
#----------------------------------------------------------------------
proc tixBuffButton::config-padx {w arg} {
    upvar #0 $w data

    foreach item $data(g:buttons) {
	pack configure $w.$item -padx $arg
    }
}

proc tixBuffButton::config-pady {w arg} {
    upvar #0 $w data

    foreach item $data(g:buttons) {
	pack configure $w.$item -pady $arg
    }
}

proc tixBuffButton::config-state {w arg} {
    upvar #0 $w data

    foreach item $data(g:buttons) {
	$item config -state $arg
    }
}

#----------------------------------------------------------------------
# Methods
#                     WIDGET COMMANDS
#----------------------------------------------------------------------
proc tixBuffButton::add {w name args} {
    upvar #0 $w data

    eval button $w.$name $args
    if {$data(-orientation) == "horizontal"} {
	pack $w.$name -side left -expand yes -fill y\
	    -padx $data(-padx) -pady $data(-pady)
    } else {
	pack $w.$name -side top -expand yes  -fill x\
	    -padx $data(-padx) -pady $data(-pady)
    }

    # allow for subwidget access
    #
    lappend data(g:buttons) $name
    set data(w:$name) $w.$name

    return $w.$name
}

proc tixBuffButton::button {w name args} {
    return [eval tixCallMethod $w subwidget $name $args]
}

proc tixBuffButton::buttons {w args} {
    return [eval tixCallMethod $w subwidgets -group buttons $args]
}

#
# call the command
proc tixBuffButton::invoke {w name} {
    upvar #0 $w data

    $w.$name invoke
}
