#!/usr/local/bin/tclsh

set groups {general legal porting port trivia}

set group_names(general) {
    General Questions
}
set group_names(legal) {
    Legal Issues
}
set group_names(porting) {
    Porting from Tix 3.6 to Tix 4.0
}
set group_names(port) {
    Question About Specific Platforms
}
set group_names(trivia) {
    Trivia
}
set group_shortnames(general)	G
set group_shortnames(legal)	L
set group_shortnames(porting)	P
set group_shortnames(port)	S
set group_shortnames(trivia)	T

#----------------------------------------------------------------------
#
#----------------------------------------------------------------------
proc start_group {group} {
    global cur_group cur_index
    set cur_group $group
    set cur_index 0
}

proc q {question} {
    global cur_group cur_index
    upvar $cur_group g
    incr cur_index

    set g($cur_index) $question
}

proc a {answer} {
    global cur_group cur_index
    upvar $cur_group:a g

    set g($cur_index) $answer
}

#----------------------------------------------------------------------
# General questions
#----------------------------------------------------------------------
start_group general

q {
    What does the "<code>-disablecallback</code>"
    option do?
}

a {

    Many Tix widgets have both a <code>-value</code> option and a
    <code>-command</code> option. Any modification of the
    <code>-value</code> will cause the <code>-command</code> callback
    to be executed. Sometimes this is undesirable. For example,
    calling "<code>config -value</code>" inside the callback procedure
    will cause the callback to be re-entered and thus an infinite
    recursion. <p>

    The <code>-disablecallback</code> can be used to advoid this
    problem. When this option is set, the <code>-command</code>
    callback will not be executed even if the -value of a widget is
    changed. Therefore, if you need to modify the -value of a widget
    inside its callback, do this:

    <blockquote><pre>
    proc my_callback {w} {
	$w config -disablecallback true
	$w config value blah
	$w config -disablecallback false
    }
    </pre></blockquote>

    If you find this too troublesome, you can call the command tixSetSilent:

    <blockquote><pre>
    proc my_callback {w} {
	tixSetSilent $w blah
    }
    </pre></blockquote>
}

q {
    How do I set the width of the entry subwidget inside the tixControl widget?
}


a {

You can use the option database or the -options flag to set the
configuration options of the subwidgets. E.g: <pre>

option add *TixControl*entry.width 10
</pre>

  OR

<pre>
tixControl .c -options {
   entry.width  10
}
</pre>
}

q {
    What is the "<code>setslient</code>" method?
}

a {
     This is an obsolete method. You could use it to achieve the same
     effect as the <code>-disablecallback</code> option.
     <code>selsilent</code> used to be a widget command for the
     ComboBox, Control, etc. It has been removed since Tix 4.0a4 and
     replaced by the <code>tixSetSilent</code> command. Please note
     that <code>tixSetSilent</code> is not a widget command but an
     external procedure.
}

q {
    Is there a Tix interface builder
    in the works?
}

a {

    Yes. But I don't know when it will be finished. (probably in 96).

}


q {
    Can you tell me about the syntax of tixForm
}

a {
    Please see the file <a href="../man/Form.html">man/Form.html</a>
    or <a href="../man/Form.n">man/Form.n</a>.
}


#----------------------------------------------------------------------
# Legal questions
#----------------------------------------------------------------------
start_group legal

q {
    I am developing a commercial application, can I use Tix 4.0?
}
a {
    Yes. The legal and copyright status of Tix is exactly the same as
    that of TK (with only one catch, see [2]). If you are bold enough
    to use TK in your commercial app, you should be able to use Tix
    for free.
}

q {
    I am developing a commercial GUI
    builder, something like zApp, can I use Tix 4.0?</b><p>
}

a {

    You can use every aspect of Tix <i><b>except</b></i> the
    <code>tixForm</code> geometry manager (please read the file <a
    href="LEGAL.html"> LEGAL.html </a>). That means, for example, your
    product can include the <code>TixComboBox</code> and other
    widgets. However, <code>TixForm</code>, including the TCL command,
    the C library code or the documentation, <b><i> cannot </i></b> be
    included into your product at all. You are also explicitly
    prohibited form examining, imitating, copying,
    reverse-enrgineering or otherwise using the file
    <code>tixForm.c</code>.

}

q {
    Can I use tixForm in my commercial app which is not a GUI builder.
}

a {
    Yes.
}

q {
    I am writing a free GUI builder, can I
    use tixForm in it?
}

a {
    Yes, provided you distributed your GUI builder freely. That means
    it should be no less free than at least one of the following:
    <OL>
    <li> GNU Public License
    <li> "Berkeley" type license.
    </ol><p>
}

q {
    Will future versions of Tix be
    free?
}

a {
    I don't have much control over this. The availability of future
    versions (i.e., beyond the final release of Tix 4.0) can be
    affected by many reasons. However, Tix 4.0 will be kept freely
    distributed for its lifetime or mine, whichever is longer.
}

#----------------------------------------------------------------------
# Porting from Tix 3.6 to tix 4.0
#----------------------------------------------------------------------
start_group porting

q {
    What happened to the <code>tixInit</code> command?
}

a {
    You don't need to use it anymore. It is provided in Tix 4.0 only for
    backward compatibility.
}

q {
    How do I set the schemes and fontsets in Tix 4.0?
}

a {
    You can set the color schemes and fontsets using the standard X
    resource database (.Xdefaults file). You can add these two lines
    in the user's .Xdefaults file: <pre>

	*TixScheme:   Gray
	*TixFontSet:  14Point </pre>

    If you want to switch color schemes and fontsets during run time,
    you can issue the following commands: <pre>
	tix config -scheme Gray -fontset 14Point
    </pre>

    Please read the <a href=../man/tix.html>tix</a> manual page for
    more details
}


#----------------------------------------------------------------------
# Portability questions
#----------------------------------------------------------------------
start_group port

q {
    <b>Solaris 2.4:</b>
    Filenames in FileSelectBox are chopped off.
}

a {
    <b>Problem:</b>
    <blockquote>

    With Tix4.0a7 (and also with Tix4.0a6) on Solaris 2.4, when
    running the widget demo, in tixFileSelectBox, in the two scolling
    lists (for Files an Directories), some of the file and directory
    names have their first 2 letters chopped off. And some files are
    repeated.

    </blockquote>
     
    <b>Solution:</b> tixwish has some conflicts with /usr/ucblib/libucb.so.1
    and you should not linke it tixwish (you don't need it). Here is
    a solution provided by Charles L Ditzel
    (<i>charles@hanami.cyberspace.com</i>):

    <blockquote>
    To fix the problem I was having, all I did was:

    <pre>
   unsetenv LD_LIBRARY_PATH
   set my PATH to something basic like:
     /usr/bin:/usr/ccs/bin:/bin:/usr/openwin/bin:/opt/SUNWspro/bin
   removed config.cache
   ./configure
   make clean
   make
    </pre>
 
    and now it works!! Must have been something in my old
    <code>PATH</code> or <code>LD_LIBRARY_PATH</code> that was
    causing it to pick up <code>/usr/ucblib/libucb.so</code>.

    </blockquote>
}
#----------------------------------------------------------------------
# Trivia
#----------------------------------------------------------------------
start_group trivia

q {
    How do you pronunce "Ioi"
}

a {
    You take the first "I" as a "Y" : so it goes like "Yoi"
}

q {
    How on earth did you pick such a name
}

a {

    Well, I didn't pick it myself. Nor did my parents. I was born in
    China and then my family moved to <a
    href=http://www.seas.upenn.edu/~ioi/macau.html> Macao </a> , which
    was under a Portugese government. So they made a transliteration
    of my Chinese name into Portugese. And since there isn't the
    character "Y" in Portugese, they were forced name me using a
    symmetrical binary string.

}

#----------------------------------------------------------------------
# Header, etc of this document
#----------------------------------------------------------------------

set header {
    <center><h1>Tix Frequently Asked Questions</h1></center>
}

set toc {
    <h3>Table of Contents</h3>
}
#----------------------------------------------------------------------
# Generate the FAQ.html file
#----------------------------------------------------------------------

puts $header
puts $toc
puts <DL>

foreach g $groups {
    upvar #0 $g group

    puts <DT><i><b>$group_names($g)</b></i><DD><ul>

    set i 1
    set names [lsort [array names group]]
    foreach name $names {
	puts -nonewline "<li> <a href=#$g.$name> "
	puts -nonewline "\[$group_shortnames($g).$i\] </a> "
	puts -nonewline "$group($name)"

	incr i
    }
    puts </ul><p>
}

puts </DL>

foreach g $groups {
    upvar #0 $g group
    upvar #0 $g:a answer

    puts <hr>
    puts <h3>$group_names($g)</h3>
    puts <DL>

    set i 1
    set names [lsort [array names group]]
    foreach name $names {
	puts -nonewline "<DT> <b><a name=$g.$name> "
	puts -nonewline "\[$group_shortnames($g).$i\] </a> "
	puts -nonewline "$group($name)</b>"

	puts "<p>"

	puts <DD>
	puts $answer($name)
	puts <p>


	incr i
    }

    puts </DL>
}
