/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file clos_wi3.c non ansi-c per windows 3.1 */
#include "clos.h"
#pragma hdrstop
#include "closnans.h"

long FAR PASCAL _export GraphWindowProc(HWND hWnd, WORD message,WORD wParam, LONG lParam);
HBRUSH	 MakeBrush(void);
HPEN	 MakePen(void);
BOOL	 MakePalette(void);
void	 DestroyPalette(void);
COLORREF AddColorToPalette(COLORREF);
BOOL	 OpenGraphWindow(int);
BOOL	 CloseGraphWindow(void);
void	 PaintGraphWindow(void);
BOOL	 SaveGraphWindow(char *FileName);

HWND	 hGraphWindow	=NULL;			//EXTERN
char	 *szGraphWindow	=" Graphic Lisp ";
HANDLE	 ProgramInstance=NULL;
HDC	 VirtualDev	=NULL;
HDC	 WinDev		=NULL;
int	 GraphRow	=0;
int	 GraphCol	=0;
int	 GraphColors	=0;
BOOL	 Changed	=FALSE;
BOOL	 GraphDynRedraw	=TRUE;
BOOL	 HasCaption	=TRUE;

HBITMAP  OldBitmap	=NULL;
HPEN	 OldPen		=NULL;
HBRUSH	 OldBrush	=NULL;
HPALETTE OldPalette	=NULL;

int	 PenStyle	=1; //PS_SOLID
int	 PenWidth	=1;
COLORREF PenColor	=RGB(255,255,255);

int	 BrushStyle 	=1;
COLORREF BrushColor     =RGB(255,255,255);

HPALETTE Palette	=NULL;
int 	 PalEntries	=0;

int	 PenTypes[6]	={PS_NULL,PS_SOLID,PS_DASH,PS_DOT,PS_DASHDOT,PS_DASHDOTDOT};
int	 BrushTypes[6]	={HS_HORIZONTAL,HS_VERTICAL,HS_CROSS,HS_BDIAGONAL,HS_FDIAGONAL,HS_DIAGCROSS};

void RegisterGraphWindow(HANDLE hInstance)      
{
 WNDCLASS wcHdumpClass;

 wcHdumpClass.lpszClassName = szGraphWindow;
 wcHdumpClass.hInstance     = hInstance;
 wcHdumpClass.lpfnWndProc   = (WNDPROC)GraphWindowProc;
 wcHdumpClass.hCursor       = LoadCursor(hInstance, MAKEINTRESOURCE(104));
 wcHdumpClass.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(ICO_GRAPH));
 wcHdumpClass.lpszMenuName  = NULL;
 wcHdumpClass.hbrBackground = GetStockObject(BLACK_BRUSH);
 wcHdumpClass.style         = CS_BYTEALIGNWINDOW | CS_CLASSDC | CS_OWNDC | CS_DBLCLKS;
 wcHdumpClass.cbClsExtra    = 0;
 wcHdumpClass.cbWndExtra    = 0;

 // Register the class
 RegisterClass(&wcHdumpClass);
 ProgramInstance=hInstance;
}

void UpdateGraphWindow(void)
{
 if(Changed && hGraphWindow)InvalidateRect(hGraphWindow,NULL,FALSE);
 Changed=FALSE;
}

void GraphScroll(int sb,int type,int p)
{
  int pos;
  pos=GetScrollPos(hGraphWindow,sb);
  switch(type){
    case SB_LINEUP:pos--;break;
    case SB_LINEDOWN:pos++;break;
    case SB_PAGEUP:pos-=10;break;
    case SB_PAGEDOWN:pos+=10;break;
    case SB_THUMBTRACK:
    case SB_THUMBPOSITION:
      pos=p;
      break;
    default:return;
  }
  SetScrollPos(hGraphWindow,sb,pos,TRUE);
  SetWindowOrg(WinDev,
    GetScrollPos(hGraphWindow,SB_HORZ),
    GetScrollPos(hGraphWindow,SB_VERT)
  );
  InvalidateRect(hGraphWindow,NULL,FALSE);
}

void ResizeScrollers(void)
{
 RECT r;
 int minr,maxrx,maxry,i;
 BOOL org=FALSE;

 GetWindowRect(hGraphWindow,&r);
 r.left  +=GetSystemMetrics(SM_CXFRAME);
 r.right -=GetSystemMetrics(SM_CXFRAME);
 r.top   +=GetSystemMetrics(SM_CYFRAME)+(HasCaption?(GetSystemMetrics(SM_CYCAPTION)-1):0);
 r.bottom-=GetSystemMetrics(SM_CYFRAME);

 GetScrollRange(hGraphWindow,SB_HORZ,&minr,&maxrx);
 if( r.right-r.left==GraphCol ){
   SetScrollRange(hGraphWindow,SB_HORZ,0,0,FALSE);
   SetScrollPos  (hGraphWindow,SB_HORZ,0  ,org=maxrx?TRUE:FALSE);
 }else{
   i=GraphCol-(r.right-r.left);
   if(GetScrollPos(hGraphWindow,SB_HORZ)>i){
     SetScrollPos (hGraphWindow,SB_HORZ,i,FALSE);
     org=TRUE;
   }
   SetScrollRange (hGraphWindow,SB_HORZ,0,i,TRUE );
 }
 
 GetScrollRange(hGraphWindow,SB_VERT,&minr,&maxry);
 if( r.bottom-r.top==GraphRow ){
   SetScrollRange(hGraphWindow,SB_VERT,0,0,FALSE);
   SetScrollPos  (hGraphWindow,SB_VERT,0  ,org=maxry?TRUE:FALSE);
 }else{
   i=GraphRow-(r.bottom-r.top);
   if(GetScrollPos(hGraphWindow,SB_VERT)>i){
     SetScrollPos (hGraphWindow,SB_VERT,i,FALSE);
     org=TRUE;
   }
   SetScrollRange (hGraphWindow,SB_VERT,0,i,TRUE );
 }
 if(org){
   SetWindowOrg(WinDev,
    GetScrollPos(hGraphWindow,SB_HORZ),
    GetScrollPos(hGraphWindow,SB_VERT)
   );
   InvalidateRect(hGraphWindow,NULL,FALSE);
 }
}

long FAR PASCAL _export GraphWindowProc(HWND hWnd, WORD message,WORD wParam, LONG lParam)
{
 RECT r;
 switch(message){
  case WM_LBUTTONDBLCLK:
    HasCaption^=1;
    GetWindowRect(hWnd,&r);
    SetWindowLong(hWnd,GWL_STYLE,HasCaption?
      GetWindowLong(hWnd,GWL_STYLE)|WS_CAPTION:
      GetWindowLong(hWnd,GWL_STYLE)&(~WS_CAPTION)
    );
    //SetWindowPos(hWnd,NULL,0,0,r.right-r.left,r.bottom-r.top+(HasCaption?+1:-1)*GetSystemMetrics(SM_CYCAPTION),SWP_NOZORDER|SWP_NOMOVE|SWP_DRAWFRAME);
    SetWindowPos(hWnd,NULL,0,0,r.right-r.left,r.bottom-r.top,SWP_NOZORDER|SWP_NOMOVE|SWP_DRAWFRAME);
    InvalidateRect(hWnd,NULL,FALSE);
    return 0;
  case WM_CREATE:
    AppendMenu(GetSystemMenu(hWnd,FALSE),MF_SEPARATOR,0,NULL);
    AppendMenu(GetSystemMenu(hWnd,FALSE),MF_ENABLED|(GraphDynRedraw?MF_CHECKED:MF_UNCHECKED),0x1000,"Dynamic Redraw");
    return 0;
  case WM_SETFOCUS:
    if(wParam!=hClosWindow){
      PostMessage(hClosWindow,WM_SETFOCUS,NULL,0);
      SetWindowPos(hClosWindow,hWnd,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
    }
    return 0;
  case WM_KILLFOCUS:
    if(wParam!=hClosWindow){
      PostMessage(hClosWindow,WM_KILLFOCUS,NULL,0);
    }
    return 0;
  case WM_PAINT:
    PaintGraphWindow();
    return 0;
  case WM_CLOSE:
    CloseGraphWindow();
    return 0;
  case WM_SIZE:
    ResizeScrollers();
    return 0;
  case WM_GETMINMAXINFO:
    ((MINMAXINFO FAR *)lParam)->ptMaxTrackSize.y=min(GetSystemMetrics(SM_CYSCREEN)+GetSystemMetrics(SM_CYFRAME)*2,GraphRow+GetSystemMetrics(SM_CYFRAME)*2+(HasCaption?(GetSystemMetrics(SM_CYCAPTION)-1):0));
    ((MINMAXINFO FAR *)lParam)->ptMaxTrackSize.x=GraphCol+GetSystemMetrics(SM_CXFRAME)*2;
    ((MINMAXINFO FAR *)lParam)->ptMaxSize.y     =min(GetSystemMetrics(SM_CYSCREEN)+GetSystemMetrics(SM_CYFRAME)*2,GraphRow+GetSystemMetrics(SM_CYFRAME)*2+(HasCaption?(GetSystemMetrics(SM_CYCAPTION)-1):0));
    ((MINMAXINFO FAR *)lParam)->ptMaxSize.x     =GraphCol+GetSystemMetrics(SM_CXFRAME)*2;
    return 0;
  case WM_HSCROLL:
    GraphScroll(SB_HORZ,wParam,LOWORD(lParam));
    return 0;
  case WM_VSCROLL:
    GraphScroll(SB_VERT,wParam,LOWORD(lParam));
    return 0;
  case WM_QUERYNEWPALETTE:
    SelectPalette(VirtualDev,Palette,FALSE);
    RealizePalette(VirtualDev);
    SelectPalette(WinDev,Palette,FALSE);
    RealizePalette(WinDev);
    return 0;
  case WM_SYSCOMMAND:
    if(wParam==0x1000){
      GraphDynRedraw^=TRUE;
      CheckMenuItem(GetSystemMenu(hWnd,FALSE),0x1000,MF_BYCOMMAND|(GraphDynRedraw?MF_CHECKED:MF_UNCHECKED));
      return 0;
    }
 }
 return DefWindowProc(hWnd,message,wParam,lParam);
}

HBRUSH MakeBrush(void)
{
 LOGBRUSH lb;

 lb.lbColor=BrushColor;
 if(BrushStyle==0){
   lb.lbStyle=BS_NULL;
   lb.lbHatch=0;
 }else{
   if(BrushStyle==1){
     lb.lbStyle=BS_SOLID;
     lb.lbHatch=0;
   }else{
     lb.lbStyle=BS_HATCHED;
     lb.lbHatch=BrushTypes[BrushStyle-2];
   }
 }
 return CreateBrushIndirect(&lb);
}

HPEN MakePen(void)
{
 return CreatePen(PenTypes[PenStyle],PenWidth,PenColor);
}

BOOL MakePalette(void)
{
 LPLOGPALETTE lp;             // ResizePalette SetPaletteEntries RealizePalette
 int i;

 lp = (LPLOGPALETTE)malloc(sizeof(LOGPALETTE)+256*sizeof(PALETTEENTRY));
 if(!lp)return FALSE;
 lp->palNumEntries = 256;
 lp->palVersion = 0x300;

 for(i=0;i<256;i++){
   lp->palPalEntry[i].peFlags=PC_RESERVED;
   lp->palPalEntry[i].peRed  =0;
   lp->palPalEntry[i].peGreen=0;
   lp->palPalEntry[i].peBlue =0;
 }
 Palette=CreatePalette(lp);
 free(lp);
 if(!Palette)return FALSE;
 PalEntries=0;

 OldPalette=SelectPalette(VirtualDev,Palette,FALSE);
 if(GraphColors<=4 || GraphColors==24){
   /* se ci sono 16 colori allora non usa la palette */
   /*          (usa quella di default) 	             */
   /* se ce ne sono 256 usa la palette 		     */
   /* altrimenti ce ne sono 2^24 e non la usa        */
   SelectPalette(VirtualDev,OldPalette,FALSE);
   DeleteObject(Palette);
   Palette=OldPalette;
   OldPalette=NULL;
 }
 return TRUE;
}

void DestroyPalette(void)
{
 if(OldPalette)DeleteObject(SelectPalette(VirtualDev,OldPalette,FALSE));
}

COLORREF AddColorToPalette(COLORREF c)
{
 PALETTEENTRY pe;

 if(GraphColors<=4 || GraphColors==24 ){     /*   !       */
   /* o ha 16 colori oppure ne ha 2^16 o 2^24 ( tr color)*/
   return c&0x00ffffffL;
 }
 if(PalEntries<256){
   pe.peRed  =GetRValue(c);
   pe.peGreen=GetGValue(c);
   pe.peBlue =GetBValue(c);
   pe.peFlags=PC_RESERVED;
   AnimatePalette(Palette,PalEntries++,1,&pe);
 }
 return  0x02000000L|(c&0x00ffffffL); // PALETTERGB( c )
}


BOOL OpenGraphWindow(int mode)
{
 HBITMAP bmp;
 HDC sdev;
 HPEN p;
 HBRUSH b;

 /* mode pu andare da 1 a 20 */
 if(mode<1 || mode>20){
   BWCCMessageBox(NULL,"Bad mode opening graph screen",szGraphWindow,MB_ICONSTOP|MB_OK);
   return FALSE;
 }
 if(hGraphWindow){
   CloseGraphWindow();
 }

 PenStyle	=1; //PS_SOLID
 PenWidth	=1;
 PenColor	=RGB(255,255,255);

 BrushStyle 	=1;
 BrushColor     =RGB(255,255,255);

 GraphCol=(4*GetSystemMetrics(SM_CXSCREEN))/(3+mode);
 GraphRow=(4*GetSystemMetrics(SM_CYSCREEN))/(3+mode);
 VirtualDev=CreateCompatibleDC(NULL);
 GraphColors=GetDeviceCaps(VirtualDev,BITSPIXEL)*GetDeviceCaps(VirtualDev,PLANES);
 //BWCCMessageBox(NULL,itoa(GraphColors,"       ",10),szGraphWindow,MB_ICONSTOP|MB_OK);
 if(!MakePalette()){
   BWCCMessageBox(NULL,"Palette Error opening graph screen",szGraphWindow,MB_ICONSTOP|MB_OK);
   return FALSE;
 }

 sdev=GetDC(NULL);
 bmp=CreateCompatibleBitmap(sdev,GraphCol,GraphRow);
 ReleaseDC(NULL,sdev);
 if(!bmp){
   BWCCMessageBox(NULL,"Out of memory opening graph screen",szGraphWindow,MB_ICONSTOP|MB_OK);
   DestroyPalette();
   return FALSE;
 }

 OldBitmap	=SelectObject(VirtualDev,bmp);
 OldPen		=SelectObject(VirtualDev,p=MakePen());
 OldBrush	=SelectObject(VirtualDev,b=MakeBrush());
 SetTextColor(VirtualDev,PenColor);
 SetBkMode(VirtualDev,TRANSPARENT);
 PatBlt(VirtualDev,0,0,GraphCol,GraphRow,BLACKNESS); //Cancella

 hGraphWindow=CreateWindow(
   szGraphWindow,
   szGraphWindow,
   WS_OVERLAPPEDWINDOW|WS_HSCROLL|WS_VSCROLL,
   GetSystemMetrics(SM_CXSCREEN)/3,
   10,
   2*GetSystemMetrics(SM_CXSCREEN)/3,
   GetSystemMetrics(SM_CYSCREEN)-20,
   NULL,
   NULL,
   ProgramInstance,
   NULL);

 WinDev=GetDC(hGraphWindow);
 SelectObject(WinDev,p);
 SelectObject(WinDev,b);
 SetTextColor(WinDev,PenColor);
 SetBkMode(WinDev,TRANSPARENT);

 ShowWindow(hGraphWindow,SW_SHOW);
 UpdateWindow(hGraphWindow);

 return TRUE;
}

BOOL CloseGraphWindow(void)
{
 if(!hGraphWindow)return FALSE;

 SelectObject(WinDev,OldPen);
 SelectObject(WinDev,OldBrush);
 if(OldPalette)SelectPalette(WinDev,OldPalette,FALSE);
 ReleaseDC(hGraphWindow,WinDev);

 DeleteObject(SelectObject(VirtualDev,OldBitmap));
 DeleteObject(SelectObject(VirtualDev,OldPen));
 DeleteObject(SelectObject(VirtualDev,OldBrush));

 DestroyPalette();
 DeleteDC(VirtualDev);
 DestroyWindow(hGraphWindow);
 hGraphWindow=NULL;
 return TRUE;
}

void PaintGraphWindow(void)
{
 PAINTSTRUCT ps;

 BeginPaint(hGraphWindow,&ps);
 BitBlt(
   ps.hdc,
   ps.rcPaint.left,
   ps.rcPaint.top,
   ps.rcPaint.right-ps.rcPaint.left,
   ps.rcPaint.bottom-ps.rcPaint.top,
   VirtualDev,
   ps.rcPaint.left,
   ps.rcPaint.top,
   SRCCOPY
 );
 EndPaint(hGraphWindow,&ps);
}

void lg_opengraph(int m,int *row,int *col)
{
 if(m){
   if(m<1)m=1;else if(m>20)m=20;
   if(OpenGraphWindow(m)){
     *row=GraphRow;
     *col=GraphCol;
     return;
   }
 }else{
   CloseGraphWindow();
 }
 *row=0;
 *col=0;
}

int  lg_graphopen()
{
 return hGraphWindow?1:0;
}

void lg_cleargraph()
{
 PalEntries=0;
 PatBlt(VirtualDev,0,0,GraphCol,GraphRow,BLACKNESS);
 if(GraphDynRedraw){
   PatBlt(WinDev,0,0,GraphCol,GraphRow,BLACKNESS);
 }else{
   Changed=TRUE;
 }
}

void lg_pencolor(long c)
{
 HPEN p;
 PenColor=AddColorToPalette(c);
 p=MakePen();
 if(GraphDynRedraw){
   SelectObject(WinDev,p);
   DeleteObject(SelectObject(VirtualDev,p));
   SetTextColor(VirtualDev,PenColor);
   SetTextColor(WinDev,PenColor);
 }else{
   DeleteObject(SelectObject(VirtualDev,p));
   SetTextColor(VirtualDev,PenColor);
 }
}

void lg_pentick(int c)
{
 HPEN p;
 if(c<1)c=1;
 PenWidth=c;
 p=MakePen();
 if(GraphDynRedraw){
   SelectObject(WinDev,p);
   DeleteObject(SelectObject(VirtualDev,p));
 }else{
   DeleteObject(SelectObject(VirtualDev,p));
 }
}

void lg_pentype(int c)
{
 HPEN p;
 if(c<0 || c>5)c=1;
 PenStyle=c;
 p=MakePen();
 if(GraphDynRedraw){
   SelectObject(WinDev,p);
   DeleteObject(SelectObject(VirtualDev,p));
 }else{
   DeleteObject(SelectObject(VirtualDev,p));
 }
}

void lg_brushcolor(long c)
{
 HBRUSH b;
 BrushColor=AddColorToPalette(c);
 b=MakeBrush();
 if(GraphDynRedraw){
   SelectObject(WinDev,b);
   DeleteObject(SelectObject(VirtualDev,b));
 }else{
   DeleteObject(SelectObject(VirtualDev,b));
 }
};

void lg_brushtype(int c)
{
 HBRUSH b;
 if(c<0 || c>7)c=1;
 BrushStyle=c;
 b=MakeBrush();
 if(GraphDynRedraw){
   SelectObject(WinDev,b);
   DeleteObject(SelectObject(VirtualDev,b));
 }else{
   DeleteObject(SelectObject(VirtualDev,b));
 }
};

void lg_moveto(int x,int y)
{
 MoveTo(VirtualDev,x,y);
 if(GraphDynRedraw)
   MoveTo(WinDev,x,y);
};

void lg_lineto(int x,int y)
{
 LineTo(VirtualDev,x,y);
 if(GraphDynRedraw)
   LineTo(WinDev,x,y);
 else
   Changed=TRUE;
};

void lg_fillpoly(int pts,int *points)
{
 Polygon(VirtualDev,(LPPOINT)points,pts);
 if(GraphDynRedraw)
   Polygon(WinDev,(LPPOINT)points,pts);
 else
   Changed=TRUE;
};

void lg_fillellipse(int x,int y,int xr,int yr)
{
 Ellipse(VirtualDev,x-xr+1,y-yr+1,x+xr+1,y+yr+1);
 if(GraphDynRedraw)
   Ellipse(WinDev,x-xr+1,y-yr+1,x+xr+1,y+yr+1);
 else
   Changed=TRUE;
};

void lg_fillsector(int x,int y,int sa,int ea,int xr,int yr)
{
 Pie(VirtualDev,x-xr+1,y-yr+1,x+xr+1,y+yr+1,
	10000*cos(sa*2*M_PI/360),10000*sin(sa*2*M_PI/360),
	10000*cos(ea*2*M_PI/360),-10000*sin(ea*2*M_PI/360));
 if(GraphDynRedraw)
   Pie(WinDev,x-xr+1,y-yr+1,x+xr+1,y+yr+1,
	10000*cos(sa*2*M_PI/360),10000*sin(sa*2*M_PI/360),
	10000*cos(ea*2*M_PI/360),-10000*sin(ea*2*M_PI/360));
 else
   Changed=TRUE;
};

void lg_graphtext(int x,int y,char *s)
{
 TextOut(VirtualDev,x,y,s,strlen(s));
 if(GraphDynRedraw)
   TextOut(WinDev,x,y,s,strlen(s));
 else
   Changed=TRUE;
};

void lg_putpixel(int x,int y,long c)
{
 COLORREF co=AddColorToPalette(c);
 SetPixel(VirtualDev,x,y,co);
 if(GraphDynRedraw)
   SetPixel(WinDev,x,y,co);
 else
   Changed=TRUE;
};

long lg_getpixel(int x,int y)
{
 return GetPixel(VirtualDev,x,y);
};

