

; Graphic Lisp	Dama By Zoia Andrea
; funzioni di stampa su terminale


(setf *debug_pr* nil)


(setf base-x 1)
(setf base-y 1)
(defun print-board (
			&optional (base-x 1)(base-y 6)
 			&aux fl (ll (reverse '(A B C D E F G H)))
		   )
  (dotimes (y 8)
    (curpos base-x (+ base-y (* y 2)))
    (textcolor 8 4 2)
    (print (elt ll (1+ y)))
    (curpos base-x (+ base-y (* y 2) 1))
    (print " ")
    (dotimes (x 8)
      (print-square (+ base-x 1 (* x 3)) (+ base-y (* y 2)) (if fl 7 6) )
      (setf fl (not fl))
    )
    (setf fl (not fl))
  )
  (curpos base-x (+ base-y 16))
  (textcolor 8 4 2)
  (print "  1  2  3  4  5  6  7  8 ")
)

(defun print-square(x y color)
 (textcolor 0 color)
 (curpos x y)
 (print "   ")
 (curpos x (1+ y))
 (print "   ")
)
 
(defun print-ped(ped pos &aux row col)
 (setf col (round (/ (1- pos) 10)))
 (setf row (- (1- pos) (* col 10)))
 (curpos (1- (+ base-x (* 3 row))) (+ base-y (- 16 (* 2 col)))  )
 (textcolor 0 7 2)
 (print
  (cond ((= ped 1) (textcolor 8) "b")
        ((= ped 2) (textcolor 1) "n")
        ((= ped 3) (textcolor 8) "B")
        ((= ped 4) (textcolor 1) "N")
        (t " ")
  )
 )    
)


(defun print-init(&aux ped)
  (textcolor 0 0 1)
  (cls)
  (print-board)
  (dotimes (i 100)
    (setf ped (elt *scacchiera* (1+ i)))
    (when (or (= 1 ped) (= 2 ped)) (print-ped ped (1+ i)))
  )
)

(defun blink-ped (ped pos pb pe &aux tim)
 (setf tim (get-time))
 (when pb
   (print-ped 0 pos)
   (loop (when (< (+ 100 tim) (get-time)) (return)))
   (setf tim (get-time))
 )
 (print-ped ped pos)
 (loop (when (< (+ 100 tim) (get-time)) (return)))
 (setf tim (get-time))

 (print-ped 0  pos)
 (loop (when (< (+ 100 tim) (get-time)) (return)))
 (setf tim (get-time))

 (print-ped ped pos)
 (loop (when (< (+ 100 tim) (get-time)) (return)))
 (setf tim (get-time))

 (unless pe
   (print-ped 0 pos)
 )
)

(defun print-mov (mossa &aux lm ped)
 (setf lm (car mossa))
 (setf ped (elt *scacchiera* lm ))
 (blink-ped ped lm t nil)
 (dolist (mov (cdr mossa))
   (when (> mov 1000) (setf ped (+ 2 ped) mov (- mov 1000)))
   (when (> (abs (- mov lm)) 15) (print-ped 0 (round (/ (+ mov lm) 2))))
   (blink-ped ped mov nil nil)
   (setf lm mov)	
 )
 (print-ped ped lm)
)






;		dama
;funzioni di input da terminale



(defun strcvt (str &aux c1 c2)
  (if (> (strlen str) 1)
    (progn
      (setf c1 (- (str2ascii (strsub str 1 1)) 64))
      (when (> c1 8)
	(setf c1 (- (str2ascii (strsub str 1 1)) 96))
      )
      (setf c2 (- (str2ascii (strsub str 2 1)) (str2ascii "0")))
      (if 
        (and 
	  (and (> c1 0) (< c1 9))
          (and (> c2 0) (< c2 9))
        )
        (+ c2 (* c1 10) 1)
        nil  
      ) 
    )
    nil
  )
)

(defun get-pos (&aux str pos)
  (loop
    (setf str (read-line 2))
    (when (string= str "") (return))
    (setf pos (strcvt str))
    (when pos (return pos))
    (if (= 2 (strlen str))
      (print "\b\b  \b\b")
      (print "\b \b")
    )
  )
)


(defun get-first-pos (&aux str pos)
  (loop
    (setf str (read-line 2))
    (when (string= str "EX") (return))
    (setf pos (strcvt str))
    (when pos (return pos))
    (if (= 2 (strlen str))
      (print "\b\b  \b\b")
      (when (= 1 (strlen str))
	(print "\b \b")
      )
    )
  )
)




(defun inmove (
		&optional (cur-x 40) (cur-y 10)
		&aux movlist (counter 0) ped str (lines 0)
              )
(textcolor 4 2 2)
(curpos cur-x cur-y)
(dotimes (i 5)
  (print "                                       ")
  (curpos cur-x (- cur-y i))
)
(curpos cur-x cur-y)
(progn
  (print "Mossa->")
  (setf str (get-first-pos))
  (unless str (return))
  (setf ped (elt *scacchiera* str))
  (setf movlist (append movlist (list str)))
  (loop
    (when (= counter 5) 
      (setf counter 0 lines (1+ lines))
      (when (= 5 lines) (return movlist)) 
      (curpos (+ 9 cur-x) (setf cur-y (1- cur-y)))
    )
    (print "  ->")
    (setf str (get-pos))
    (unless str (return movlist))
    (when
      (or
	(and (> str 80) (= 1 ped))
	(and (< str 20) (= 2 ped))
      )
      (setf str (+ str 1000) ped (+ 2 ped))
    )
    (setf movlist (append movlist (list str)))
    (setf counter (1+ counter))
  )
)
)


(when *debug_pr*
(setf *scacchiera* '(
100 100 100 100 100 100 100 100 100 100
100  1   0   0   0   1   0   0   0  100
100  0   1   0   1   0   1   0   1  100
100  0   0   1   0   0   0   0   0  100
100  0   0   0   1   0   0   0   0  100
100  0   0   2   0   0   0   0   0  100
100  0   1   0   2   0   2   0   2  100
100  2	 0   2	 0   2	 0   2	 0  100
100  0	 2   0	 0   0	 0   0	 2  100
100 100 100 100 100 100 100 100 100 100))
(print-init)

(let (mov)
  (loop
    (setf mov (inmove))
    (unless mov (return))
    (print-mov mov)
  )
)
)




