%{
/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file closyacc.y */


#include"clos.h"
#include"closerr.h"

#define YYMAXDEPTH 	1000	/* Yacc stack depth */
#define PROMPT          { sprintf(buf1,"%s",yacc_prompt);\
                          lisp_print_string(buf1,yacc_fileout);}
#define PROMPTP         { sprintf(buf1,"%u%s",parcount,yacc_prompt);\
                          lisp_print_string(buf1,yacc_fileout);}

extern 	int 	parcount;
int 		yywrapcalled;
node 		yyret;
char		*yacc_prompt;
FILE		*yacc_filein;
FILE		*yacc_fileout;

int yywrap();
int yyerror();

node input_func(fin,fout,pr)
FILE *fin;
FILE *fout;
char *pr;
{
 yacc_filein=fin;yacc_fileout=fout;
 parcount=0;yacc_prompt=pr;
 yywrapcalled=FALSE;
 /* 1) */
 PROMPT;
 /******/
 if(yyparse()){ /* error... */
        if(yywrapcalled)
                error(E_EOF,ERR_MERROR|ERR_PVOID|ERR_TNORM,NULL);
	else{
                error(E_YACCSTACK,ERR_MERROR|ERR_PVOID|ERR_TNORM,NULL);
                /* svuota il buffer d'ingresso */
                while(lisp_get_char(yacc_filein)!='\n');
        }
        PROMPT;
        /* ritorna al main-loop */
        error(E_ZERO,ERR_MNONE|ERR_PVOID|ERR_TBLVL,NULL);
 }
 /*if(yyret==VOID){*/
   /* 2) ho levato questo prompt mentre l'error era gia' stato tolto prima*/
   /* dunque non serve piu' nemmeno l'if */
   /*PROMPT;*/
   /******************************************************************/
   /* ritorna al main-loop */
   /* error(E_ZERO,ERR_MNONE|ERR_PVOID|ERR_TBLVL,NULL); */
 /*}*/
 return yyret;
}

int yywrap()
{ return yywrapcalled=TRUE; }

int yyerror(s)
char *s;
{ return TRUE; }

%}

%union{
	char		*ident;
	double		real;
	long int	integer;
	node		s_expr;
}

%token	<ident>		IDENTIFIER_YY
%token	<ident>		STRING_YY
%token	<integer>	INTEGER_YY
%token	<real>		REAL_YY
%token	<integer>	BAD_CHAR_YY
%token  <foo1>             BAD_STRING_YY
%token  <foo2>             BAD_SQB_YY

%type	<s_expr>	atom
%type	<s_expr>	list
%type	<s_expr>	macro
%type	<s_expr>	sexpr

%start	ass
%%

ass	: n sexpr '\n'  
  /* 3) ho messo n alla fine in modo da svuotare il buffer */
                {yyret=$2;YYACCEPT;}
	| error '\n'            
		{ error(E_SYNTAX,ERR_MERROR|ERR_PVOID|ERR_TNORM,NULL);
                  yyret=VOID;YYACCEPT;
		}
	;

sexpr	: atom			{$$=$1;}
	| macro			{$$=$1;}
	| '(' list		{$$=$2;}
	;

atom	: INTEGER_YY		
                { TYPE($$=node_make())|=NT_IS_VALUE+NT_INTEGER;
                  INTEGER($$)=$1;
                }
        | REAL_YY
                { TYPE($$=node_make())|=NT_IS_VALUE+NT_REAL;
                  REAL($$)=$1;
                }
        | STRING_YY
                { $$=node_make();STRING($$)=string_put($1,$$);
                  TYPE($$)|=NT_IS_VALUE+NT_STRING;
                }
        | IDENTIFIER_YY
                { $$=node_alloc($1);
                }
        | BAD_CHAR_YY error '\n'
                { sprintf(buf1,"Char '%c' ascii %i",(char)$1,(int)$1);
                  error(E_BADCH,ERR_MERROR|ERR_TNORM|ERR_PSTRING,buf1);
                  yyret=VOID;YYACCEPT;
                }
        | BAD_STRING_YY
                {
                  error(E_BADSTRING,ERR_MERROR|ERR_TNORM|ERR_PVOID,NULL);
                  yyret=VOID;YYACCEPT;
                }
        | BAD_SQB_YY error '\n'
		{
                  error(E_INVALIDSQB,ERR_MERROR|ERR_TNORM|ERR_PVOID,NULL);
                  yyret=VOID;YYACCEPT;
                }
	;

macro   : '&' sexpr
                { TYPE($$=node_make())|=NT_IS_VALUE+NT_ENAME;
                  ENAME($$)=$2;
                }
        | ':' sexpr
                { TYPE($$=node_make())|=NT_IS_VALUE+NT_CNAME;
                  ENAME($$)=$2;
                }
        | '\'' sexpr
                { $$=node_make();CONSLEFT($$)=node_alloc("QUOTE");
                  CONSRIGHT($$)=node_make();CONSLEFT(CONSRIGHT($$))=$2;
                  CONSRIGHT(CONSRIGHT($$))=NIL;
                  TYPE($$)|=NT_IS_CONS;TYPE(CONSRIGHT($$))|=NT_IS_CONS;
                }
        | ',' sexpr
                { $$=node_make();CONSLEFT($$)=node_alloc("COMA");
                  CONSRIGHT($$)=node_make();CONSLEFT(CONSRIGHT($$))=$2;
                  CONSRIGHT(CONSRIGHT($$))=NIL;
                  TYPE($$)|=NT_IS_CONS;TYPE(CONSRIGHT($$))|=NT_IS_CONS;
                }
	| '~' sexpr
		{ $$=node_make();CONSLEFT($$)=node_alloc("BACKQUOTE");
		  CONSRIGHT($$)=node_make();CONSLEFT(CONSRIGHT($$))=$2;
		  CONSRIGHT(CONSRIGHT($$))=NIL;
		  TYPE($$)|=NT_IS_CONS;TYPE(CONSRIGHT($$))|=NT_IS_CONS;
		}
        | '#' '\'' sexpr
                { $$=node_make();CONSLEFT($$)=node_alloc("FUNCTION");
                  CONSRIGHT($$)=node_make();CONSLEFT(CONSRIGHT($$))=$3;
                  CONSRIGHT(CONSRIGHT($$))=NIL;
                  TYPE($$)|=NT_IS_CONS;TYPE(CONSRIGHT($$))|=NT_IS_CONS;
                }
	;

list    : n sexpr list
                { TYPE($$=node_make())|=NT_IS_CONS;
                  CONSLEFT($$)=$2;CONSRIGHT($$)=$3;
                }
        | n ')' { $$=NIL;}
        | n sexpr n '.' n sexpr n ')'
                { TYPE($$=node_make())|=NT_IS_CONS;
                  CONSLEFT($$)=$2;CONSRIGHT($$)=$6;
                }
        ;

n	:
        | n '\n'
                { if(parcount)
                     PROMPTP
                  else
                     PROMPT
                }
	;

%%

