/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file closerr.c */

#include "clos.h"

int StackTrace=FALSE;
int StackTracing=FALSE;

char	*errstrings[E_LAST]={
	"",
        "Duplicate superclass",
	"Bad command line option\n\
Syntax CLOS [option(s)] [files]\n\
Options:\n\
-Nxxxxx nodes          -Sxxxxx string space\n\
-Hxxxxx hash entries   -Ixx max identifier lenght\n\
-Rxx max string lenght -A case-sensitive\n\
-A- no case-sensitive  -C bad char error\n\
-C- bad char warning   -W store options in clos.cfg\n",
	"Control-Break",
	"Stack Overflow",
        "Can't write configfile",
        "Print badvalue",
	"Print badtype",
	"Hash table full: try with command line -H<numhash>",
	"Unmatched class",
	"Ambiguous method: The methods I've matched right are",
	"Unmatched method",
	"Initarg redefinition",
	"Invalid ']'",
	"Identifier truncated",
	"String truncated",
	"Bad char parsed",
	"Too many node pages",
	"Out of nodes space: try with command line -N<numnodes>",
	"Bad type GC",
	"Out of strings space:try with command line -S<numstrings>",
	"GCS1",
	"GCS2",
        "GCS3",
        "EOF reached",
        "Yacc stack overflow",
        "Syntax error",
        "Bad string",
        "Division by 0",
        "Bad identifier lenght",
	"Too many nodes: out of memory",
	"Too many hash entry: out of memory",
	"Too much space for strings: out of memory",
	"Unbound atom",
	"Bad function",
	"Too few arguments",
	"Bad argument(s) type",
	"Bad list",
	"Bad node pointer in setf",
	"Too many arguments",
	"Lambda syntax error",
	"Bad Lambda form",
	"Bad pointer type",
	"Can't open file",
	"Bad string lenght",
	"Unbound function",
	"Bad nodealloc call with numnodes<2",
	"Invalid configuration file:delete it & retry",
	"Label not found",
	"RETURN outside LOOP,DO,DO*,DOTIMES,DOLIST,PROGx",
	"Can't CONTINUE from Top-Level",
	"Accessor redefinition",
	"Defclass syntax error",
	"Can't redefine a class",
        "Unbound class",
        "Bad 3d point",
	"Graph function used in text-mode",
	"Too many points",
	"Math error:Overflow",
	"Math error:",
	"Null node in node_marklist()",
	"String Too Long",
	"Bad NodeCounter (used+free!=total)",
	"GO outside PROG",
	"Out of memory allocating point list in GFILLPOLY",
	"In module closstr2.c"
};
	


int error( num, type, ptr)
unsigned num;
unsigned type;
void  *ptr;
{
 int print_flag=TRUE;
 switch(type&ERR_MMASK){
	case ERR_MERROR:
		Merror:;
		lisp_print_string("ERROR: ",stderr);
		break;
	case ERR_MWARN:
		lisp_print_string("WARNING: ",stderr);
		break;
	case ERR_MINTERNAL:
		lisp_print_string("INTERNAL ERROR: ",stderr);
		break;
	case ERR_MNONE:
		print_flag=FALSE;
		break;

	case ERR_MERRORMSGBOX:
#ifdef _Windows
	  print_flag=FALSE;
	  if((type&ERR_PMASK)==ERR_PSTRING){
	    strcpy(buf1,errstrings[num]);
	    strcat(buf1,(char*)ptr);
	    BWCCMessageBox(hClosWindow,buf1,"CLOS ERROR",MB_OK);
	    break;
	  }
	  BWCCMessageBox(hClosWindow,errstrings[num],"CLOS ERROR",MB_OK);
	  break;
#else
	  goto Merror;
#endif
 }
 if(print_flag){
	lisp_print_string(errstrings[num],stderr);
	switch(type&ERR_PMASK){
		case ERR_PVOID:
			break;
		case ERR_PSTRING:
			lisp_print_string(" ",stderr);
			lisp_print_string((char*)ptr,stderr);
			break;
		case ERR_PNODE:
			lisp_print_string(" ",stderr);
			fprint_func(*(node *)ptr,stderr);
			break;
		case ERR_PNINT:
			sprintf(buf1," %lu",*(n_int  *)ptr);
			lisp_print_string(buf1,stderr);
			break;
	}
	lisp_print_string("\n",stderr);
 }
 if(StackTrace && !StackTracing){
   lisp_print_string("trace...\n",stdout);
   StackTracing=TRUE;
   stack_backtrace();
   StackTracing=FALSE;
 }
 switch(type&ERR_TMASK){
	case ERR_TNORM:
		return ERROR;
	case ERR_TCRIT:
		longjmp(critical_jmp,LONGJMP_CRITICAL);
	case ERR_TBLVL:
		longjmp(break_jmp,LONGJMP_ERROR);
 }
 return ERROR;
}




