/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file closacc.c */

#include "clos.h"

node list_dup(l,fl)
node l;
int fl;
{
 node nret=NIL;
 node n=NIL;
 node prev=NIL;

 while(IS_CONS(l)){
    n=node_make();
    TYPE(n)|=NT_IS_CONS;
    CONSLEFT(n)=CONSLEFT(l);
    CONSRIGHT(n)=NIL;
    if(prev==NIL){
      nret=prev=n;
    }else{
      CONSRIGHT(prev)=n;
      prev=n;
    }
    l=CONSRIGHT(l);
 }
 if(fl==DUP_LASTDUP && prev!=NIL)
	CONSRIGHT(prev)=NIL;
 return nret;
}

len_t  listlen_func(l)
node l;
{
 len_t i=0;

 while(IS_CONS(l)){
   i++;
   l=CONSRIGHT(l);
 }
 return i;
}


node list_elt(list,elt)
node list;
lsiz_t elt;
{
 /* prende l'elemento elt-esimo dalla lista list */
 /* se non lo trova ritorna VOID */
 /* elt deve essere >= 0 e list deve essere un CONS */

 while(elt--){
   if(!IS_CONS(list))return VOID;
   list=CONSRIGHT(list);
 }
 return CONSLEFT(list);
}

node    calc_pointer(p)
node_p *p;
{
 switch(p->type){
	case P_ALLNODE:
		return p->node;
	case P_VALUE:
		return VALUE(p->node);
	case P_PLIST:
		return PLIST(p->node);
	case P_FUNC:
		return FUNCTION(p->node);
	case P_CONSLEFT:
		return CONSLEFT(p->node);
	case P_CONSRIGHT:
		return CONSRIGHT(p->node);
	case P_CLASS:
		return CLASS(p->node);
 }
 error(E_BADPOINTER,ERR_MINTERNAL|ERR_TCRIT|ERR_PVOID,NULL);
 return 0;
}


int	find_in_alist(nin,nout,alist)
node	nin;
node_p	*nout;
node	alist;
{
 /* trova in alist il nodo con nome 'nin' e restituisce il suo valore */
 /*     se non lo trova ritorna ERROR */
 while(IS_CONS(alist)){
	if(CONSLEFT(CONSLEFT(alist))==nin){
		nout->type=P_CONSRIGHT;
		nout->node=CONSLEFT(alist);
		return OK;
	}
	alist=CONSRIGHT(alist);
 }
 return ERROR;
}

node    put_in_alist(nname,nvalue,alist)
node nname;
node nvalue;
node alist;
{
 /* inserisce (nn . nv) in testa ad alist e la ritorna */
 node n1=node_make();
 node n2=node_make();

 TYPE(n1)|=NT_IS_CONS;
 TYPE(n2)|=NT_IS_CONS;

 CONSLEFT(n1)=n2;
 CONSRIGHT(n1)=alist;
 CONSLEFT(n2)=nname;
 CONSRIGHT(n2)=nvalue;
 return n1;
}

int     chk_alist(alist)
node alist;
{
 /* controlla se alist e' una lista di cons  */
 /* cioe' se alist==( (name . xx) (name . xx) .... ) */

 node a=alist;

 while(a!=NIL)
	if(	IS_CONS(a)&&IS_CONS(CONSLEFT(a))&&
		IS_NAME(CONSLEFT(CONSLEFT(a)))&&
		HAS_NAME(CONSLEFT(CONSLEFT(a))))

		a=CONSRIGHT(a);
	else
                return ERROR;
 return OK;
}




void internal_setf(name,value,genv,lenv)
node name;
node value;
node genv;
node lenv;
{
 node_p nout;
 if(find_in_alist(name,&nout,lenv)){
   /* name non e' nel local-environment */
   if(find_in_alist(name,&nout,genv)){
     /* name non e' nel global-environment */
     VALUE(name)=value;

/*REVISIONE: se si setta una variabile defvar allora va preservato HAS_BIND*/
     if(HAS_BIND(name) || HAS_VALUE(name))return;  
/*_________*/

     TYPE(name)|=NT_HAS_VALUE;
     return;
   }
 }
 CONSRIGHT(nout.node)=value;
}



void internal_update_environment(name,value,genv,lenv)
node name;
node value;
node *genv;
node *lenv;
{
 /* aggiunge la coppia name,value all'environment */
 if(HAS_VALUE(name)){
   /* name e' una variabile GLOBALE */
   VALUE(name)=value;
   return;
 }

 if(HAS_BIND(name)){
   /* name e' una variabile SPECIALE ''(defvar name),, */
   *genv=put_in_alist(name,value,*genv);
   return;
 }

 /* name e' una variabile LOCALE */
 *lenv=put_in_alist(name,value,*lenv);
}


