C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
C
C  ISTVC  - 5 DEC 83
C           VERSION CONTROL TOOL
C
C           ORIGINAL AUTHOR:      WEBB MILLER, UNIVERSITY OF ARIZONA
C           TOOLPACK CONFORMANCE: BOB ILES, NAG CENTRAL OFFICE
C           MODIFICATIONS:        BOB ILES, NAG CENTRAL OFFICE
C                                 MALCOM COHEN, NAG CENTRAL OFFICE
C
C  TNAME - AN ARRAY HOLDING THE NAME OF THE TEMPORARY FILE 'TMPVER'
C
      PROGRAM ISTVC
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
      SAVE
 
      CALL ZINIT
 
      CALL VERSIN
      CALL REMOVE(TNAME(TFIRST))
 
      CALL ZQUIT(-2)
 
      END
C---------------------------------------------------------------------
C     Added routine INITV to initialise COMMON block variables.
C     (Program was assuming that they were initialised to zero
C      ugh, shudder).  This will (a) mean we init TNAME at compile time
C                                (b) fix funny numbers bug
C
      BLOCK DATA INITV
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
      SAVE
 
      DATA LENGTH/0/, TFIRST/1/
      DATA (TNAME(I),I=1,8)/35,116,109,112,118,101,114,129/
      DATA DCNT/0/, ICNT/0/
 
      END
C-----------------------------------------------------------------------
C
C  FILE COPY UTILITY, COPY FILE "NAME1" TO FILE "NAME2" THE TRANSFER
C  ENDS WHEN AN "e1" LINE IS FOUND. AN END-OF-FILE IS AN ERROR AS IT
C  MEANS THAT NO "e1" LINE EXISTED.
C
      SUBROUTINE AMOVE(NAME1, NAME2)
 
      INTEGER NAME1(*), NAME2(*), BUF(134)
      INTEGER OPEN, GETLIN, FD1, FD2
 
      FD1 = OPEN(NAME1, 0)
      FD2 = OPEN(NAME2, 1)
      IF((FD2 .EQ. -1) .OR. (FD1 .EQ. -1)) CALL
     +    VCERR('VC: AMOVE - UNABLE TO OPEN FILE.')
 
   10 CONTINUE
        IF(GETLIN(BUF, FD1) .LT. 0) THEN
          CALL VCERR('VC: AMOVE - TRANSFER ERROR.')
        ELSE
          CALL PUTLIN(BUF, FD2)
          IF((BUF(1).EQ.101) .AND. (BUF(2).EQ.49) .AND.
     +       (BUF(3).EQ.10)) RETURN
        ENDIF
      GOTO 10
 
      END
C-------------------------------------------------------------------------
C
      INTEGER FUNCTION CHANGE(M,N)
 
      INTEGER M, N
      INTEGER BUFFER(5), ITOC, JUNK
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
      SAVE
 
      JUNK = ITOC(VERSIO,BUFFER,5)
      IF (N .GT. 0) THEN
        CALL FPRNTF(97, BUFFER)
        CALL SEND(2,N)
        CALL FPRNTF(101, BUFFER)
        ICNT = ICNT + N
      END IF
      IF (M .GT. 0) THEN
        CALL FPRNTF(100, BUFFER)
        CALL SEND(1,M)
        CALL FPRNTF(101, BUFFER)
        DCNT = DCNT + M
      END IF
      CHANGE = 1 + 1
 
      END
C---------------------------------------------------------------------
C
      INTEGER FUNCTION CMPTIM(TIME)
 
      INTEGER TIME(6), T(6)
      INTEGER I, J
      INTEGER INDEXX
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
      J = INDEXX(LINE, 32)
      CALL CONVTI(LINE(J+1), T)
 
      DO 10 I = 1, 6
        IF (TIME(I) .NE. T(I)) THEN
          CMPTIM = TIME(I) - T(I)
          RETURN
        END IF
   10 CONTINUE
 
      CMPTIM = 0
 
      END
C----------------------------------------------------------------------
C
C  LIST VERSION FILE CONTENTS
C
      SUBROUTINE CONTEN(VERSIO)
 
      INTEGER VERSIO, INLINE, VERS, VNBR
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
   10 CONTINUE
        IF(INLINE() .EQ. -100) RETURN
        IF(TYP .NE. 118 .AND. TYP .NE. 99) RETURN
 
        IF (TYP .EQ. 118) THEN
          VERS = VNBR()
          IF (VERS .LT. VERSIO) RETURN
        END IF
 
        IF (VERSIO .EQ. 0 .OR. VERSIO .EQ. VERS) THEN
          IF (TYP .EQ. 118) THEN
            CALL SKIP(1)
            CALL ZCHOUT('version .', 1)
          END IF
          CALL PUTLIN(LINE,1)
        END IF
      GOTO 10
 
      END
C---------------------------------------------------------------------
C
      SUBROUTINE CONVTI(A,T)
 
      INTEGER P
      INTEGER A(*), T(*)
      INTEGER CTOI
 
C  CONVERT THE YEAR (WHICH STARTS IN POSITION 19)
      P = 19
      T(1) = CTOI(A,P)
C  CONVERT THE MONTH
      IF(A(1) .EQ. 106) THEN
        IF(A(2) .EQ. 97) THEN
          T(2) = 1
        ELSE
          IF(A(3) .EQ. 108) THEN
            T(2) = 7
          ELSE
            T(2) = 6
          ENDIF
        ENDIF
      ELSE IF(A(1) .EQ. 102) THEN
        T(2) = 2
      ELSE IF(A(1) .EQ. 109) THEN
        IF(A(3) .EQ. 114) THEN
          T(2) = 3
        ELSE
          T(2) = 5
        ENDIF
      ELSE IF(A(1) .EQ. 97) THEN
        IF(A(2) .EQ. 112) THEN
          T(2) = 4
        ELSE
          T(2) = 8
        ENDIF
      ELSE IF(A(1) .EQ. 115) THEN
        T(2) = 9
      ELSE IF(A(1) .EQ. 111) THEN
        T(2) = 10
      ELSE IF(A(1) .EQ. 110) THEN
        T(2) = 11
      ELSE IF(A(1) .EQ. 100) THEN
        T(2) = 12
      ELSE
        CALL VCERR('illegal month.')
      END IF
C CONVERT THE DAY
      P = 5
      T(3) = CTOI(A,P)
C  CONVERT THE HOUR
      P = 8
      T(4) = CTOI(A,P)
C  CONVERT THE MINUTE
      P = 11
      T(5) = CTOI(A,P)
C  CONVERT THE SECOND
      P = 14
      T(6) = CTOI(A,P)
 
      END
C------------------------------------------------------------------------
C
      SUBROUTINE CUTOFF(ARGC, I, VAL)
 
      INTEGER ARGC, I, VAL
      INTEGER TIME(6)
      INTEGER JUNK, J, K, TYPE, VERSIO, VNBR, CMPTIM
      INTEGER OUTP, FIXEND, NEXTLN, INLINE
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
      J = 3
      K = 1
   10 IF(K .LE. 6) THEN
        IF (TYPE(OPTVAL(J)) .NE. 2) THEN
          TIME(K) = 0
        ELSE
          TIME(K) = OPTVAL(J) - 48
          J = J + 1
          IF (TYPE(OPTVAL(J)) .EQ. 2) THEN
            TIME(K) = 10*TIME(K) + OPTVAL(J) - 48
          END IF
          J = J + 1
          IF (TYPE(OPTVAL(J)) .NE. 2 .AND. OPTVAL(J) .NE. 129) THEN
            J = J + 1
          END IF
        END IF
        K = K + 1
        GO TO 10
      ENDIF
 
   20 IF(INLINE() .NE. -100) THEN
        IF (TYP .EQ. 118) THEN
          VERSIO = VNBR()
          IF (CMPTIM(TIME) .GE. 0) GO TO 30
        ELSE IF (VERSIO .EQ. 1) THEN
          CALL VCERR('VC: file did 126 exist at specified time.')
        END IF
        GO TO 20
      ENDIF
 
   30 CONTINUE
      OUTP = FIXEND(ARGC,I,1)
 
   40 IF(NEXTLN(VERSIO, -1) .NE. -100) THEN
        CALL PUTOUT(VERSIO,LINE,OUTP)
        GO TO 40
      ENDIF
 
      END
C----------------------------------------------------------------
C
C  LIST DIFFERENCES BETWEEN VERSIONS IN THE VERSION FILE
C
      SUBROUTINE DIFFER(VERSIO)
 
      INTEGER JUNK, VERSIO, VERSNB
      INTEGER OPEN, INLINE, VNBR
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
      IF (VERSIO .NE. 0) THEN
        CALL VERSDI(VERSIO)
 
      ELSE
        JUNK = INLINE()
        VERSNB = VNBR()
 
   10   CONTINUE
        CALL VERSDI(VERSNB)
        VERSNB = VERSNB - 1
        IF (VERSNB .NE. 0) THEN
          CALL CLOSE(VP)
          VP = OPEN(VFNAME, 0)
          CALL SKIP(2)
          GO TO 10
        ENDIF
      END IF
 
      END
C-------------------------------------------------------------------------
C
      INTEGER FUNCTION EQUIV(S, T)
 
      INTEGER S, T
      INTEGER I, J, TYPE, ZLOWER
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
      SAVE
 
      EQUIV = -3
      IF (S .EQ. -100 .OR. T .EQ. -100) RETURN
 
      I = S
      J = T
   10 CONTINUE
      IF (BUF(I,1) .NE. 10 .AND. BUF(J,2) .NE. 10) THEN
        IF (BUF(I,1) .EQ. BUF(J,2)) THEN
          I = I + 1
          J = J + 1
        ELSE IF((ZLOWER(BUF(I,1)) .EQ. 118)  .AND.
     +          (BUF(I+1,1)       .EQ. 35) .AND.
     +          (TYPE(BUF(J,2))   .EQ. 2)) THEN
   20     IF(TYPE(BUF(J,2)) .EQ. 2) THEN
            J = J + 1
            GO TO 20
          ENDIF
          IF (BUF(J,2) .EQ. 32) THEN
            I = I + 2
            J = J + 1
          ELSE
            GO TO 100
          END IF
        ELSE
          GO TO 100
        END IF
        GO TO 10
      ENDIF
 
100   CONTINUE
      IF (BUF(I,1) .EQ. 10 .AND. BUF(J,2) .EQ. 10) EQUIV = -2
 
      END
C------------------------------------------------------------------------
C
      INTEGER FUNCTION FIXEND(ARGC, I, MODE)
 
      INTEGER ARGC, I, MODE
      INTEGER JUNK, J, OPEN, CREATE
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
      IF (MODE .EQ. 1) THEN
        FIXEND = CREATE(FILNAM, 1)
      ELSE
        FIXEND = OPEN  (FILNAM, 0)
      ENDIF
 
      IF (FIXEND .EQ. -1) THEN
        CALL CANT(FILNAM)
        IF(MODE .EQ. 0) CALL ZQUIT(-1)
        FIXEND = 1
      END IF
 
      END
C---------------------------------------------------------------------
C
      SUBROUTINE FLUSHH
 
      INTEGER READIN, NUMBER, DIGITS(5), ITOC, JUNK
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
      SAVE
 
      NUMBER = NLINES(1)
      DCNT   = DCNT + NLINES(1)
      ICNT   = ICNT + NLINES(2)
 
   10 IF(READIN(1, 250) .NE. -100) THEN
        IF (BUF(TEXT(1, 250), 1) .EQ. 46) THEN
          LENGTH = LENGTH + 1
          DCNT = DCNT + 1
          NUMBER = NUMBER + 1
        END IF
        GO TO 10
      ENDIF
 
   20 IF(READIN(2, 250) .NE. -100) THEN
        ICNT = ICNT + 1
        GO TO 20
      ENDIF
 
      JUNK = ITOC(VERSIO, DIGITS, 5)
      IF (NLINES(2) .GT. 0) THEN
        CALL FPRNTF(97, DIGITS)
        BUF(P(2),2) = 129
        CALL PUTLIN(BUF(1,2),TP)
        CALL FPRNTF(101, DIGITS)
      END IF
      IF (P(1) .NE. 1) THEN
        IF (NUMBER .GT. 0) CALL FPRNTF(100, DIGITS)
        BUF(P(1), 1) = 129
        CALL PUTLIN(BUF(1,1),TP)
        IF (NUMBER .GT. 0) CALL FPRNTF(101, DIGITS)
      END IF
 
      END
C-------------------------------------------------------------------------
C
      SUBROUTINE FPRNTF(LETTER, DIGITS)
 
      INTEGER LETTER, DIGITS(*)
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
      SAVE
 
      CALL PUTCH (LETTER,  TP)
      CALL ZPTMES(DIGITS,  TP)
 
      END
C------------------------------------------------------------------------
C
      INTEGER FUNCTION GETL(FILE, N)
 
      INTEGER FILE, N
      INTEGER READIN, POINT, CTOI, VERSN, SAVEP
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
      SAVE
 
      IF (N .GT. NLINES(FILE)) THEN
   30   CONTINUE
        IF (READIN(FILE,N) .EQ. -100) THEN
          GETL = -100
          RETURN
 
        ELSE IF (FILE .EQ. 2) THEN
          NLINES(FILE) = N
          GO TO 10
 
        ELSE IF (BUF(TEXT(FILE,N),1) .EQ. 100) THEN
          POINT = TEXT(FILE,N) + 1
          VERSN = CTOI(BUF, POINT)
          IF (VERSN .LT. VERSIO) THEN
   20       CONTINUE
              SAVEP = P(FILE)
              IF (READIN(FILE,N) .EQ. -100) THEN
                GETL = -100
                RETURN
              END IF
              POINT = TEXT(FILE,N) + 1
              IF(BUF(SAVEP,1).EQ.101.AND.CTOI(BUF,POINT).EQ.VERSN)THEN
                POINT = 2
              ELSE
                GO TO 20
              END IF
          END IF
        ELSE IF (BUF(TEXT(FILE,N),1) .EQ. 46) THEN
          LENGTH = LENGTH + 1
        ELSE
          GO TO 30
        END IF
        NLINES(FILE) = N
      END IF
 
   10 CONTINUE
      GETL = TEXT(FILE,N)
 
      END
C-------------------------------------------------------------------------
C
      SUBROUTINE GETTIM(FP)
 
      INTEGER FP
      INTEGER YEAR, MONTH, DAY, HOUR, MINUTE, SECOND, MILLI
      INTEGER ITOC, JUNK
      INTEGER BUFFER(6)
 
      CALL ZTIME(YEAR,MONTH,DAY,HOUR,MINUTE,SECOND,MILLI)
      CALL PUTCH(32, FP)
      IF (MONTH .EQ. 1) THEN
        CALL ZCHOUT('jan .',FP)
      ELSE IF (MONTH .EQ. 2) THEN
        CALL ZCHOUT('feb .',FP)
      ELSE IF (MONTH .EQ. 3) THEN
        CALL ZCHOUT('mar .',FP)
      ELSE IF (MONTH .EQ. 4) THEN
        CALL ZCHOUT('apr .',FP)
      ELSE IF (MONTH .EQ. 5) THEN
        CALL ZCHOUT('may .',FP)
      ELSE IF (MONTH .EQ. 6) THEN
        CALL ZCHOUT('jun .',FP)
      ELSE IF (MONTH .EQ. 7) THEN
        CALL ZCHOUT('jul .',FP)
      ELSE IF (MONTH .EQ. 8) THEN
        CALL ZCHOUT('aug .',FP)
      ELSE IF (MONTH .EQ. 9) THEN
        CALL ZCHOUT('sep .',FP)
      ELSE IF (MONTH .EQ. 10) THEN
        CALL ZCHOUT('oct .',FP)
      ELSE IF (MONTH .EQ. 11) THEN
        CALL ZCHOUT('nov .',FP)
      ELSE IF (MONTH .EQ. 12) THEN
        CALL ZCHOUT('dec .',FP)
      END IF
      CALL ZITOCP(DAY, BUFFER, 2, 48)
      CALL PUTLIN(BUFFER,FP)
 
      CALL PUTCH(32, FP)
      CALL ZITOCP(HOUR, BUFFER, 2, 48)
      CALL PUTLIN(BUFFER,FP)
      CALL PUTCH(58, FP)
      CALL ZITOCP(MINUTE, BUFFER, 2, 48)
      CALL PUTLIN(BUFFER,FP)
 
      CALL PUTCH(58, FP)
      CALL ZITOCP(SECOND, BUFFER, 2, 48)
      CALL PUTLIN(BUFFER,FP)
 
      CALL PUTCH(32, FP)
      JUNK = ITOC(YEAR, BUFFER, 6)
      CALL ZPTMES(BUFFER,FP)
 
      END
C------------------------------------------------------------------------
C
      SUBROUTINE GETVER(ARGC, I, VERSIO)
 
      INTEGER ARGC, I, VERSIO
      INTEGER LAST, LASTVE, OUTP, FIXEND, NEXTLN, JUNK, ITOC
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
      LAST = LASTVE()
      IF (VERSIO .LT. 0 .OR. VERSIO .GT. LAST) THEN
        CALL ZCHOUT('VC: VERSION .', 2)
        CALL ZPTINT(VERSIO, 1, 2)
        CALL ZCHOUT(' OF .', 2)
        CALL PUTLIN(VFNAME, 2)
        CALL ZMESS(' DOES NOT EXIST.', 2)
        CALL ZQUIT(-1)
      END IF
      IF (VERSIO .EQ. 0) THEN
        VERSIO = LAST
      END IF
 
      OUTP = FIXEND(ARGC, I, 1)
 
   10 CONTINUE
        IF(NEXTLN(VERSIO, -1) .EQ. -100) RETURN
        CALL PUTOUT(VERSIO, LINE, OUTP)
      GO TO 10
 
      END
C---------------------------------------------------------------------
C
      SUBROUTINE HELP
 
      CALL ZMESS('VC: VERSION CONTROL PROGRAM.', 1)
      CALL ZMESS('    USAGE: VC,-<option>,VERSION-FILE [,FILE].', 1)
      CALL ZMESS('    OPTIONS (* : FILE NAME REQUIRED):.', 1)
      CALL ZMESS('      C[<n>]  DETAIL CONTENTS.', 1)
      CALL ZMESS('      D[<n>]  VERSION DIFFERENCES.', 1)
      CALL ZMESS('     *T<time> PRODUCE VERSION AS AT TIME.', 1)
      CALL ZMESS('     *U       UPDATE THE VERSION FILE.', 1)
      CALL ZMESS('     *V[<n>]  REPRODUCE VERSION N.', 1)
      CALL ZQUIT(-1)
 
      END
C-------------------------------------------------------------------------
C
      SUBROUTINE INITVE(VNAME, FP)
 
      INTEGER VNAME(*),FP
      INTEGER BUFFER(134)
      INTEGER CREATE, GETLIN
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
      CALL ZCHOUT('Initialise version file ".', 1)
      CALL PUTLIN(VNAME, 1)
      CALL ZMESS('".', 1)
 
      VP = CREATE(VNAME, 1)
      IF(VP .EQ. -1) THEN
        CALL CANT(VNAME)
        CALL ZQUIT(-1)
      END IF
      CALL PUTTOP(VP, 1)
      CALL ZMESS('a1.', VP)
   10 CONTINUE
        IF(GETLIN(BUFFER, FP) .EQ. -100) GO TO 20
        CALL PUTCH(46,VP)
        CALL PUTLIN(BUFFER,VP)
      GO TO 10
 
   20 CONTINUE
      CALL ZMESS('e1.', VP)
 
      END
C-----------------------------------------------------------------------
C
C  READ IN A LINE AND CHECK THAT IT IS VALID, VALID LINES START
C  WITH A, C, D, E, V OR A PERIOD CHARACTER. NOTE THAT THE
C  PERIOD IS USED IN PLACE OF A BLANK FOR NORMAL LINES SO THAT
C  FORTRAN BLANK COMMENT LINES CAN BE DEALT WITH PROPERLY (TIE
C  DELETES TRAILING BLANKS DURING I/O).
C
      INTEGER FUNCTION INLINE()
 
      INTEGER I
      INTEGER GETLIN, INDEXX
      INTEGER OPTS(7)
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
      DATA (OPTS(I), I = 1, 7)/97,99,100,101,118,46,129/
 
      INLINE = GETLIN(LINE, VP)
 
      TYP = LINE(1)
      CALL SCOPY(LINE, 2, LINE, 1)
      IF (INLINE .EQ. -100) RETURN
 
      IF (INDEXX(OPTS, TYP) .EQ. 0) CALL VCERR('CORRUPT VERSION FILE.')
 
      END
C------------------------------------------------------------------------
C
      INTEGER FUNCTION LASTVE()
 
      INTEGER INLINE, POS, CTOI
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
      LASTVE = 0
      IF (INLINE() .EQ. -100) RETURN
 
      IF (TYP .NE. 118) CALL VCERR('CORRUPT VERSION FILE.')
 
      POS = 1
      LASTVE = CTOI(LINE,POS)
 
      END
C---------------------------------------------------------------------
C
      INTEGER FUNCTION MATCH(I,J)
 
      INTEGER I, J
      INTEGER S1, S2, T1, T2, GETL, EQUIV
 
      S1 = GETL(1,I+1)
      S2 = GETL(1,I+2)
      T1 = GETL(2,J+1)
      T2 = GETL(2,J+2)
      IF (S1.EQ.-100 .OR. S2.EQ.-100 .OR. T1.EQ.-100 .OR. T2 .EQ. -100)
     *THEN
        MATCH = -2
      ELSE IF (EQUIV(S1,T1) .EQ. -2 .AND. EQUIV(S2,T2) .EQ. -2) THEN
        MATCH = -2
      ELSE
        MATCH = -3
      END IF
 
      END
C-------------------------------------------------------------------------
C
      SUBROUTINE NEWVER
 
      INTEGER S1, S2
      INTEGER GETL, EQUIV, RESYNC
 
      CALL STARTT
 
   10 CONTINUE
        S1 = GETL(1, 1)
        S2 = GETL(2, 1)
        IF ((S1 .EQ. -100) .OR. (S2 .EQ. -100)) GO TO 20
        IF (EQUIV(S1, S2) .EQ. -3) THEN
          IF (RESYNC() .EQ. 1) GO TO 20
        END IF
        CALL SEND (1, 1)
        CALL PURGE(2, 1)
      GOTO 10
 
   20 CONTINUE
      CALL FLUSHH
 
      END
C--------------------------------------------------------------------
C
C  GET THE NEXT LINE OUT OF THE FILE
C
      INTEGER FUNCTION NEXTLN(VERSIO, FP)
 
      INTEGER VERSIO, FP
      INTEGER INLINE, N, VNBR
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
   10 CONTINUE
        IF(INLINE() .EQ. -100) GO TO 20
        IF (TYP .EQ. 46) THEN
          NEXTLN = -2
          RETURN
        END IF
        IF (FP .NE. -1) THEN
          CALL PUTCH(TYP,   FP)
          CALL PUTLIN(LINE, FP)
        END IF
        N = VNBR()
        IF ((TYP .EQ. 97 .AND. N .GT. VERSIO) .OR.
     +      (TYP .EQ. 100 .AND. N .LE. VERSIO)) THEN
          CALL SKIPEN(N, FP)
        END IF
      GO TO 10
 
   20 CONTINUE
      NEXTLN = -100
 
      END
C--------------------------------------------------------------------------
C
      SUBROUTINE PURGE(FILE,J)
 
      INTEGER FILE, J
      INTEGER I, SHIFT
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
      SAVE
 
      IF (J .EQ. NLINES(FILE)) THEN
        NLINES(FILE) = 0
        P(FILE) = 1
      ELSE
        SHIFT = TEXT(FILE,J+1) - 1
        I = TEXT(FILE,J+1)
   10   IF (I .LT. P(FILE)) THEN
          BUF(I-SHIFT,FILE) = BUF(I,FILE)
          I = I + 1
          GO TO 10
        ENDIF
        NLINES(FILE) = NLINES(FILE) - J
        I = 1
   20   IF(I .LE. NLINES(FILE)) THEN
          TEXT(FILE,I) = TEXT(FILE,I+J) - SHIFT
          I = I + 1
          GO TO 20
        ENDIF
        P (FILE) = P(FILE) - SHIFT
      END IF
 
      END
C--------------------------------------------------------------------
C
C  OUTPUT A LINE, CHECK FOR THE CHARACTER PAIR 'V#' AND REPLACE IT
C  WITH THE VERSION NUMBER
C
      SUBROUTINE PUTOUT(VERSIO,S,FD)
 
      INTEGER VERSIO, FD, I, JUNK
      INTEGER S(*), VERNBR(6)
      INTEGER ITOC, ZLOWER
 
      I = 1
   10 IF(S(I) .NE. 129) THEN
        IF((ZLOWER(S(I)) .EQ. 118) .AND. (S(I+1) .EQ. 35)) THEN
          JUNK = ITOC(VERSIO, VERNBR, 6)
          CALL PUTLIN(VERNBR, FD)
          CALL PUTCH(46, FD)
          I = I + 1
        ELSE
          CALL PUTCH(S(I),FD)
        END IF
        I = I + 1
        GO TO 10
      ENDIF
 
      END
C---------------------------------------------------------------------------
C
      SUBROUTINE PUTTOP(FP, VNBR)
 
      INTEGER FP, VNBR
      INTEGER JUNK, ZGTCMD
      INTEGER BUFFER(134)
 
      CALL PUTCH(118, FP)
      CALL ZPTINT(VNBR, 1, FP)
 
      CALL GETTIM(FP)
      CALL ZMESS('Enter Comment Describing the Changes Made:.', 1)
      CALL ZMESS('(End with a Blank Line o'//'r Single Period).', 1)
 
   10 CONTINUE
        IF(ZGTCMD(BUFFER, 0) .LE. 0) RETURN
        IF((BUFFER(1) .EQ. 46) .AND. (BUFFER(2) .EQ. 129)) RETURN
        CALL PUTCH(99, FP)
        CALL ZPTMES(BUFFER, FP)
      GO TO 10
 
      END
C--------------------------------------------------------------------------
C
      INTEGER FUNCTION READIN(FILE, N)
 
      INTEGER FILE, N, LEN
      INTEGER GETLIN
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
      SAVE
 
      TEXT(FILE,N) = P(FILE)
      IF (FILE .EQ. 2) THEN
        BUF(P(2), 2) = 46
        P(2) = P(2) + 1
      END IF
      IF (P(FILE) .GT. 10000 - 132) CALL VCERR
     +              ('VC: difference is too complex.')
      LEN = GETLIN(BUF(P(FILE),FILE), FP(FILE))
 
      IF (LEN .NE. -100) THEN
        P(FILE) = P(FILE) + LEN
      ELSE IF (FILE .EQ. 2) THEN
        P(2) = P(2) - 1
      END IF
 
      READIN = LEN
 
      END
C---------------------------------------------------------------------------
C
      INTEGER FUNCTION RESYNC()
 
      INTEGER I, J, S1, S2, GETL, EQUIV, MATCH, CHANGE
 
      DO 100 I = 2, 250
        S1 = GETL(1,I)
        IF (S1 .NE. -100) THEN
          DO 10 J = 1, I - 1
            IF (EQUIV(S1,GETL(2,J)) .EQ. -2) THEN
              IF (MATCH(I,J) .EQ. -2) THEN
                RESYNC = CHANGE(I-1,J-1)
                RETURN
              END IF
            END IF
   10     CONTINUE
        END IF
 
        S2 = GETL(2,I)
        IF (S2 .NE. -100) THEN
          DO 20 J = 1, I
            IF (EQUIV(GETL(1,J),S2) .EQ. -2) THEN
              IF (MATCH(J,I) .EQ. -2) THEN
                RESYNC = CHANGE(J-1,I-1)
                RETURN
              END IF
            END IF
   20     CONTINUE
        END IF
        IF (S1 .EQ. -100 .AND. S2 .EQ. -100) THEN
          RESYNC = 1
          RETURN
        END IF
  100 CONTINUE
 
      CALL VCERR('VC: difference is too complicated.')
 
      END
C--------------------------------------------------------------------------
C
      SUBROUTINE SEND(FILE,J)
 
      INTEGER FILE, J
      INTEGER LIM, I
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
      SAVE
 
      IF (J .EQ. NLINES(FILE)) THEN
        LIM = P(FILE)
      ELSE
        LIM = TEXT(FILE,J+1)
      END IF
 
      DO 10 I = 1, LIM-1
        CALL PUTCH(BUF(I, FILE), TP)
   10 CONTINUE
 
      CALL PURGE(FILE,J)
 
      END
C-----------------------------------------------------------------------
C
      SUBROUTINE SKIPEN(VERSIO, FP)
 
      INTEGER VERSIO, FP
      INTEGER INLINE, VNBR
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
   10 CONTINUE
        IF (INLINE() .EQ. -100) CALL VCERR('CORRUPT VERSION FILE.')
        IF (FP .NE. -1) THEN
          CALL PUTCH (TYP,  FP)
          CALL PUTLIN(LINE, FP)
        END IF
        IF ((TYP .EQ. 101) .AND. (VNBR() .EQ. VERSIO)) RETURN
      GO TO 10
 
      END
C--------------------------------------------------------------------------
C
      SUBROUTINE STARTT
 
      INTEGER INLINE, NEXTLN, VNBR, BUFFER(5), JUNK, ITOC, I
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
      IF (INLINE() .EQ. -100) CALL VCERR('CORRUPT VERSION FILE.')
      IF (TYP .NE. 118)     CALL VCERR('CORRUPT VERSION FILE.')
 
      VERSIO = VNBR() + 1
      CALL ZCHOUT('Version .', 1)
      CALL PUTDEC(VERSIO, 1)
      CALL ZMESS(':.', 1)
 
      CALL PUTTOP(TP, VERSIO)
      CALL PUTCH(TYP,TP)
      CALL PUTLIN(LINE,TP)
      IF (NEXTLN(VERSIO-1, TP) .EQ. -100) CALL VCERR
     +                              ('CORRUPT VERSION FILE.')
      BUF(1,1) = TYP
 
      I = 1
   20 CONTINUE
        IF(LINE(I) .EQ. 129) GO TO 10
        BUF(I+1, 1) = LINE(I)
        I = I + 1
      GO TO 20
 
   10 CONTINUE
      P(1)      = I + 1
      TEXT(1,1) = 1
      NLINES(1) = 1
      LENGTH    = 1
      P(2)      = 1
      NLINES(2) = 0
 
      END
C--------------------------------------------------------------------------
C
      SUBROUTINE UPDATE(ARGC, I)
 
      INTEGER ARGC, I, STATUS, C
      INTEGER FIXEND, CREATE, GETLIN, ZLOWER
      INTEGER MESS8(5), JUNK(134)
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
      SAVE
 
      DATA (MESS8(C), C=1, 5)/79, 75, 63, 32, 129/
 
      FP(2) = FIXEND(ARGC, I, 0)
      IF (VP .EQ. -1) THEN
        CALL INITVE(VFNAME, FP(2))
        RETURN
      END IF
 
      FP(1) = VP
      TP = CREATE(TNAME(TFIRST), 2)
      IF (TP .EQ. -1) CALL VCERR('VC: cannot create scratch file.')
 
      CALL NEWVER
      CALL CLOSE(VP)
      CALL CLOSE(TP)
C
C  TELL THE USER THE EFFECTS OF THE CHANGES
C
      CALL ZCHOUT('Version .', 1)
      CALL PUTDEC(VERSIO, 1)
      CALL ZCHOUT(' of ".', 1)
      CALL PUTLIN(VFNAME, 1)
      CALL ZMESS('":.', 1)
      CALL PUTDEC(ICNT-1, 1)
      CALL ZMESS(' LINES INSERTED.', 1)
      CALL PUTDEC(DCNT, 1)
      CALL ZMESS(' LINES DELETED.', 1)
      CALL PUTDEC(LENGTH-DCNT, 1)
      CALL ZMESS(' LINES UNCHANGED.', 1)
C
C  ASK THE USER IF IT'S ALRIGHT TO UPDATE THE MASTER
C
      CALL ZPRMPT(MESS8)
      STATUS = GETLIN(JUNK, 0)
      C = ZLOWER(JUNK(1))
 
      IF (C .EQ. 121 .OR. STATUS .LT. 0) THEN
        CALL AMOVE(TNAME(TFIRST), VFNAME)
      ELSE
        CALL PUTLIN(VFNAME, 1)
        CALL ZMESS(' NOT UPDATED.', 1)
      END IF
 
      END
C---------------------------------------------------------------------
C
      SUBROUTINE VCERR(STRING)
 
      CHARACTER*(*) STRING
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
      SAVE
 
      CALL REMOVE(TNAME(TFIRST))
      CALL ERROR(STRING)
      END
C-----------------------------------------------------------------------
C
      SUBROUTINE VERSDI(VERSIO)
 
      INTEGER VERSIO, N, PRINTS, LINENB, PREV, JUNK
      INTEGER INLINE, VNBR, ITOC
      INTEGER NUMBER(81)
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
      PRINTS = 0
      LINENB = 0
      PREV = 0
 
      CALL ZOBLNK(12, 1)
      CALL ZCHOUT('CHANGES INTRODUCED AT VERSION .', 1)
      CALL PUTDEC(VERSIO, 1)
      CALL SKIP(1)
 
   10 IF(INLINE() .NE. -100) THEN
        IF (TYP .EQ. 46) THEN
          IF (PREV .EQ. 1) THEN
            LINENB = LINENB + 1
          END IF
          IF (PRINTS .EQ. 1) THEN
            CALL PUTLIN(LINE,1)
          END IF
        ELSE IF (TYP .EQ. 97) THEN
          N = VNBR()
          IF (N .LT. VERSIO) THEN
            PREV = 1
          ELSE IF (N .EQ. VERSIO) THEN
            CALL SKIP(1)
            CALL ZCHOUT('appended after line .', 1)
            CALL PUTDEC(LINENB, 1)
            CALL SKIP(1)
            PREV = 0
            PRINTS = 1
          ELSE
            CALL SKIPEN(N, -1)
          END IF
        ELSE IF (TYP .EQ. 100) THEN
          N = VNBR()
          IF (N .LT. VERSIO) THEN
            PREV = 0
          ELSE IF (N .EQ. VERSIO) THEN
            CALL SKIP(1)
            CALL ZCHOUT('deleted at line .', 1)
            CALL PUTDEC(LINENB+1, 1)
            CALL SKIP(1)
            PREV = 1
            PRINTS = 1
          END IF
        ELSE IF (TYP .EQ. 101) THEN
          N = VNBR()
          IF (N .LT. VERSIO) THEN
            PREV = 1
          ELSE IF (N .EQ. VERSIO) THEN
            PREV = 1
            PRINTS = 0
          END IF
        END IF
 
        GO TO 10
      ENDIF
 
      END
C---------------------------------------------------------------------
C
C  MAIN ROUTINE - RECOVER AND CHECK ARGUMENTS, NO PROMPTING FOR
C                 MISSING ARGUMENTS IS PERFORMED AND THE OPTION
C                 BE THE FIRST SPECIFIED ARGUMENT.
C                 OPTION 'S' REMOVED FROM OPTION LIST.
C
      SUBROUTINE VERSIN
 
      INTEGER I, VAL, ARGC, POS, C, OPTION, JUNK
      INTEGER OPTS(6)
      INTEGER OPEN, GETARG, CTOI, INDEXX, ZGTCMD, ZLOWER
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CUPDAT/ FP, TP, BUF, TEXT, P, NLINES, VERSIO, LENGTH,
     +                TNAME, TFIRST, ICNT, DCNT
      INTEGER FP(2), BUF(10000,2), TEXT(2,250), P(2), NLINES(2),
     +        TNAME(81)
      INTEGER VERSIO, TP, ICNT, DCNT, LENGTH, TFIRST
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
      DATA (OPTS(I), I = 1, 6)/99, 100, 116, 117, 118, 129/
 
      OPTION = 32
C
C  RECOVER THE OPTION ARGUMENT
C
      IF(GETARG(1, OPTVAL, 134) .EQ. -100) THEN
        CALL ZMESS
     +    ('Enter Option (-c[n], -d[n], -t[time], -u, -v[n]):.', 1)
        JUNK = ZGTCMD(OPTVAL, 0)
      END IF
 
      IF(OPTVAL(1) .EQ. 129) CALL HELP
 
      POS = 1
      CALL SKIPBL(OPTVAL, POS)
      IF(OPTVAL(1) .EQ. 45) POS = POS + 1
      OPTION = ZLOWER(OPTVAL(POS))
 
      IF(INDEXX(OPTS, OPTION) .EQ. 0) THEN
        CALL PUTLIN(OPTVAL, 1)
        CALL ZMESS(': illegal flag.', 1)
        CALL HELP
      END IF
 
      IF (OPTION .EQ. 116) THEN
        VAL = 1
      ELSE
        VAL = CTOI(OPTVAL, POS)
      END IF
C
C  RECOVER THE VERSION FILE NAME ARGUMENT
C
      ARGC = 2
      IF (GETARG(2, VFNAME, 81) .EQ. -100) THEN
        CALL ZMESS('Enter version file name:.', 1)
        IF(ZGTCMD(VFNAME, 0) .LE. 0) CALL HELP
      END IF
C
C  RECOVER THE SOURCE/DESTINATION FILE NAME IF REQUIRED
C
      IF((OPTION .EQ. 116) .OR. (OPTION .EQ. 117) .OR.
     +   (OPTION .EQ. 118)) THEN
        ARGC = 3
        IF (GETARG(3, FILNAM, 81) .EQ. -100) THEN
          IF(OPTION .EQ. 117) THEN
            CALL ZMESS('Enter source file name:.', 1)
          ELSE
            CALL ZMESS('Enter destination file name:.', 1)
          ENDIF
          IF(ZGTCMD(FILNAM, 0) .LE. 0) CALL HELP
        END IF
      ENDIF
C
C  ENSURE THAT THE VERSION FILE IS AVAIABLE, OR IF IT IS NOT THEN
C  CHECK THAT THIS IS AN UPDATE OPERATION (IE: CREATE A NEW VERSION FILE)
C
      VP = OPEN(VFNAME, 0)
      IF (VP .EQ. -1 .AND. OPTION .NE. 117) THEN
        CALL CANT(VFNAME)
        CALL ZQUIT(-1)
      END IF
      IF(VFNAME(1) .NE. 35) TFIRST = 2
C
C  PERFORM THE REQUESTED OPERATION OR GIVE HELP INFORMATION
C
      IF (OPTION .EQ. 99) THEN
        CALL CONTEN(VAL)
 
      ELSE IF (OPTION .EQ. 100) THEN
        CALL DIFFER(VAL)
 
      ELSE IF (OPTION .EQ. 116) THEN
        CALL CUTOFF(ARGC, 1, VAL)
 
      ELSE IF (OPTION .EQ. 117) THEN
        CALL UPDATE(ARGC, 1)
 
      ELSE IF (OPTION .EQ. 118) THEN
        CALL GETVER(ARGC, 1, VAL)
 
      ELSE
        CALL HELP
 
      END IF
 
      END
C------------------------------------------------------------------------
C
      INTEGER FUNCTION VNBR()
 
      INTEGER POS, CTOI
C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
      COMMON /CLINE/ VP, TYP, LINE, OPTVAL, VFNAME, FILNAM
      INTEGER VP
      INTEGER TYP
      INTEGER LINE(134),   OPTVAL(134)
      INTEGER VFNAME(81), FILNAM(81)
      SAVE
 
      POS = 1
      VNBR = CTOI(LINE, POS)
 
      END
