C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
C
C  ZTBACC - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  ACCESS A TABLE BY ENTRY NUMBER
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' OR 'NOERR'.
C
      INTEGER FUNCTION ZTBACC(ENTRY, KEY, KEYLEN, VALUES, ARRAY)
 
      INTEGER KEYLEN, I, OFFSET, ENTRY
      INTEGER ARRAY(*), KEY(*), VALUES(*)
 
      ZTBACC = -1
      IF(ARRAY(1) .NE.     116) RETURN
      IF(ENTRY    .LE.        0) RETURN
      IF(ENTRY    .GT. ARRAY(4)) RETURN
 
      OFFSET = (ARRAY(3) + 2) * (ENTRY - 1) + 10
      KEYLEN = ARRAY(OFFSET - 1)
 
      DO 10 I = 1, ARRAY(3)
        VALUES(I) = ARRAY(OFFSET + I)
   10 CONTINUE
 
      OFFSET = ARRAY(OFFSET) - 1
      DO 20 I = 1, KEYLEN
        KEY(I) = ARRAY(OFFSET +  I)
   20 CONTINUE
 
      ZTBACC = -2
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZTBUPD - 27 SEP 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  UPDATE A TABLE ENTRY BY ENTRY NUMBER
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' OR 'NOERR'.
C
      INTEGER FUNCTION ZTBUPD(ENTRY, VALUES, ARRAY)
 
      INTEGER I, OFFSET, ENTRY
      INTEGER ARRAY(*), VALUES(*)
 
      ZTBUPD = -1
      IF(ARRAY(1) .NE.     116) RETURN
      IF(ENTRY    .LE.        0) RETURN
      IF(ENTRY    .GT. ARRAY(4)) RETURN
 
      OFFSET = (ARRAY(3) + 2) * (ENTRY - 1) + 10
 
      DO 10 I = 1, ARRAY(3)
        ARRAY(OFFSET + I) = VALUES(I)
   10 CONTINUE
 
      ZTBUPD = -2
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZTBFND - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  FIND AN ENTRY IN THE TABLE
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' OR THE ENTRY NUMBER.
C
      INTEGER FUNCTION ZTBFND(KEY, KEYLEN, ARRAY)
 
      INTEGER KEYLEN, I, OFFSET, ENTRY, POINT
      INTEGER ARRAY(*), KEY(*)
 
      ZTBFND = -1
      IF(ARRAY(1) .NE.     116) RETURN
      IF(KEYLEN   .LE.        0) RETURN
      IF(KEYLEN   .GT. ARRAY(6)) RETURN
      IF(ARRAY(4) .EQ.        0) RETURN
C
      OFFSET = 9
      DO 10 ENTRY = 1, ARRAY(4)
        IF(ARRAY(OFFSET) .EQ. KEYLEN) THEN
          POINT = ARRAY(OFFSET + 1) - 1
          DO 20 I = 1, KEYLEN
            IF(KEY(I) .NE. ARRAY(I + POINT)) GO TO 30
   20     CONTINUE
          ZTBFND = ENTRY
          RETURN
        ENDIF
   30   CONTINUE
        OFFSET = OFFSET + ARRAY(3) + 2
   10 CONTINUE
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZTBGET - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  GET AN ENTRY FROM THE TABLE
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' OR THE ENTRY NUMBER.
C
      INTEGER FUNCTION ZTBGET(KEY, KEYLEN, VALUES, ARRAY)
 
      INTEGER KEYLEN, I, OFFSET, ENTRY
      INTEGER ARRAY(*), KEY(*), VALUES(*)
      INTEGER ZTBFND
 
      ZTBGET = -1
C
      ENTRY = ZTBFND(KEY, KEYLEN, ARRAY)
      IF(ENTRY .EQ. -1) RETURN
 
      ZTBGET = ENTRY
*$XX$ RMJI 18MAY84: CHANGE 2 TO 10
      OFFSET = (ARRAY(3) + 2) * (ENTRY - 1) + 10
      DO 10 I = 1, ARRAY(3)
        VALUES(I) =  ARRAY(OFFSET + I)
   10 CONTINUE
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZTBINT - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  INITIALISE AN ARRAY AS A TABLE
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' (THE SIZE OF THE ARRAY
C  OR SPECIFIED WIDTH IS WRONG) OR 'NOERR'. THERE IS
C  AN OVERHEAD OF 8 LOCATIONS RESERVED BY THE ROUTINES. NOT ALL THE
C  RESERVED LOCATIONS ARE USED AT PRESENT.
C  AN ADDITIONAL OVERHEAD OF 2 LOCATIONS PER TABLE ENTRY IS USED TO
C  RETAIN THE KEY LENGTH AND KEY LOCATION POINTERS.
C  TABLE ENTRIES START AT THE BEGINNING OF ARRAY AND WORK UPWARDS
C  KEY STORAGE STARTS AT THE END OF ARRAY AND WORK DOWNWARDS
C
      INTEGER FUNCTION ZTBINT(ARRAY, SIZE, WIDTH)
 
      INTEGER SIZE, WIDTH
      INTEGER ARRAY(*)
 
      ZTBINT = -1
      IF(WIDTH .LT. 0)          RETURN
      IF(SIZE  .LT. WIDTH + 11) RETURN
 
C  IDENTIFY THE ARRAY AS A TABLE
      ARRAY(1) = 116
C  THE SIZE OF THE ARRAY
      ARRAY(2) = SIZE
C  THE WIDTH OF EACH ELEMENT
      ARRAY(3) = WIDTH
C  THE NUMBER OF ENTRIES
      ARRAY(4) = 0
C  THE NEXT FREE LOCATION FOR KEY ENTRY
      ARRAY(5) = SIZE
C  THE MAXIMUM KEY LENGTH YET SPECIFIED
      ARRAY(6) = 0
C  UNUSED
      ARRAY(7) = 0
      ARRAY(8) = 0
 
      ZTBINT = -2
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZTBPUT - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  PLACE AN ENTRY IN THE TABLE (IF IT IS NOT ALREADY THERE)
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR', 'EOF'
C  OR THE ENTRY NUMBER.
C
      INTEGER FUNCTION ZTBPUT(KEY, KEYLEN, VALUES, ARRAY)
 
      INTEGER KEYLEN, I, OFFSET, ENTRY, FREE
      INTEGER ARRAY(*), KEY(*), VALUES(*)
      INTEGER ZTBFND
 
      ZTBPUT = -1
      IF(ARRAY(1) .NE.     116) RETURN
      IF(KEYLEN   .LE.        0) RETURN
C
C  IF THE KEY ALREADY EXISTS IN THE TABLE THEN JUST UPDATE THE VALUES
C
      ENTRY = ZTBFND(KEY, KEYLEN, ARRAY)
      IF(ENTRY .NE. -1) THEN
        ZTBPUT = ENTRY
        OFFSET = (ARRAY(3) + 2) * (ENTRY - 1) + 10
        DO 50 I = 1, ARRAY(3)
          ARRAY(OFFSET + I) = VALUES(I)
   50   CONTINUE
        RETURN
      ENDIF
C
C  CHECK THAT THERE IS SPACE TO PLACE THE NEW ENTRY
C
      ZTBPUT = -100
      FREE = ARRAY(5) - 8 -
     +       ((ARRAY(3) + 2) * ARRAY(4))
      IF(FREE .LT. (KEYLEN + ARRAY(3) + 2)) RETURN
 
      ARRAY(4) = ARRAY(4) + 1
      ZTBPUT = ARRAY(4)
      OFFSET = (ARRAY(3) + 2) * (ARRAY(4) - 1) + 9
      IF(KEYLEN .GT. ARRAY(6)) ARRAY(6) = KEYLEN
 
      ARRAY(OFFSET)   = KEYLEN
      ARRAY(OFFSET+1) = ARRAY(5) - KEYLEN + 1
      DO 10 I = 1, ARRAY(3)
        ARRAY(OFFSET + 1 + I) = VALUES(I)
   10 CONTINUE
 
      ARRAY(5) = ARRAY(5) - KEYLEN
      DO 20 I = 1, KEYLEN
        ARRAY(ARRAY(5) + I) = KEY(I)
   20 CONTINUE
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZTBTYP - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  RETURN DETAILS ON A TABLE
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' (THE ARRAY IS NOT
C  INITIALISED AS A TABLE) OR 'NOERR'.
C
      INTEGER FUNCTION ZTBTYP(ARRAY, WIDTH, ENTRYS, FREE, MAXKEY)
 
      INTEGER WIDTH, ENTRYS, FREE, MAXKEY
      INTEGER ARRAY(*)
 
      ZTBTYP = -1
      IF(ARRAY(1) .NE. 116) RETURN
 
C  THE WIDTH OF EACH ELEMENT
      WIDTH = ARRAY(3)
C  THE NUMBER OF ENTRIES
      ENTRYS = ARRAY(4)
C  THE AMOUNT OF FREE SPACE LEFT
      FREE = ARRAY(5) - 8 -
     +       ((ARRAY(3) + 2) * ARRAY(4))
C  THE MAXIMUM KEY LENGTH YET SPECIFIED
      MAXKEY = ARRAY(6)
 
      ZTBTYP = -2
 
      RETURN
      END
