#! /bin/csh
#  syn is a csh script to perform syntactic analysis of a Fortran program
#  using ISTLY.
#
#
#  Invocation:
#
#  syn Fortran_source_file
#
#  Check command line validity.
if ( $#argv == '0' ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
syn Fortran_source_file
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Error/Warning messages sent to standard output and may be redirected to a file.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  Check that Fortran_source_file exists.
if ( -e $1 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$1' does not exist."
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Make a tab-free copy of the Fortran source and use it as source.
set src = ly.src$$
expand $1 > _.TOOLPACK/$src
#  Comment file name.
set cmt = _.lycmt
#  Parse tree file name.
set tree = _.lytree
#  Symbol table file name.
set symb = _.ypsymb
#  Comment index file name.
set indx = _.lyindx
#  Create the interprocess file IST.CMD and append parameters for ISTLY.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src $cmt $tree $symb $indx
#
#  Invoke ISTLY.
#
TOOLPACKPATH/toolpack1.2/exec/istly.u
#
#  If tool terminated with errors, advise user to obtain listing.
if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Errors detected.  Invoke script "getlst" to obtain a listing showing'
TOOLPACKPATH/toolpack1.2/util/echoerr \
statement and token numbers.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
endif
#
/bin/rm -r _.TOOLPACK
#
