#! /bin/csh
#  fdiff is a csh script to compare the token and comment streams of
#  two Fortran programs using ISTFD.  If the optional third argument
#  is "nc", then only the token streams are compared.
#
#
#  Invocation:
#
#  fdiff Fortran_source_file_1 Fortran_source_file_2 [nc]
#
#  Check command line validity.
if ( $#argv < 2 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"fdiff Fortran_source_file_1 Fortran_source_file_2 [nc]"
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'If the optional third argument is "nc", comment differences are ignored.'
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
A report is sent to standard output and may be redirected to a file.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  Check that Fortran_source_file_1 exists.
if ( -e $1 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$1' does not exist."
   exit
endif
#  Check that Fortran_source_file_2 exists.
if ( -e $2 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$2' does not exist."
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Make a tab-free, upper case copy of Fortran_source_file_1 for lexing.
set src1 = src1
expand $1 | tr a-z A-Z > _.TOOLPACK/$src1
#  Lexer token stream file name for Fortran_source_file_1.
set tkn1 = tkn1
#  Lexer comment file name for Fortran_source_file_1.
set cmt1 = cmt1
#  Create the interprocess file IST.CMD and append parameters for ISTLX.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src1 - $tkn1 $cmt1
#
#  Invoke ISTLX.
#
TOOLPACKPATH/toolpack1.2/exec/istlx.u
#
#  If lexer errors are reported, advise user to obtain listing.
if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'First program has lexical scanning errors.  Invoke script "getlst"'
TOOLPACKPATH/toolpack1.2/util/echoerr \
to obtain a listing showing statement and token numbers.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   set prog1lex = error
else
   set prog1lex = ok
endif
#  Make a tab-free, upper case copy of Fortran_source_file_2 for lexing.
set src2 = src2
expand $2 | tr a-z A-Z > _.TOOLPACK/$src2
#  Lexer token stream file name for Fortran_source_file_2.
set tkn2 = tkn2
#  Lexer comment file name for Fortran_source_file_2.
set cmt2 = cmt2
#  Create the interprocess file IST.CMD and append parameters for ISTLX.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src2 - $tkn2 $cmt2
#
#  Invoke ISTLX.
#
TOOLPACKPATH/toolpack1.2/exec/istlx.u
#
#  If lexer errors are reported, advise user to obtain listing.
if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Second program has lexical scanning errors.  Invoke script "getlst"'
TOOLPACKPATH/toolpack1.2/util/echoerr \
to obtain a listing showing statement and token numbers.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   set prog2lex = error
else
   set prog2lex = ok
endif
#
#  If both programs lexed without error, prepare for differencing.
#
if ( $prog1lex == ok && $prog2lex == ok ) then
#  Create the interprocess file IST.CMD and append parameters for ISTFD.
   if ( $3 == nc ) then
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tkn1 $cmt1 $tkn2 $cmt2 \#1 'mode=statement'
   else
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tkn1 $cmt1 $tkn2 $cmt2 \#1 'mode=statement comment_check=yes'
   endif
#
#  Invoke ISTFD.
#
TOOLPACKPATH/toolpack1.2/exec/istfd.u
#
else
#  One or both programs had lexing errors.
endif
#
/bin/rm -r _.TOOLPACK
#
 
