#! /bin/csh
#  dac is a csh script to compare two data files using ISTDC.
#
#
#  Invocation:
#
#  dac data_file_1 data_file_2 [n]
#
#  The optional parameter "n" is a positive integer indicating that
#  two numbers in the data file are considered equal if their
#  absolute difference is less than or equal to 1.0D-n.  If n is not
#  specified, the default value n=6 is used.
#
#  Check command line validity.
if ( $#argv < 2 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"dac data_file_1 data_file_2 [n]"
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'The optional parameter "n" is a positive integer indicating that '
TOOLPACKPATH/toolpack1.2/util/echoerr \
two numbers in the data files are considered equal if their
TOOLPACKPATH/toolpack1.2/util/echoerr \
absolute difference is less than or equal to 1.0D-n.  If n is not
TOOLPACKPATH/toolpack1.2/util/echoerr \
specified, the default value n=6 is used.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
A report is sent to standard output and may be redirected to a file.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  Check that data_file_1 exists.
if ( -e $1 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$1' does not exist."
   exit
endif
#  Check that data_file_2 exists.
if ( -e $2 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$2' does not exist."
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Make a tab-free copy of data_file_1.
set file1 = $1
expand $1 > _.TOOLPACK/$file1
#  Make a tab-free copy of data_file_2.
set file2 = $2
expand $2 > _.TOOLPACK/$file2
#  Create the interprocess file IST.CMD and append parameters for ISTDC.
if ( $#argv == 3 ) then
TOOLPACKPATH/toolpack1.2/util/mkipf \
$file1 $file2 \#1 T2=1.0D-$3 H
else
TOOLPACKPATH/toolpack1.2/util/mkipf \
$file1 $file2 \#1 H
endif
#
#  Invoke ISTDC.
#
TOOLPACKPATH/toolpack1.2/exec/istdc.u
#
/bin/rm -r _.TOOLPACK
#
