#! /bin/csh
#  cname is a csh script to change program names and function generally
#  as a Fortran-intelligent stream editor, using ISTCN and ISTCR.
#
#
#  Invocation:
#
#  cname Polish_option_file command_file_1 command_file_2 Fortran_source_file
#
#  Polish_option_file is the name of a file containing Polish options used in
#  reconstructing the transformed Fortran.  If Polish_option_file is "-"
#  then default Polish options will be used.
#
#  command_file_1 and command_file_2 are the names of command files for
#  ISTCN and ISTCR, respectively.  If one or the other is not supplied,
#  its place in the command line must be occupied by "-".
#
#  Check command line validity.
if ( $#argv < 4 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
cname Polish_option_file command_file_1 command_file_2 Fortran_source_file
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Polish_option_file is created by using script "polx".'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'"-" in place of Polish_option_file gives default Polish options.'
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
command_file_1 and command_file_2 are the names of command files containing
TOOLPACKPATH/toolpack1.2/util/echoerr \
scan-related changes and attribute-related changes, respectively.  If one
TOOLPACKPATH/toolpack1.2/util/echoerr \
or the other is not supplied, its place in the command line must be occupied
TOOLPACKPATH/toolpack1.2/util/echoerr \
'by "-".' For information about command files refer to Users\' Guide.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Transformed code is sent to standard output and may be redirected to a file.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  "-" as Polish_option_file gives default options.
if ( $1 != - ) then
#  Check that Polish_option_file exists.
   if ( -e $1 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$1' does not exist."
      exit
   endif
endif
if ( $2 != - ) then
#  Check that command_file_1 exists.
   if ( -e $2 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$2' does not exist."
      exit
   endif
endif
if ( $3 != - ) then
#  Check that command_file_2 exists.
   if ( -e $3 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$3' does not exist."
      exit
   endif
endif
#  Check that Fortran_source_file exists.
if ( -e $4 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$4' does not exist."
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Make a tab-free copy of the Fortran source and use it as source.
set src = src$$
expand $4 > _.TOOLPACK/$src
#  ISTCN command file name.
set com1 = com1$$
#  ISTCR command file name.
set com2 = com2$$
#  ISTPL option file name.
if ( $1 == - ) then
   set polopts = -
else
   set polopts = \#$1
endif
#
if ( ( $2 != - ) && ( $3 != - ) ) then
#
#  Case 1: Both command files are supplied.  Sequence of invocations is
#  ISTCN (source in, tokens out, commands prepended to command file), ISTYP,
#  ISTCR (case folding command prepended to command file), ISTYF, ISTPL.
#
#  Token file name.
   set tkn = tkn$$
#  Comment file name.
   set cmt = cmt$$
#  Prepend directives for source in, tokens out, to command_file_1.
   echo '<source' > _.TOOLPACK/$com1
   echo '>token' >> _.TOOLPACK/$com1
   cat $2 >> _.TOOLPACK/$com1
#  Create the interprocess file IST.CMD and append parameters for ISTCN.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$com1 $src $tkn $cmt
#
#  Invoke ISTCN.
#
TOOLPACKPATH/toolpack1.2/exec/istcn.u
#
#  Exit if tool terminated with errors.
   if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Errors detected.  Script terminated.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
      /bin/rm -r _.TOOLPACK
      exit
   endif
#  Parse tree file name.
   set tree = tree$$
#  Symbol table file name (from ISTYP).
   set table = table$$
#  Comment index file name.
   set index = index$$
#  Create the interprocess file IST.CMD and append parameters for ISTYP.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tkn $cmt $tree $table $index
#
#  Invoke ISTYP.
#
TOOLPACKPATH/toolpack1.2/exec/istyp.u
#
#  Exit if tool terminated with errors.
   if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Errors detected.  Script terminated.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
      /bin/rm -r _.TOOLPACK
      exit
   endif
#  Prepend directive for case folding to command_file_2.
   echo '%f' > _.TOOLPACK/$com2
   cat $3 >> _.TOOLPACK/$com2
#  Symbol table file name (from ISTCR).
   set tblout = tout$$
#  Create the interprocess file IST.CMD and append parameters for ISTCR.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$table $tblout $com2
#
#  Invoke ISTCR.
#
TOOLPACKPATH/toolpack1.2/exec/istcr.u
#
#  Exit if tool terminated with errors.
   if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Errors detected.  Script terminated.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
      /bin/rm -r _.TOOLPACK
      exit
   endif
#  Output token stream file.
   set tknout = ytkn$$
#  Output comment stream file.
   set cmtout = ycmt$$
#  Create the interprocess file IST.CMD and append parameters for ISTYF.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tree $tblout $index $cmt $tknout $cmtout
#
#  Invoke ISTYF.
#
TOOLPACKPATH/toolpack1.2/exec/istyf.u
#
#  Exit if tool terminated with errors.
   if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Errors detected.  Script terminated.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
      /bin/rm -r _.TOOLPACK
      exit
   endif
#  Create the interprocess file IST.CMD and append parameters for ISTPL.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tknout $cmtout \#1 $polopts
#
TOOLPACKPATH/toolpack1.2/exec/istpl.u
#
else if ( ( $2 != - ) && ( $3 == - ) ) then
#
#  Case 2: First command file is supplied but not the second.  Invocation
#  is ISTCN (source in, source out, commands prepended to command file).
#
#  Output file name (not stdout immediately lest the output be mixed
#  with messages).
   set outq = outq$$
#  Prepend directives for source in, source out, to command_file_1.
   echo '<source' > _.TOOLPACK/$com1
   echo '>source' >> _.TOOLPACK/$com1
   cat $2 >> _.TOOLPACK/$com1
#  Create the interprocess file IST.CMD and append parameters for ISTCN.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$com1 $src $outq $polopts
#
#  Invoke ISTCN.
#
TOOLPACKPATH/toolpack1.2/exec/istcn.u
#
#  Exit if tool terminated with errors.
   if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Errors detected.  Script terminated.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
      /bin/rm -r _.TOOLPACK
      exit
   endif
   cat _.TOOLPACK/$outq
#
else if ( ( $2 == - ) && ( $3 != - ) ) then
#
#  Case 3: Second command file is supplied but not the first.  Sequence
#  of invocations is ISTLY, ISTCR (case folding command prepended to
#  command file), ISTYF, ISTPL.
#
#  Comment file name.
   set cmt = cmt$$
#  Parse tree file name.
   set tree = tree$$
#  Symbol table file name.
   set table = table$$
#  Comment index file name.
   set index = index$$
#  Create the interprocess file IST.CMD and append parameters for ISTLY.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src $cmt $tree $table $index
#
#  Invoke ISTLY.
#
TOOLPACKPATH/toolpack1.2/exec/istly.u
#
#  Exit if tool terminated with errors.
   if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Errors detected.  Script terminated.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
      /bin/rm -r _.TOOLPACK
      exit
   endif
#  Prepend directive for case folding to command_file_2.
   echo '%f' > _.TOOLPACK/$com2
   cat $3 >> _.TOOLPACK/$com2
#  Symbol table file name (from ISTCR).
   set tblout = tout$$
#  Create the interprocess file IST.CMD and append parameters for ISTCR.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$table $tblout $com2
#
#  Invoke ISTCR.
#
TOOLPACKPATH/toolpack1.2/exec/istcr.u
#
#  Exit if tool terminated with errors.
   if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Errors detected.  Script terminated.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
      /bin/rm -r _.TOOLPACK
      exit
   endif
#  Output token stream file.
set tknout = ytkn$$
#  Output comment stream file.
set cmtout = ycmt$$
#  Create the interprocess file IST.CMD and append parameters for ISTYF.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tree $tblout $index $cmt $tknout $cmtout
#
#  Invoke ISTYF.
#
TOOLPACKPATH/toolpack1.2/exec/istyf.u
#
#  Exit if tool terminated with errors.
   if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Errors detected.  Script terminated.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
      /bin/rm -r _.TOOLPACK
      exit
   endif
#  Create the interprocess file IST.CMD and append parameters for ISTPL.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tknout $cmtout \#1 $polopts
#
#  Invoke ISTPL.
#
TOOLPACKPATH/toolpack1.2/exec/istpl.u
#
else
#
#  Case 4: Neither command file is supplied.  In this case the script
#  cname has the same effect as pol (invokes ISTLP).
#
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
No command files supplied -- cname has the same effect as pol.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
#  Create the interprocess file IST.CMD and append parameters for ISTLP.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src \#1 $polopts
#
#  Invoke ISTLP.
#
TOOLPACKPATH/toolpack1.2/exec/istlp.u
#
endif
#
/bin/rm -r _.TOOLPACK
#
