/*-------------------------------*/
/*   TOOLPACK/1   Release: 1.1   */
/*-------------------------------*/
#include <ctype.h>
#include "define.h"
 
 
#include <sys/time.h>
#ifdef sgi
#include <time.h>
#endif
 
/* mask and shift for VAX 11/750 */
#define VPSHIFT  0
#define VPMASK   0x20202000
 
 
#include "globals1.h"
addset_(char1,set,point,max)
int *set, *point, *max, *char1;
 
{
 /* if point is less than max add IST character char to set set at point
    point, increment point and return yes. Otherwise return no.
    Note this routine may also be used for adding integer into arrays */
 
  if( *point > *max)
    return(NO);
 
 *(set + *point - 1) = *char1;
 (*point)++;
 return(YES);
 
}
 
alldig_(s)
int *s;
 
{
 /* check that all elements of IST-string are digits.
    return YES if so. NO otherwise.
    For null string return NO  */
 
   if( *s == EOS)return(NO);
 
   while(isdigit( *s))
        s++;
 
   if( *s == EOS) return(YES);
 
   return(NO);
 
}
 
ctoi_(line,point)
int *line, *point;
 
{
 /* convert the characters in line starting at point to an integer
    update point to indicate the first non-digit character after
    the number. Preceding whitespace is skipped, the number must
    be unsigned. If the first non-white space character after point
   is not a digit then the value zero is returned           */
 
 int n;
 int *ptr;
 
 /* step leading whitespace  */
 
 skipbl_(line,point);
 ptr = line + *point -1;
 
 /* collect the number */
 
 n = 0;
 while(isdigit( *ptr))
  {
    n=10*n + *ptr - '0';
    ptr++;
     (*point)++; /* increment the value of point - *point because */
                 /* it's coming from fortran 77                   */
  }
  return(n);
}
 
equal_(s1,s2)
int *s1, *s2;
 
{
 /* compare two strings for equality length and content.
    return YES if equal NO otherwise */
 if( *s1 != *s2)return(NO);
 
 while( *s1 != EOS && *s2 != EOS)
      if(*s1++ != *s2++) return(NO);
 
 if(*s1 == EOS &&  *s2 == EOS)return(YES);
 return(NO);
 
}
 
getwrd_(line,point,string)
int *line, *point, *string;
 
 
 /* copy the next word from LINE starting at point in string.
 Preceding white space is ignored. A word is defined as any sequence
 of characters delimited by whitespace, 'newline' or 'eos'.
 
 The length of the word is returned. */
 
{
int *val, i;
 
 /* clear preceding white space */
 
 skipbl_(line,point);
 val = line + *point -1 ;
 
 for(i=0; *val != EOS && *val != BLANK && *val != TAB && *val
               != NEWLINE && *point<=MAXLINE; val++,i++)
  string[i] = *val ;
 
  string[i] = EOS; /* this line may need to change */
  *point = *point + i ;
  return(i);          /* see bob Iles notes */
}
 
indexx_(string,char1)
int *string, *char1;
 
{
 /* return the position of the first occurrence of the character
 char in the string string. Return zero if char not in string.  */
 int i;
 if( *string == EOS)return(0);
 for(i=0; *string != *char1 && *string != EOS ; i++, string++);
 
 return(( *string == EOS) ? 0:i+1);
 
}
 
itoc_(value,string,size)
int *value, *string, *size ;
 
{
 /* convert the integer value to an IST-string representation
    in array string using up to size characters (inc.eos). If more
    than size characters are lost digits will be lost (most
    significant). The value may be negative. The length of the
    resulting string is returned                   */
 
int sign,i,j,k,n,c, *temp ;
 
 temp = string;
 n = *value;
 if( (sign = n)<0)
         n = -n;        /* work with absolute value */
 
 *temp++ = EOS;
 i=0;
 do {
      i++;
      *temp++ = n%10 + '0';
    }while ((n/=10)>0 && i < *size -1); /*strip off digits least sigf first */
 
    if(sign<0 && i<*size-1){
       *temp++ = MINUS;
       i++;             /* deal with the sign*/
      }
 for(j=0,k=i;j<k;j++,k--){  /*reverse the string */
     c=string[j];
     string[j]=string[k];
     string[k]=c;
     }
return(i);
}
 
length_(s)
int *s;
 
{ /* returns the length of an IST-string */
 int i;
 
 for(i=0 ; s[i] != EOS ; i++);
 return(i);
 
}
 
scopy_(from,i,to,j)
int *from, *to ;
int *i, *j ;
 
{
 /* copy from from(i) into array to starting at j up to an 'eos'
    leave i and j alone. The 'eos' goes as well
  */
 
      register int *k, *l ;
 
     for(k = from + *i - 1,l = to + *j - 1; *k != EOS; *l++ = *k++)
            ;
 
    *l = EOS;
 
}
 
set_(param,value,type,defalt,min,max)
int *param, *value, *type, *defalt, *min, *max;
 
{
 /* set the value of the argument PARAM to a new value and ensure
    it is in the range MIN to MAX (a value outside this range is
    set to the appropriate limit value). The value of PARAM is set
    according to the value of the type as follows :
 
    type = 'newline'     param = defalt
    type = 'plus'        param = param + value
    type = 'minus'       param = value                          */
 
 switch( *type) {
 
    case NEWLINE :
               *param = *defalt;
               break;
 
    case PLUS :
               *param = *param + *value;
               break;
 
    case MINUS :
               *param = *param - *value;
               break;
 
    default    :
               *param = *value;
 
}
 *param = (*param > *max) ? *max : *param ;
 *param = (*param < *min) ? *min : *param ;
 
}
 
skipbl_(line,point)
int *line, *point;
 
{
   int *ptr;
   ptr = line + *point -1;
 /* ptr now points at line(point) */
 /* move the pointer point to the next non-whitespace character
    in line    */
 for(; *ptr == TAB || *ptr == BLANK ; ptr++,(*point)++);
 
                      /* next character */
                   /* update value of pointer */
}
 
type_(c)
int *c;
 
{
  /* type of c is 'digit'  if c belongs to [0 - 9]
                  'letter' if c belongs to [A-Z a-z]
                    c      if c is any other character */
 
 
 if(*c < 0 || *c > 127) return(*c);
 if(isalpha(*c)) return(LETTER);
 if(isdigit(*c)) return(DIGIT);
 return(*c);
}
 
xindex_(string,ch,allbut,lastto)
int *string, *ch, *allbut, *lastto ;
 
{
 /* a more versatile (?) version of indexx. If the value of allbut is set
    then reverse the sense of indexx
 
    viz if ch in string return zero
        else return lastto+1
 
  if ch = eof then result is set to no        */
 
  if( *ch == EOF) return(0);
 
  if( *allbut == NO) return(indexx_(string,ch));
 
 /* allbut = YES */
 
 return((indexx_(string,ch)) ? 0 : *lastto + 1);
 
}
 
zbyte_(integ,byte,flag)
int *byte, *flag;
unsigned *integ;
 
{
 /* return specified byte(byte) from integer (integ) leaving int unchanged
 
    if flag = yes value = small integer
            = no value is an A1 format
 
 N.B. These are the same for VAX 11/780 4.2 Berkely f77 */
 
 return( (*byte < 1 || *byte > 4) ? 0 : ( *integ << (4- *byte)*8) >>24 );
 
 /* get required byte by left shift to top followed by right shift
    to bottom. note both shifts bring in zeros.
 
    We are assuming 4 3 2 1 ordering    */
 
 
}
 
zcbyte_(integ,byte,newval)
 
int *byte ;
int *integ, *newval;
 
{
 /* change the value of the specified byte (BYTE) in the integer (VALUE)
    to be newval. Bytes are numbered 1 to cpi. Byte 1 contains the
    character in 1H or A1 format. The byte packing order is that used
    by the host machine in the packing of characters or holleriths
    into integers. The value of newval is restricted to the range
    0 - 2** 'bpc' -1 by masking if necessary */
 
  if( *byte < 1 || *byte > 4)
     return(ERR);
 
 *integ = (*integ & ~(255 << (*byte - 1)*8 )) |
           ((*newval & 255) << (*byte - 1)*8 );
  return(NOERR);
 
}
 
zcctoi_(from,to)
char *from;
int *to;
 
{
 /* converts a fortran 77 character to an IST character. Neither character
    set expansion nor compression is performed. It is assumed all f77
    characters can be represented as IST characters. If not a space should
    be returned.
 
    The result is the IST-character           */
 
  return( (*to = *from) );
}
 
zchtoi_(hol,ist)
int *hol;
int *ist;
 
{
 /* convert a hollerith character to an IST character. Neither character
    set expansion nor compression is performed. If the input character
    cannot be represented as an IST character, it is converted to a
    space.
 
    The ist character is returned via the function name */
 *ist = *hol;
 
 *ist = (*ist >> VPSHIFT) & 0x000000ff ;
 /* check - since hol can be any old integer       */
 
 if( *ist > NCHARS)
 {
    *ist = BLANK;
 }
 return( *ist);
 
}
 
zcitoc_(result,length,ist,ch)
char *result;
long int length;
unsigned *ist;
char *ch;
 
{
 /* convert an IST character to a fortran 77 character. Neither character
    set expansion nor compression is performed. If the input IST string
    cannot be represented as a fortran 77 character it is converted
    to a space.
 
    The result is also returned through the function name */
 
 
 
 *result = ( ( *ch = (( *ist < 0 || *ist > NCHARS) ? ' ' : *ist) ) );
 
}
 
zcitoh_(ist,hol,pad)
int *ist, *hol, *pad ;
 
{
 /* convert an IST character to a hollerith constant. Neither character
    set expansion nor compression is performed. If the input IST
    character cannot be represented as a hollerith constant it is
    converted to space. PAD is set to 'yes' to pad the constant with
    spaces; 'no' to leave the bytes zero, and 'host' to pad in the
    'natural' host manner, i.e. as when 1Hx assignment is made.
 
     The result is also returned through the function name */
 
 /* mask used is machine dependent */
 
 return( ( *hol = ( *pad == NO) ? *ist : (*ist << VPSHIFT) |  VPMASK ) );
 
 
}
 
zcompr_(s1,s2)
int *s1, *s2;
 
{
 /* compare two IST strings for equality. The two strings are allowed
    to be of separate lengths; only the number of characters in the
    shorter string are compared.                               */
 
  for(; *s1 != EOS && *s2 != EOS && *s1 == *s2; s1++, s2++) ;
 
  return( ( *s1 == EOS || *s2 == EOS) ? YES : NO);
 
}
 
zfield_(n,msb,lsb)
int *msb, *lsb ;
unsigned *n;
 
{
 /* Return the specified field of the integer value n.The result is
    the bits of n between bit MSB and bit LSB shifted into the least
    significant part of the result. Bits in n are numbered 1 to 'bpi'.
    msb = most significant bit and lsb = least significant bit.
    The result is returned through the function name. */
 
 /* this routine bears a strong resemblence to getbits p 45 */
 
  if( *msb > BPI || *lsb < 1 || *msb < *lsb)
    return(0);
 
    return(( *n >> ( *lsb -1)) & ~(~0 << ( *msb - *lsb +1)));
 
}
 
zhost_(bpi,cpi,bpc,rjust)
int *bpi, *cpi, *bpc, *rjust;
 
{
 /* return a set of host-system-specific values */
 
 /* number of bits per integer */
 
    *bpi = BPI;
 
 /* number of characters packed into an integer */
 
    *cpi = CPI;
 
 /* number of bits per character */
 
    *bpc = BPC;
 
/* 'yes' if machine right-justifies characters in integers
   'no ' if machine left-justifies characters in integers
   'err' if BPC*CPI != BPI or it neither left or right justifies */
 
     *rjust = RJUST;
 
}
 
ziand_(v1,v2)
int *v1, *v2 ;
 
{
 /* return a bitwise logical 'and' through the function name */
 
 return( *v1 & *v2);
 
}
 
zimpls_(s)
int *s;
 
{
 /* return an IST string in s which describes the current
    implementation of TIE in use */
 char s1[81] ;
 
	strcpy(s1, "TOOLPACK/1  RELEASE: 1.1  -  (TIEC).");
	chist_(s1, s, strlen(s1));
}
 
zindex_(s,t)
int *s, *t ;
 
{
 /* Find the first occurence of the string t in the line s. The
    value of the function is 0 if t can not be found in the s.
    Otherwise the value is the location of the first character
    of the match in the line. If t is null (i.e. only 'eos')
    then it matches the first character in s              */
 
   int i,j,k;
 
 /* the next line may have to be removed since it is a fudge to get
     same result as fortran */
 
  if( t[0] == EOS && s[0] != EOS) return(1);
 
  for(i=0 ; s[i] != EOS;i++) {
 
     for(j=i,k=0; t[k] != EOS && s[j] == t[k];j++,k++);
 
      if(t[k] == EOS)
         return((k == 0) ? 0:i+1); /* take care of null t */
 
       }
 return(0);
 
}
 
zinot_(v1)
int *v1 ;
 
{
 /* return the result of a 1's complement negation
    in the argument    */
 
  return(~( *v1)) ;
 
}
 
zior_(v1,v2)
int *v1, *v2 ;
 
{
 /* return a bitwise logical or through the function name */
 
 return( *v1 | *v2);
 
}
 
zitocp_( value, string, width, pad)
int *value, *string, *width, *pad;
 
{
	/* convert the integer value to an IST string in array
	   string using up to width characters (excluding EOS).
	   If the string version requires less than width characters
	   pad with the character PAD */
 
	int *ptrend, *strend;
	int length, i, size;
 
	/* use itoc to generate the IST string */
        size = *width + 1;
	length = itoc_(value, string, &size);
 
	/* ptrend points at the EOS - returned from itoc
	   strend points at the end of the string to be made up */
	ptrend = string + length;
	strend = string + *width;
 
	/* right justify */
	for (i = 0; i <= length; i++, *strend-- = *ptrend--);
	
	/* and pad */
	while (string <= strend)
	   	*string++ = *pad;
 
}
 
zlls_(v1,bits)
unsigned int *v1, *bits ;
 
{
 /* return the result of a logical left shift on v1 by bits bit
    positions. Bits shifted out of a word are lost, zeros are
    shifted in */
 
 return( *v1 << *bits);
 
}
 
zlrs_(v1,bits)
unsigned int *v1, *bits ;
 
{
 /* return the result of a logical right shift on v1 by bits bit
    positions. Bits shifted out of a word are lost, zeros are
    shifted in */
 
 return( *v1 >> *bits);
 
}
 
zlower_(ch)
int *ch ;
 
{
 /*returns the lower case version of ch if it is upper case
  or ch if it is any of character         */
 
 
 return( isupper(*ch) ? tolower( *ch): *ch);
 
}
 
zorder_(s1,s2)
int *s1, *s2;
 
{
 /* evaluate the lexical order of two IST format strings
    result of the comparision is 'less','greater'or'equals'.
    'less' implies s1 lexically precedes s2  */
 
/* rip off of strcmp white book p102 */
      if( *s1 == EOS && *s2 != EOS)return(LESS);
      if( *s2 == EOS && *s1 != EOS)return(GREATER);
 
  for(; *s1 == *s2 ; s1++,s2++)
      if( *s1 == EOS)
       return(EQUALS);
 
/* special cases */
  if(*s1 == EOS) return(LESS);
  if(*s2 == EOS) return(GREATER);
 
 return( (*s1 > *s2) ? GREATER : LESS);
 
}
 
zsbstr_(from,beg,length,to,tbeg)
int *from, *beg, *length, *to, *tbeg ;
 
{
 /* copy maximum of length characters starting at from[beg] to to
    starting at to[tbeg] */
 
 int *if1, *it, i;
 
 /* check for default parameters */
 
 if( *beg<1 || *tbeg<1)
    return;
 
 /* set if1 and it to point at heads of arrays */
 
 if1 = from + *beg -1 ;
 it = to + *tbeg -1 ;
 
 for(i=1;i<= *length ; i++)
 {
 
     *it++ = *if1;
     if( *if1 == EOS)return;
     if1++;
  }
 
}
 
ztime_(y, m, d, h, min, s, mil)
int *y, *m, *d, *h, *min, *s, *mil;
{
 
	/* Get the current time (according to the host system clock).
	   The millisecond variable may not change incrementally
	   depending on the information available from the host system */
 
 
{
	struct timeval tp;
	struct timezone tz;
	struct tm tmstr, *localtime();
 
	gettimeofday(&tp, &tz);
	tmstr = *localtime(&tp.tv_sec);
	*y = tmstr.tm_year + 1900;
	*m = tmstr.tm_mon +1;
	*d = tmstr.tm_mday;
	*h = tmstr.tm_hour;
	*min = tmstr.tm_min;
	*s = tmstr.tm_sec;
	/* 4.2 presents ...... microseconds !! */
	*mil = tp.tv_usec/1000;
	return;
}
 
}
 
ztimes_(date, time, buffer)
int *date, *time, *buffer;
{
 
	/* convert a time stamp of the form returned by ZSTAMP to an
	   IST string representation of the date and time in the form
 
	       15:36:49 13 dec 1983
 
	   The string is fixed length at 20 characters plus an EOS */
 
	int i, j, junk;
	char *ctime(), *p, temp[30];
 
	/* ctime returns a pointer to a string of the form
 
		Sun Sep 16 01:03:52 1983\n\0
 
		so we need to rearrange it a bit */
 
	p = ctime(&zstclk);
	j = 0;
	for (i=11; i<=19; i++) temp[j++] = p[i-1];
	for (i=8; i<=10; i++) temp[j++] = p[i-1];
	for (i=4; i<=7; i++) temp[j++] = p[i-1];
	for (i=21; i<=24; i++) temp[j++] = p[i-1];
	temp[j] = EOSCH;
 
	chist_(temp, buffer, strlen(temp));
	return;
 
 
}
 
zupper_(ch)
int *ch ;
 
{
 /*returns the upper case version of ch if it is lower case
  or ch if it is any of character         */
 
 
 return( islower(*ch) ? toupper(*ch) : *ch);
 
}
