      SUBROUTINE GLDRIV (IFUNC, RBUF, NBUF, CHR, LCHR)
      INTEGER IFUNC, NBUF, LCHR
      REAL    RBUF(*)
      CHARACTER*(*) CHR
C-----------------------------------------------------------------------
C PGPLOT driver for Hewlett Packard HPGL plotter(s).
C-----------------------------------------------------------------------
C Version 1.0  - 1988 March 14 - B. H. Toby
C-----------------------------------------------------------------------
C     This routine has been written specifically for the HP7475A
C     Plotter, but should support most HPGL devices, perhaps with
C     minor modifications.
C
C     If the output device is a terminal, it is assumed that the
C     output device is a plotter connected BEFORE the terminal using
C     the Y-cable (HP part #17455A), in which case the plotter is
C     ``turned on'' using a "<ESC>.(" and xon/xoff handshaking is
C     enabled using "<ESC>.I81;;17:" and "<ESC>.N;19:". If the
C     plot goes to a file, it is the user's responsibilty to
C     add control codes, if needed.
C
C     If there is more than one plot and the plot is on a terminal,
C     a prompt will be generated, allowing the page to be advanced.
C
C     The set color attributes function has been adapted for a
C     special purpose: to set the plotter speed; see OPCODE 21, below
C
C     ref. HP 7475A Interfacing and Programming Manual P/N 7475-90001
C
C  9/88 bull
c       added page eject to IFUNC 14
C-----------------------------------------------------------------------
      CHARACTER*10 MSG,GRGL00,coord1,coord2
      INTEGER LASTI, LASTJ, UNIT, IC
      INTEGER IER
      INTEGER    I0, J0, I1, J1, N1, N2
      INTEGER  I, IK1, IK2, IK3, IK4, IK5, PLOTNO
      LOGICAL ITERM, GRCHKT
      REAL X
C-----------------------------------------------------------------------
C
      GOTO( 10, 20, 30, 40, 50, 60, 70, 80, 90,100,
     1     110,120,130,140,150,160,170,180,190,200,
     2     210,220,230), IFUNC
      GOTO 900
C
C--- IFUNC = 1, Return device name.-------------------------------------
C
10    CHR = 'HPGL'
      LCHR = 4
      RETURN
C
C--- IFUNC = 2, Return physical min and max for plot device, and range
C               of color indices.---------------------------------------
C
20    RBUF(1) = 0
      RBUF(2) = 16640
      RBUF(3) = 0
      RBUF(4) = 11040
      RBUF(5) = 1
      RBUF(6) = 6
      NBUF = 6
      RETURN
C
C--- IFUNC = 3, Return device resolution. ------------------------------
C
30    RBUF(1) = 1016.0
      RBUF(2) = 1016.0
      RBUF(3) = 20
      NBUF = 3
      RETURN
C
C--- IFUNC = 4, Return misc device info. -------------------------------
C    (This device is Hardcopy, No cursor, No dashed lines, No area fill,
C    No thick lines)
C
40    CHR = 'HNNNNNNNNN'
      LCHR = 10
      RETURN
C
C--- IFUNC = 5, Return default file name. ------------------------------
C
50    CHR = 'pgplot.hpgl'
      LCHR = 11
      RETURN
C
C--- IFUNC = 6, Return default physical size of plot. ------------------
C
60    RBUF(1) = 0
      RBUF(2) = 10365
      RBUF(3) = 0
      RBUF(4) = 7962
      NBUF = 4
      RETURN
C
C--- IFUNC = 7, Return misc defaults. ----------------------------------
C
70    RBUF(1) = 10
      NBUF = 1
      RETURN
C
C--- IFUNC = 8, Select plot. -------------------------------------------
C
80    CONTINUE
      RETURN
C
C--- IFUNC = 9, Open workstation. --------------------------------------
C
90    CONTINUE
C Try to open the graphics device
      CALL GRGLUN(UNIT)
      unit=99
      OPEN (UNIT=UNIT,FILE=CHR(:LCHR),STATUS='NEW',
     &          FORM='FORMATTED', 
     &          RECL=512,IOSTAT=IER)
      IF (IER.NE.0) THEN
C        CALL ERRSNS(IK1,IK2,IK3,IK4,IK5)
        CALL GRWARN('Cannot open graphics device ')
c     CALL GRWARN('Cannot open graphics device '//CHR(1:LCHR))
        IF (IK2.NE.0 .AND. IK2.NE.1) CALL GRGMSG(IK2)
        IF (IK5.NE.0 .AND. IK5.NE.1) CALL GRGMSG(IK5)
        RBUF(2) = 0
        RETURN
      ENDIF
C is the output device a terminal?
      INQUIRE (UNIT=UNIT, NAME=CHR)
      I = LEN(CHR)
      DO WHILE (CHR(I:I).EQ.' ')
          I = I-1
      END DO
      LCHR = I
      ITERM = .FALSE.
      CALL GRTTER(CHR(1:I),GRCHKT)
      IF (GRCHKT) ITERM = .TRUE.
      RBUF(1) = UNIT
      RBUF(2) = 1
      NBUF = 2
      LASTI = -1
      LASTJ = -1
      IF (ITERM) THEN
C this turns on the plotter
        WRITE (UNIT, '(A)') CHAR(27)//'.('
C this sets up Xon/Xoff protocol
        WRITE (UNIT, '(A)') CHAR(27)//'.I81;;17:'
        WRITE (UNIT, '(A)') CHAR(27)//'.N;19:'
      ENDIF
      WRITE (UNIT, '(A)') 'IN;'
      PLOTNO = 1
      RETURN
C
C--- IFUNC=10, Close workstation. --------------------------------------
C
  100 CONTINUE
      WRITE (UNIT, '(A)') 'SP;'
      IF (ITERM) THEN
C this turns off the plotter
        WRITE (UNIT, '(A)') CHAR(27)//'.)'
        CLOSE (UNIT)
      ENDIF
      CALL GRFLUN(UNIT)
      RETURN
C
C--- IFUNC=11, Begin picture. ------------------------------------------
C
  110 CONTINUE
C if the plot is interactive, and we are starting a second or third (...)
C picture, allow a chance to change the paper.
      IF (ITERM .AND. PLOTNO .gt. 1) THEN
C turn off the plotter
        WRITE (UNIT, '(A)') CHAR(27)//'.)'
C send a prompt
        IER=GRGCOM(MSG, CHAR(7)//
     1       'Reload paper, then press <RETURN>: ', I)
C turn on the plotter
        WRITE (UNIT, '(A)') CHAR(27)//'.('
      ENDIF
      PLOTNO = PLOTNO + 1
      WRITE (UNIT, '(A)') 'PA;'
      RETURN
C
C--- IFUNC=12, Draw line. ----------------------------------------------
C
  120 CONTINUE
      I0 = NINT(RBUF(1))
      J0 = NINT(RBUF(2))
      I1 = NINT(RBUF(3))
      J1 = NINT(RBUF(4))
      IF ( (I0.NE.LASTI) .OR. (J0.NE.LASTJ) ) THEN
C -- move with pen up
C     -- Encode the coordinates into the command string
      coord1 = GRGL00(I0,N1)
      coord2 = GRGL00(J0,N2)
C     -- Write the command string to the plot file
      WRITE (UNIT, '(A)') 'PU '//coord1(n1:)//','//coord2(n2:)//';'
      ENDIF
C -- move with pen down
C     -- Encode the coordinates into the command string
      coord1 = GRGL00(I1,N1)
      coord2 = GRGL00(J1,N2)
C     -- Write the command string to the plot file
      WRITE (UNIT, '(A)') 'PD '//coord1(n1:)//','//coord2(n2:)//';'
      LASTI = I1
      LASTJ = J1
      RETURN
C
C--- IFUNC=13, Draw dot. -----------------------------------------------
C
  130 CONTINUE
      I0 = NINT(RBUF(1))
      J0 = NINT(RBUF(2))
      IF ((I0.NE.LASTI) .OR. (J0.NE.LASTJ)) THEN
C -- move with pen up
C     -- Encode the coordinates into the command string
        coord1 = GRGL00(I0,N1)
        coord2 = GRGL00(J0,N2)
C     -- Write the command string to the plot file
        WRITE (UNIT, '(A)') 
     &        'PU '//coord1(n1:)//','//coord2(n2:)//'; PD;'
      ELSE
C -- no need to move, just lower the pen
        WRITE (UNIT, '(A)') 'PD;'
      ENDIF
      LASTI = I0
      LASTJ = J0
      RETURN
C
C--- IFUNC=14, End picture. --------------------------------------------
C
  140 CONTINUE
C  move the pen off the page
      WRITE (UNIT, '(A)') 'PU 32000,32000;PG;'
      RETURN
C
C--- IFUNC=15, Select color index. -------------------------------------
C
  150 CONTINUE
      IC = NINT(RBUF(1))
      IF (IC.LT.1) IC = 1
      IF (IC.GT.6) IC = 6
      WRITE (UNIT,'(A,i2,A)') 'SP',IC,';'
      RETURN
C
C--- IFUNC=16, Flush buffer. -------------------------------------------
C    (Null operation: buffering is not implemented.)
C
160   CONTINUE
      RETURN
C
C--- IFUNC=17, Read cursor. --------------------------------------------
C    (Not implemented: should not be called.)
C
170   GOTO 900
C
C--- IFUNC=18, Erase alpha screen. -------------------------------------
C    (Null operation: there is no alpha screen.)
C
180   CONTINUE
      RETURN
C
C--- IFUNC=19, Set line style. -----------------------------------------
C    (Not implemented: should not be called.)
C
190   GOTO 900
C
C--- IFUNC=20, Polygon fill. -------------------------------------------
C    (Not implemented: should not be called.)
C
200   GOTO 900
C
C--- IFUNC=21, Set color representation. -------------------------------
C    This is used for a special purpose: to control the pen speed.
C     The default speed is 38.1 cm/s and the acceleration is 2 G.
C     The allowed pen speed may be J*3.81 where J=1,2...10. If the
C     pen speed is set non-default, the acceleration is lowered to
C     0.5 G.
C     The pen speed is set to the allowed setting nearest X*38.1,
C     where X=MAX(R,G,B) and R,G,B are the color components (0.0
C     to 1.0).
C     If X is 1.0, the speed and acceleration are set to the defaults.
C
210   CONTINUE
      X = MAX(RBUF(2),RBUF(3),RBUF(4))
      IF (X .ge. 1.0) then
        WRITE (UNIT,'(A)') 'VS;'
      ELSE
        WRITE (UNIT,'(A,f5.2,A)') 'VS',X*38.1,';'
      ENDIF
      RETURN
C
C--- IFUNC=22, Set line width. -----------------------------------------
C    (Not implemented: should not be called.)
C
220   GOTO 900
C
C--- IFUNC=23, Escape. -------------------------------------------------
C
230   CONTINUE
      WRITE (UNIT, '(A)') CHR(:LCHR)
      LASTI = -1
      RETURN
C-----------------------------------------------------------------------
C Error: unimplemented function.
C
  900 WRITE (MSG,'(I10)') IFUNC
      CALL GRWARN('Unimplemented function in HPGL device driver: '//MSG)
      NBUF = -1
      RETURN
C-----------------------------------------------------------------------
      END
     
     
     
     
     
     
     
     
     
      CHARACTER*10 FUNCTION GRGL00(IARG,IP)
C-----------------------------------------------------------------------
C GRPCKG (internal routine, HPGL):
C       This subroutine translates the argument IARG into a character
C     string and then returns the position of the first non-blank
C     character in the string
C Arguments:    IARG
C               IP (returned)
C-----------------------------------------------------------------------
      INTEGER IARG, IP
C
      GRGL00 = ' '
      ip = 10
      WRITE(GRGL00,'(I10)') IARG
      do ip=1,10
        if (GRGL00(ip:ip) .ne. ' ') return
      enddo
      END
