/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * yours.c ---	This file is the place to add any additional primitives
 *		you might wish.
 *
 * (duz 24Feb94)
 *
 *
 * To make a new primitive Forth word, you have to write a C function of
 * type
 *
 *	static void name_(void)
 *
 * Use the preprocessor macro
 *
 *	Code (name)
 *
 * to provide the prototype with the underscore appended to the
 * name. The underscore helps to avoid name clashes with names and
 * keywords of the C language.
 *
 * If you want to call such a primitive from C-source you must of
 * course append the underscore to the name in the function call
 * yourself. If you want to call it from another input file then you
 * must leave out the `static' keyword in the function definition,
 * which is what the alternative macro
 *
 *	code (name)
 *
 * does. Both are of course nothing but shortcuts to ease input of all
 * those words.
 *
 * Having defined a primitive you must add it to the forth dictionary
 * in order to make it visible to Forth.  At the end of each input
 * file defining forth primitives you'll find a table declared with
 * the macro
 *
 *	LISTWORDS (wordset_name) =
 *	{
 *	  ...
 *	};
 *
 * This declares a vector of some type and shows how to continue with
 * the initialization of the vector.  Each vector element registers a
 * forth word for loading into the dictionary at startup. In pfe the
 * dictionary is not an initialized C structure but it is built from
 * such structures -- like the one described here -- at startup.
 *
 * To enter words into this table there are several macros, all for
 * brevity named with two uppercase letters. Using such a macro adds
 * one more element to the list of initializers following the
 * LISTWORDS declaration. Besides primitives you can enter variables
 * and constants to the dictionary this way.
 *
 *	CO (NAME, c-name)	a primitive, not immediate
 *	CI (NAME, c-name)	an immediate primitive
 *	CS (NAME, c-name)	a primitive with separate execution
 *				and compilation semantics, see examples
 *				in core.c (if, case etc.) and macros in
 *				compiler.h and -- good luck :-)
 *	OV (NAME)		a normal variable
 *	OC (NAME, value)	a normal constant
 *	OL (NAME, value)	a normal value
 *	IV (NAME)		an immediate variable
 *	IC (NAME, value)	an immediate constant
 *	IL (NAME, value)	an immediate value
 */

#include "forth.h"
#include "support.h"

Code (user_added_primitive)
{
  outs ("\nThis is a sample primitive."
	" See src/yours.c for it's definition.\n");
}

LISTWORDS (your) =
{
  CO ("USER-ADDED-PRIMITIVE", user_added_primitive),
};
COUNTWORDS (your, "Your kernel extensions");
