/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * support.h ---	declare types and prototypes for support.c
 * (duz 09Jul93)
 */

#ifndef __SUPPORT_H
#define __SUPPORT_H

#ifndef __SYSDEP_H
#include "config.h"
#endif

#ifndef __FORTH_H
#include "forth.h"
#endif

#ifndef FILE
#include <stdio.h>
#endif


/* miscellaneous =========================================================== */

void millisec (int ms);

code (rot);
code (invert);
code (fetch);
code (pocket);
code (update);
code (save_buffers);
code (close_all_files);
code (decimal);
code (key_question);

/* strings, memory ========================================================= */

Cell aligned (Cell n);
Cell dfaligned (Cell n);
void *getmem (size_t size);
void *xalloc (size_t size);

void strpush (const char *s);
char *pocket (void);
int dash_trailing (char *s, int n);
char *strlwr (char *str);
char *strupr (char *str);
void lower (char *p, int n);
void upper (char *p, int n);
char *store_c_string (const char *src, int n, char *dst, int max);
char *store_filename (const char *src, int n, char *dst, int max);
char *expand_filename (const char *nm, const char *path,
		       const char *ext, char *fn);
char *search (const char *p1, int u1, const char *p2, int u2);
int match (const char *pattern, const char *string);

/* floored divide and number i/o conversion ================================ */

udiv_t udiv (uCell num, uCell denom);
fdiv_t fdiv (Cell num, Cell denom);
uCell u_d_div (udCell *ud, uCell denom);
void u_d_mul (udCell *ud, uCell w, uCell c);

int dig2num (Byte c, uCell *n, uCell base);
char num2dig (uCell n);
void hold (char c);
const char *to_number (const char *p, uCell *n, udCell *d, uCell base);
int number_question (const char *p, uCell n, dCell *d);

char *str_ud_dot_r (udCell ud, char *p, int w, int base);
char *str_d_dot_r (dCell d, char *p, int w, int base);
char *str_dot (Cell n, char *p, int base);

code (less_number_sign);
code (number_sign_s);
code (number_sign_greater);

code (s_to_d);			/* in core.c */
code (d_dot_r);			/* in double.c */
code (d_dot);			/* in double.c */
code (dot_r);			/* in core.c */
code (dot);			/* in core.c */

void d_dot_r (dCell d, int w);
void d_dot (dCell d);
void dot_r (Cell n, int w);
void dot (Cell n);

/* console i/o ============================================================= */

code (standard_io);

void outc (char c);		/* these work on C-strings */
void outs (const char *s);	/* but adjust the OUT variable */
int outf (const char *s, ...);
void type (const char *s, Cell n); /* this works with a Forth-string */
void type_on_line (const char *s, Cell n);

code (type);			/* in core.c */
code (space);			/* in core.c */
code (cr);			/* in core.c */
code (backspace);		/* in misc.c */
code (bell);			/* in misc.c */

void spaces (int n);
code (spaces);			/* in core.c */

void tab (int n);
void dot_line (File *fid, Cell blk, Cell line);
int expect (char *p, Cell n);
int aCcept (char *p, int n);
int question_stop (void);
int question_cr (void);
code (start_question_cr);	/* in misc.c */

/* files =================================================================== */

long fsize (FILE *f);
long size (const char *fn);
long copy (const char *dst, const char *src, long limit);
int move (const char *src, const char *dst);
int resize (const char *fn, long size);

int systemf (const char *s, ...);

void file_errorz (const char *fn);
void file_error (const char *fn, int len);
int file_access (const char *fn, int len);
File *create_file (const char *p, int n, int mode);
File *open_file (const char *p, int n, int mode);
int close_file (File *f);
int reposition_file (File *f, long pos);
int read_file (void *p, uCell *n, File *f);
int write_file (void *p, uCell n, File *f);
int resize_file (File *f, long size);
int read_line (char *p, uCell *u, File *f, Cell *ior);

/* source input ============================================================ */

code (query);
int next_line (void);

File *open_block_file (const char *name, int len);
int use_block_file (const char *name, int len);
void read_write (File *f, char *p, uCell n, int readflag);
char *buffer (File *fid, uCell n, int *reload);
char *block (File *fid, uCell n);
void update (File *fid);
void empty_buffers (File *fid);
void save_buffers (File *fid);
void list (File *fid, int n);

int refill (void);

void *save_input (void *p);
void *restore_input (void *p);
void source (char **p, int *n);
void skip_delimiter (char del);
int parse (char del, char **p, uCell *l);
char *word (char del);

/* dictionary and words lists ============================================== */

Wordl *word_list (void);
void forget (char *above);

int wl_hash (const char *s, int l);
char **topmost (Wordl *w);
char *latest (void);

char *search_wordlist (const char *nm, int l, /*const*/ Wordl *w);
char *find (const char *nm, int l);
char *tick (Xt *xt);

code (align);			/* in core.c */
code (aligned);

char *alloc_string (const char *s, int l);
char *alloc_parsed_string (char del);
char *alloc_word (char del);
void header (pCode cfa, char flags);

char **name_to_link (const char *p);
char *link_to_name (char **l);
Xt link_from (char **lnk);
char **to_link (Xt xt);
#define TO_BODY(C)	((Cell *)((Xt)(C) + 1))
#define BODY_FROM(P)	((Xt)((Cell *)(P) - 1))
char *to_name (Xt xt);
Xt name_from (const char *p);
Xt runtime (void);
void dot_name (const char *nfa);

void wild_words (const Wordl *wl, const char *pattern, const char *category);
int complete_dictionary (char *in, char *out, int display);

code (only);
code (also);
code (definitions);
code (default_order);
code (reset_order);

uCell pfe_version_code (void);
void preload_dictionary (void);
long save_dictionary (Dict *d1, Dict *d2, const char *fn);
int reload_dictionary (const char *fn, Dict *dict);

/* inner and outer interpreter ============================================= */

void run_forth (Xt xt);
void call_forth (Xt xt);

void normal_execute (Xt xt);
extern void (*execute) (Xt xt);
void debug_off (void);

code (interpret);
void evaluate (char *p, int n);
void load (File *fid, uCell blk);
void load_file (char *fn, int cnt, int blk);
void thru (File *fid, int lo, int hi);
void include_file (File *f);
void included (const char *fn, int n);

/* ABORT and exception handling ============================================ */

extern jmp_buf abort_dest;
extern jmp_buf quit_dest;
void do_abort (void);

int cAtch (Xt xt);		/* catch is a keyword in C++ */
void tHrow (int id, ...);	/* accepts -2 addr cnt */
void abortq (const char *fmt, ...); /* accepts printf()-like parameters */

code (question_comp);		/* in misc.c */
code (question_exec);
code (question_pairs);
code (store_csp);
code (question_csp);
code (question_loading);
code (question_stack);
void question_pairs (Cell n);
void question_file_open (File *f);

void initialize_system (void);

/* signal stuff ============================================================ */

void install_signal_handlers (void);
void swap_signals (void);
Xt forth_signal (int sig, Xt xt);
void load_signals (Wordl *wid);

#endif
