/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * forth.h ---	gathers some common includes in a useful order
 *		and global variables and types for main.c
 * (duz 08Feb93)
 */

#ifndef __FORTH_H
#define __FORTH_H

#ifndef __CONFIG_H
#include "config.h"
#endif

#ifndef __VIRTUAL_H
#include "virtual.h"
#endif

#ifndef __OPTIONS_H
#include "options.h"
#endif

#ifndef __CONST_H
#include "const.h"
#endif

#ifndef __TYPES_H
#include "types.h"
#endif

#ifndef __MACROS_H
#include "macros.h"
#endif

#ifndef __PRELOAD_H
#include "preload.h"
#endif


/* variables declared globally */

extern struct memory
	membot,			/* start of each area */
	memtop;			/* end of each area */

extern struct memsiz
	memsiz;			/* size of each area in cells */

extern char host_system[];
				/* exported command line options: */
extern int _argc;		/* all options */
extern char **_argv;
extern int app_argc;		/* those past the file name to include */
extern char **app_argv;
extern int exitcode;

extern struct sysvar sys;	/* all other FORTH variables */

extern struct options		/* this aggregate communicates command line */
{				/* options to the rest of the program */
	unsigned caps_on:1,	/* exchange lower and upper case chars */
		lower_case_on:1,/* make lower case words find upper case */
		lower_case_fn:1,/* convert file names to lower case? */
		float_input:1,	/* disables floating point input when false */
		license:1,	/* show license string at startup */
		warranty:1,	/* show warranty string at startup */
		quiet:1,	/* no messages */
		verbose:1,	/* more messages */
		canonical:1,	/* running in canonical mode */
		stdio:1,	/* standard input isn't-tty: work as filter */
		debug:1;	/* enable a few more outputs */
	int	cols, rows;	/* size of screen */
	uCell	total_size;
	uCell	stack_size;
	uCell	flt_stack_size;
	uCell	ret_stack_size;
	uCell	max_files;
	uCell	pockets;
	char *	save_dict;	/* dictionary image to build or NULL */
	char *	load_dict;	/* dictionary image to load or NULL */
	char *	pferc_file;	/* normally "~/.pferc" */
	char *	block_file;	/* block file to use initially */
	char *	include_file;	/* file to include initially */
	char *	incpaths;
	char *	incext;
	char *	blkpaths;
	char *	blkext;
	char *	editor;		/* preferred ASCII text file editor */
}
option;

extern char	version_string [],
		copyright_string [],
		license_string [],
		warranty_string [],
		compile_date [],
		compile_time [];

code (dot_memory);

void fatal (const char *msg, ...);
Xt forth_signal (int sig, Xt xt);

#endif
