/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * forth-83.c ---     Compatiblity with the FORTH-83 standard.
 *
 * All FORTH-83-Standard words are included here that are not in the
 * dpANS already.
 * Though most of the "uncontrolled reference words" are omitted.
 *
 * (duz 08Aug93)
 */

#include "forth.h"
#include "support.h"
#include "compiler.h"

#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "missing.h"

/************************************************************************/
/* required word set                                                    */
/************************************************************************/

Code (two_plus)			/* 2+ */
{
  *sp += 2;
}

Code (two_minus)		/* 2- */
{
  *sp -= 2;
}

Code (compile)			/* COMPILE */
{
  compile1 ();
  bracket_compile_ ();
}
code (postpone_execution);
COMPILES (compile, postpone_execution,
	  SKIPS_CELL, DEFAULT_STYLE);

void
vocabulary_runtime (void)
{
  CONTEXT[0] = (Wordl *) PFA;
}

Code (vocabulary)		/* VOCABULARY */
{
  header (vocabulary_runtime, 0);
  word_list ();
}

/************************************************************************/
/* system extension word set                                            */
/************************************************************************/

code (if_execution);		/* ?BRANCH */
code (else_execution);		/* BRANCH */

code (backward_mark)		/* <MARK */
{
  question_comp_ ();
  *--sp = (Cell) DP;
}

code (backward_resolve)		/* <RESOLVE */
{
  question_comp_ ();
#if 0
  COMMA ((char *) *sp++ - (char *) DP);
#else
  COMMA (*sp++);
#endif
}

code (forward_mark)		/* MARK> */
{
  backward_mark_ ();
  INC (DP, Cell);
}

code (forward_resolve)		/* RESOLVE> */
{
  question_comp_ ();
#if 0
  *(Cell *) *sp = (char *) DP - (char *) *sp;
  sp++;
#else
  *(Byte **) *sp++ = DP;
#endif
}

/************************************************************************/
/* Controlled reference words                                           */
/************************************************************************/

Code (next_block)		/* --> */
{
  question_loading_ ();
  refill ();
}

Code (k)			/* K (3rd loop index) */
{
  *--sp = RP[6] + RP[7];
}

Code (octal)			/* OCTAL */
{
  BASE = 8;
}

Code (s_p_fetch)		/* SP@ */
{
  void *p = sp;

  *--sp = (Cell) p;
}

/************************************************************************/
/* Some uncontrolled reference words                                    */
/************************************************************************/

Code (store_bits)		/* !BITS */
{
  uCell mask = sp[0];
  uCell *ptr = (uCell *) sp[1];
  uCell bits = sp[2];

  sp += 3;
  *ptr = (*ptr & ~mask) | (bits & mask);
}

Code (power)			/* ** (raise second to top power) */
{
  Cell i = *sp++;
  Cell n = *sp, m;

  for (m = 1; --i >= 0; m *= n);
  *sp = m;
}

Code (byte_swap)		/* >< */
{
  Byte *p = (Byte *) sp
#if HIGHBYTE_FIRST
  + (sizeof (Cell) - 2)
#endif
  , h;

  h = p[1];
  p[1] = p[0];
  p[0] = h;
}

Code (byte_swap_move)		/* >MOVE< */
{
  Byte *p = (Byte *) sp[2];
  Byte *q = (Byte *) sp[1];
  Cell n = sp[0];

  sp += 3;
  for (; n > 0; n -= 2)
    {
      q[1] = p[0];
      q[0] = p[1];
      p += 2;
      q += 2;
    }
}

Code (fetch_bits)		/* @BITS */
{
  sp[1] = *(Cell *) sp[1] & sp[0];
  sp++;
}

/************************************************************************/
/* Search order specification and control                               */
/************************************************************************/

Code (seal)			/* SEAL */
{
  Wordl **w;

  for (w = CONTEXT; w <= &ONLY; w++)
    if (*w == ONLY)
      w = NULL;
}

/************************************************************************/
/* Definition field address conversion operators                        */
/************************************************************************/

Code (to_name)			/* >NAME */
{
  *sp = (Cell) to_name ((Xt) *sp);
}

Code (to_link)			/* >LINK */
{
  *sp = (Cell) to_link ((Xt) *sp);
}

Code (body_from)		/* BODY> */
{
  *sp = (Cell) BODY_FROM (*sp);
}

Code (name_from)		/* NAME> */
{
  *sp = (Cell) name_from ((char *) *sp);
}

Code (link_from)		/* LINK> */
{
  *sp = (Cell) link_from ((char **) *sp);
}

Code (l_to_name)		/* L>NAME */
{
  *sp = (Cell) link_to_name ((char **) *sp);
}

Code (n_to_link)		/* N>LINK */
{
  *sp = (Cell) name_to_link ((char *) *sp);
}
/* *INDENT-OFF* */
LISTWORDS (forth_83) =
{
  /* FORTH-83 required word set */
  CO ("2+",		two_plus),
  CO ("2-",		two_minus),
  CO ("?TERMINAL",	key_question),
  CS ("COMPILE",	compile),
  CO ("NOT",		invert),
  CO ("VOCABULARY",	vocabulary),
  /* FORTH-83 system extension word set */
  CO ("<MARK",		backward_mark),
  CO ("<RESOLVE",	backward_resolve),
  CO ("MARK>",		forward_mark),
  CO ("RESOLVE>",	forward_resolve),
  CO ("BRANCH",		else_execution),
  CO ("?BRANCH",	if_execution),
  DV ("CONTEXT",	context),
  DV ("CURRENT",	current),
  /* FORTH-83 controlled reference words */
  CI ("-->",		next_block),
  CO ("INTERPRET",	interpret),
  CO ("K",		k),
  CO ("OCTAL",		octal),
  CO ("SP@",		s_p_fetch),
  /* FORTH-83 uncontrolled reference words */
  CO ("!BITS",		store_bits),
  CO ("@BITS",		fetch_bits),
  CO ("><",		byte_swap),
  CO (">MOVE<",		byte_swap_move),
  CO ("**",		power),
  DV ("DPL",		dpl),
  /* FORTH-83 Search order specification and control */
  CO ("SEAL",		seal),
  /* FORTH-83 definition field address conversion operators */
  CO ("BODY>",		body_from),
  CO (">LINK",		to_link),
  CO ("LINK>",		link_from),
  CO (">NAME",		to_name),
  CO ("NAME>",		name_from),
  CO ("L>NAME",		l_to_name),
  CO ("N>LINK",		n_to_link)
};
COUNTWORDS (forth_83, "FORTH-83 compatibility");
