/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * compiler.h ---	lists of declarations reflecting internal structures
 *			of pfe mainly for decompiler (SEE) and debugger.
 * (duz 23Aug93)
 */

#ifndef __COMPILER_H
#define __COMPILER_H

typedef struct Decomp Decomp;	/* informations for the decompiler */
typedef struct Semant Semant;	/* pointer set for state smart words */
typedef struct Seman2 Seman2;	/* dito for even smarter words like TO */

enum				/* encodings for what information */
{				/* follows the compiled word inline */
  SKIPS_NOTHING,
  SKIPS_OFFSET,
  SKIPS_CELL,
  SKIPS_DCELL,
  SKIPS_FLOAT,
  SKIPS_STRING,
  SKIPS_2STRINGS
};

typedef unsigned short ushrt;

struct Decomp			/* informations for the decompiler */
{
  unsigned skips:3;		/* this xt skips this many cells of data */
  unsigned space:3;		/* additional spaces past the word */
  unsigned cr_bef:1;		/* carriage return before printing */
  signed ind_bef:4;		/* changed indentation before print */
  unsigned cr_aft:1;		/* carriage return after print */
  signed ind_aft:4;		/* changed indentation after print */
};

struct Semant			/* for words with different compilation */
{				/* and execution semantics: */
  long magic;			/* mark begin of structure */
  Decomp decomp;		/* decompiler aid */
  char *name;			/* compiled by */
  pCode comp;			/* compilation/interpretation semantics */
  pCode exec[1];		/* execution semantics */
};

struct Seman2			/* for words with different compilation */
{				/* and two different execution semantics: */
  long magic;			/* mark begin of structure */
  Decomp decomp;		/* decompiler aid */
  char *name;			/* compiled by */
  pCode comp;			/* compilation/interpretation semantics */
  pCode exec[2];		/* two different execution semantics */
};				/* for cases like TO (value/local variable) */

#define COMPILES(C,E,S,STYLE)			\
Semant APPEND (C,_semantics) =			\
{						\
  SEMANT_MAGIC,					\
  { S, STYLE },					\
  NULL,						\
  APPEND (C,_),					\
  { APPEND (E,_) }				\
}

#define COMPILES2(C,E1,E2,S,STYLE)		\
Seman2 APPEND (C,_semantics) =			\
{						\
  SEMANT_MAGIC,					\
  { S, STYLE },					\
  NULL,						\
  APPEND (C,_),					\
  { APPEND (E1,_), APPEND (E2,_) }		\
}

/* compile execution semantics from within C-code: */
#define COMPILE1(X)		COMMA (&APPEND(X,_semantics).exec [0])
#define COMPILE2(X)		COMMA (&APPEND(X,_semantics).exec [1])

void compile1 (void);		/* compile execution semantics */
void compile2 (void);		/* at system runtime */

Head *make_head (const char *name, int count, char **nfa, Wordl * wid);
Semant *to_semant (Xt xt);
char category (pCode p);
void decompile (char *nfa, Xt xt);

code (noop);
code (ahead);

code (backward_mark);		/* FORTH-83 style system extension words */
code (backward_resolve);
code (forward_mark);
code (forward_resolve);
code (bracket_compile);

code (smudge);
code (unsmudge);

/* Local variables: */

int find_local (char *nm, int l);
int compile_local (char *name, int len);

/* Runtimes to identify words by them: */

code (to_execution);
code (plus_to_execution);
code (locals_bar_execution);
code (locals_exit_execution);
code (local_execution);
code (to_local_execution);
code (plus_to_local_execution);

code (semicolon_execution);
code (literal_execution);
code (two_literal_execution);
code (f_literal_execution);

void create_runtime (void);
void constant_runtime (void);
void value_runtime (void);
void two_constant_runtime (void);
void f_constant_runtime (void);
void f_variable_runtime (void);
void colon_runtime (void);
void debug_colon_runtime (void);
void sysvar_runtime (void);
void sysconst_runtime (void);
void dictvar_runtime (void);
void dictconst_runtime (void);

void only_runtime (void);
void vocabulary_runtime (void);
void does_defined_runtime (void);
void debug_does_defined_runtime (void);
void marker_runtime (void);

extern Semant literal_semantics;
extern Semant two_literal_semantics;
extern Seman2 f_literal_semantics;
extern Seman2 semicolon_semantics;

#endif
