/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * check_c.c --- Determine some C-compiler properties.
 * (duz 24Apr94)
 */

#include <stdio.h>
#include <string.h>
#include <signal.h>

#define OFFSET(X,C)	(int)((char *)&(X.C) - (char *)&(X))
#define CELLSIZE	(sizeof (void *))

void sig_hdl (int sig) {}

int
main ()
{
  union
    {
      char c[sizeof (long)];
      int i;
      long l;
    }
  t;
  struct
    {
      char c;
      int i;
    }
  ti;
  struct
    {
      char c;
      long l;
    }
  tl;
  struct
    {
      char c;
      float f;
    }
  tf;
  struct
    {
      char c;
      double d;
    }
  td;
  int cellalign, sfloatalign, dfloatalign;

  memset (t.c, 0, sizeof t.c);
  /*
   * determine types for CELL and HALFCELL:
   */
  if (sizeof (int) == CELLSIZE)
    {
      t.i = 1;
      cellalign = OFFSET (ti, i);
      puts ("#define CELL_TYPE int");
      if (sizeof (short) == sizeof (int) / 2)
	  puts ("#define HALF_CELL_TYPE short");

      else
	puts ("#define HALF_CELL_TYPE char");
    }
  else if (sizeof (long) == CELLSIZE)
    {
      t.l = 1;
      cellalign = OFFSET (tl, l);
      puts ("#define CELL_TYPE long");
      if (sizeof (int) == sizeof (long) / 2)
	  puts ("#define HALF_CELL_TYPE int");
      else if (sizeof (short) == sizeof (long) / 2)
	  puts ("#define HALF_CELL_TYPE short");

      else
	puts ("#define HALF_CELL_TYPE char");
    }
  else
    puts ("#error \"could not determine type for Cell\"");

  /*
   * Determine endianess:
   */
  if (t.c[0] == 1)
    puts ("#define HIGHBYTE_FIRST 0");
  else
    puts ("#define HIGHBYTE_FIRST 1");

  /*
   * Determine alignment restrictions:
   */
  printf ("#define CELLSIZE %d\n", (int)CELLSIZE);
  printf ("#define SFLOATSIZE %d\n", (int)sizeof (float));
  printf ("#define DFLOATSIZE %d\n", (int)sizeof (double));

  sfloatalign = OFFSET (tf, f);
  dfloatalign = OFFSET (td, d);

  if (cellalign < CELLSIZE)
    cellalign = CELLSIZE;
  if (sfloatalign < cellalign)
    sfloatalign = cellalign;
  if (dfloatalign < sfloatalign)
    dfloatalign = sfloatalign;

  printf ("#define CELL_ALIGN %d\n", cellalign);
  printf ("#define SFLOAT_ALIGN %d\n", sfloatalign);
  printf ("#define DFLOAT_ALIGN %d\n", dfloatalign);

  /*
   * Determine if signals must be reinstalled:
   */
  signal (SIGTERM, sig_hdl);
  raise (SIGTERM);
  if (signal (SIGTERM, SIG_DFL) == sig_hdl)
    puts ("#define KEEPS_SIGNALS 1");

  return 0;
}
