CLASS ARRAY [ T]

inherit

   ANY
	redefine copy, is_equal
	end

creation

   make

feature {ANY}

   lower: INTEGER
         -- Minimum index
   upper: INTEGER
         -- Maximum index
   count: INTEGER
         -- Number of available indecies

   all_cleared: BOOLEAN
         -- Are all items set to default values?

   clear_all is
         -- Reset all items to default values
      do
      end -- clear_all


   make ( minindex, maxindex: INTEGER) is
         -- Allocate array; set interval to `minindex' - `maxindex'
         -- (empty if `minindex' > `maxindex')
       do
           resize ( minindex, maxindex)
       ensure
           minindex > maxindex implies count = 0
           minindex <= maxindex implies count = maxindex - minindex + 1
       end -- make

   is_equal ( other: ARRAY [ T]): BOOLEAN is
            -- Test if Current and `other' are
            -- elementwise equal. If `T' is of
            -- reference type, simple reference
            -- equality is used.
       local
          index, other_index: INTEGER
       do
          if
             other.count = count
          then
             Result := True
             from
                index := lower
                other_index := other.lower
             until
                index > upper
             or
                Result = False
             loop
                Result := item ( index).is_equal ( other.item(other_index))
 
                index := index + 1
                other_index := other_index + 1
             end
          end
       ensure then
          other.count /= count implies Result = False
       end -- is_equal


   copy ( other: ARRAY [ T]) is
            -- Copy `other' elementwise onto Current.
            -- If `T' is of reference type, only the
            -- references will be copied.
       do
       end


   insert ( element: T; index: INTEGER) is
            -- Insert `element' after position `index'.

       require
           inside_bounds: lower - 1 <= index and then index < upper
            -- Note: Insertion is AFTER `index'!
            -- Element at position `upper' will be lost!
       do
       end


   item ( index: INTEGER): T is
            -- Item at position `index'.
       require
           inside_bounds: lower <= index and then index <= upper

       do
          Result := get_element ( space.space, index - lower)

		ensure
			Result /= Void
       end


   put ( element: T; index: INTEGER) is
            -- Put `element' at position `index'.
       require
           inside_bounds: lower <= index and then index <= upper

       do
          set_element ( space.space, index - lower, element)
       end


   remove ( index: INTEGER) is
         -- Remove element at position `index'.
         -- Elements after `index' will move
         -- one position left ( =towards lower indices).
       require
           inside_bounds: lower <= index and then index <= upper
       do
       end

   resize ( minindex, maxindex: INTEGER) is
        -- Rearrange array so that it can accomodate indicies down to `minindex'
        -- and up to `maxindex'.  Preserves current array contents
      do

         if
            (maxindex - minindex + 1) > count
         then
            if
               space = Void
            then
               !!space.allocate(1)
            end

              space.expand ( (maxindex - minindex + 1) * (Pointer_bits / 8))

            lower := minindex
            upper := maxindex
		  count := (maxindex - minindex + 1) + count
         end
      ensure
         lower <= minindex
         maxindex <= upper
      end -- resize


feature {NONE}

   space: CORE
         -- where array is stored

   get_element ( area: POINTER; index: INTEGER): T is
         -- answer with value at position `index'
      external "C"
      alias "_ert_array_item"
      end -- get_element

   set_element ( area: POINTER; index: INTEGER; data: T) is
         -- set value at position `index' to `data'
      external "C"
      alias "_ert_array_put"
      end -- set_element

end -- class ARRAY [ T]

