deferred class IN_STREAM

feature


   lastchar: CHARACTER is
         -- last character read from `Current' input stream by readchar
      deferred
      end -- lastchar


   lastint: INTEGER is
         -- last integer read from `Current' input stream by readint
      deferred
      end -- lastint


   lastreal: REAL is
         -- last real read from `Current' input stream by readreal
      deferred
      end -- lastreal


   laststring: STRING is
         -- last string read from `Current' input stream by readstream
         -- or readline
      deferred
      end -- laststring


   readchar is
         -- assign next character on `Current' input stream to lastchar
      deferred
      end -- readchar


   readint is
         -- assign next integer on `Current' input stream to lastint 
      deferred
      end -- readint


   readreal is
         -- assign next real on `Current' input stream to lastreal
      deferred
      end -- readreal


   readline is
         -- Read a string until a new line or an end of file is encountered
         -- Make result available in `laststring'
         -- New line will be consumed but not part of `laststring'
      deferred
      end -- readline


   readstream ( i: INTEGER) is
         -- assign next string of `i' characters on 
         -- `Current' input stream to laststring
      deferred
      end -- readstream


   next_line is
         -- move to next input line
      deferred
      end  -- next_line


end -- class IN_STREAM
