/*------------------------------------------------------------------*/
/* Machine and/or OS dependent definitions                          */
/*------------------------------------------------------------------*/

typedef unsigned short int  UINT16;     /* Must be at least 16 Bits */
typedef short int           INT16;      /* Must be at least 16 Bits */
typedef long int            INT32;      /* Must be at least 32 Bits */

/*------------------------------------------------------------------*/
/* WARNING:                                                         */
/*                                                                  */
/* Do not modify any of the remaining lines in this file. If you    */
/* don't follow this advice your Eiffel/S system may not work pro-  */
/* perly any more!                                                  */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Eiffel/S -> C types                                              */
/*------------------------------------------------------------------*/

typedef INT32           INTEGER;
typedef unsigned char   CHARACTER;
typedef unsigned char   BOOLEAN;
typedef double          REAL;
typedef unsigned char   *OBJREF;
typedef unsigned char   *POINTER;

#define                 true        ((BOOLEAN) 1)
#define                 false       ((BOOLEAN) 0)

/*------------------------------------------------------------------*/
/* Debugging and frame definitions                                  */
/*------------------------------------------------------------------*/

#ifdef EDEBUG

typedef struct rtf {

    char        *name;
    OBJREF      Current;
    INTEGER     gac;
    INT16       rec;
    INT16       line;
    BOOLEAN     ic;
    OBJREF      *locals;
    INT16       local_count;
    struct rtf  *next;

} RTF;

#define     ESLINE(ddd)         _mf.line = (int) (ddd)
#define     RTF_return          {_cf->next = (RTF *) 0;}
#define     RTF_restore         {_mf.next  = (RTF *) 0; RTMM_stop = _mf.gac; EFrec = (INTEGER) _mf.rec;}
#define     RTF_inv             (_a0 != _cf->Current)
#define     RTF_sl(cnt, lc, pf) {pf->next = &_mf; _mf.next = (RTF *) 0; _mf.local_count = (INT16) cnt; _mf.locals = lc; _mf.line = (INT16) 0;}
#define     RTF_sc              {_mf.Current = _a0; _mf.ic = true;}
#define     RTF_sn(nnn)         {_mf.name = (char *) (nnn);}
#define     RTF_sg              {_mf.gac = RTMM_stop;}
#define     RTF_sr              {_mf.rec = (INT16) EFrec;}
#define     REIC                {_cf->ic = true;}
#define     RDIC                {_mf.ic = false;}
#define     RTF_ic              (_cf->ic == true)

#else

typedef struct rtf {

    OBJREF      *locals;
    INT16       local_count;
    INTEGER     gac;
    struct rtf  *next;

} RTF;

#define     ESLINE(ddd)
#define     RTF_return          {_cf->next = (RTF *) 0;}
#define     RTF_restore         {_mf.next  = (RTF *) 0; RTMM_stop = _mf.gac;}
#define     RTF_sl(cnt, lc, pf) {pf->next = &_mf; _mf.next = (RTF *) 0; _mf.local_count = (INT16) cnt; _mf.locals = lc;}
#define     RTF_sg              {_mf.gac = RTMM_stop;}
#define     RTF_sn(nnn)
#define     RTF_sc
#define     RTF_sr
#define     RTF_inv
#define     REIC
#define     RDIC
#define     RTF_ic

#endif

#define RTF_CHECK_IN
#define RTF_CHECK_OUT

/*------------------------------------------------------------------*/
/* Class descriptors                                                */
/*------------------------------------------------------------------*/

#ifdef EANSI

typedef struct ecd {

    INTEGER     f1;
    INTEGER     f2;
    INTEGER     f3;
    INTEGER     f4;
    INTEGER     *f5;
    BOOLEAN     f6;
    BOOLEAN     *f7 [8];
    struct ecd  **f8;
    struct ecd  *f9;
    char        **f10;
    BOOLEAN     **f11;
    char        *f12;
    void        (*f13)(OBJREF);
    void        (*f14)(RTF *, OBJREF);
    OBJREF      (*f15)(RTF *, OBJREF);
    char        *f20;
    INTEGER     *f21;
    char        **f22;

} ECDESC;

#else

typedef struct ecd {

    INTEGER     f1;
    INTEGER     f2;
    INTEGER     f3;
    INTEGER     f4;
    INTEGER     *f5;
    BOOLEAN     f6;
    BOOLEAN     *f7 [8];
    struct ecd  **f8;
    struct ecd  *f9;
    char        **f10;
    BOOLEAN     **f11;
    char        *f12;
    void        (*f13)();
    void        (*f14)();
    OBJREF      (*f15)();
    char        *f20;
    INTEGER     *f21;
    char        **f22;

} ECDESC;

#endif

/*------------------------------------------------------------------*/
/* Other structures                                                 */
/*------------------------------------------------------------------*/

typedef struct  {

    INTEGER     cnr;
    INTEGER     lower;
    INTEGER     upper;

} ETABLE;

typedef union {

    char    *gp_ptr;
    INTEGER gp_off;

} EGPU;

typedef struct  {

    EGPU    gp;
    UINT16  cidx;
    UINT16  gct;

} OBJHDR;

/*------------------------------------------------------------------*/
/* Function pointer types                                           */
/*------------------------------------------------------------------*/

typedef void            (*EPV)();
typedef INTEGER         (*EPI)();
typedef CHARACTER       (*EPC)();
typedef BOOLEAN         (*EPB)();
typedef REAL            (*EPR)();
typedef OBJREF          (*EPO)();

/*------------------------------------------------------------------*/
/* Object access macros                                             */
/*------------------------------------------------------------------*/

#define ECDP(obj)       (RTMM_cdescs [((((OBJHDR *) (obj)) - 1)->cidx)])
#define ECNR(obj)       (((((OBJHDR *) (obj)) - 1)->cidx) / 2)
#define ECMP(obj)       (((((OBJHDR *) (obj)) - 1)->gp).gp_ptr)
#define EOFF(obj)       (((((OBJHDR *) (obj)) - 1)->gp).gp_off)
#define EGCT(obj)       ((((OBJHDR *) (obj)) - 1)->gct)

/*------------------------------------------------------------------*/
/* External functions                                               */
/*------------------------------------------------------------------*/

#ifdef EANSI

extern  void        _eprof_increment_v (int);
extern  void        _eprof_increment_r (int);
extern  void        _eprof_end (void);
extern  void        _rtf_check_in (void);
extern  void        _rtf_check_out (char *);

extern  CHARACTER   *OS_alloc (INTEGER);
extern  void        OS_free (CHARACTER *);
extern  void        OS_memcpy (CHARACTER *, CHARACTER *, INTEGER);
extern  CHARACTER   *OS_realloc (CHARACTER *, INTEGER);
extern  CHARACTER   *RARR_seq (OBJREF);
extern  INTEGER     RARR_size (OBJREF);
extern  CHARACTER   RARR_type (OBJREF);
extern  OBJREF      RTC11_assign (ECDESC *, OBJREF);
extern  OBJREF      RTC11_expand (OBJREF);
extern  INTEGER     RTC11_inspect (ETABLE *, INTEGER, INTEGER);
extern  BOOLEAN     RTC11_is_equal (OBJREF, OBJREF);
extern  OBJREF      RTC11_reverse_assign (ECDESC *, OBJREF);
extern  INTEGER     RTC12_clock (void);
extern  REAL        RTC12_localtime (REAL);
extern  REAL        RTC12_now (void);
extern  INTEGER     RTC2_count (OBJREF);
extern  OBJREF      RTC2_create (CHARACTER *);
extern  OBJREF      RTC2_c_create (CHARACTER *);
extern  CHARACTER   *RTC2_seq (OBJREF);
extern  INTEGER     RTC3_count (OBJREF);
extern  OBJREF      RTC3_l_make (CHARACTER *);
extern  OBJREF      RTC3_make (INTEGER);
extern  void        RTC3_reset (OBJREF);
extern  CHARACTER   *RTC3_seq (OBJREF);
extern  void        RTC4_fail (void);
extern  OBJREF      RTC4_last_ecall (void);
extern  INTEGER     RTC4_last_ecode (void);
extern  OBJREF      RTC4_last_eobj (void);
extern  OBJREF      RTC4_last_etext (void);
extern  void        RTC4_pop (void);
extern  int         *RTC4_push (void);
extern  void        RTC4_raise (CHARACTER *, CHARACTER *, INTEGER, OBJREF);
extern  INTEGER     RTC5_arg_count (void);
extern  CHARACTER   *RTC5_arg_item (INTEGER);
extern  CHARACTER   *RTC5_env_item (CHARACTER *);
extern  void        RTC5_env_put (CHARACTER *, CHARACTER *);
extern  CHARACTER   *RTC5_program_name (void);
extern  OBJREF      RTC6_create (INTEGER);
extern  INTEGER     RTC6_power (INTEGER, INTEGER);
extern  OBJREF      RTC7_create (CHARACTER);
extern  OBJREF      RTC8_create (BOOLEAN);
extern  OBJREF      RTC9_create (REAL);
extern  REAL        RTC9_power (REAL, INTEGER);
extern  OBJREF      RTCA_ma (INTEGER, ECDESC *, ...);
extern  OBJREF      RTCA_mb (INTEGER, ECDESC *, ...);
extern  OBJREF      RTCA_mc (INTEGER, ECDESC *, ...);
extern  OBJREF      RTCA_mi (INTEGER, ECDESC *, ...);
extern  OBJREF      RTCA_mr (INTEGER, ECDESC *, ...);
extern  void        RTFM_close (INTEGER);
extern  INTEGER     RTFM_open (CHARACTER *, CHARACTER *, BOOLEAN);
extern  INTEGER     RTFM_read (INTEGER, CHARACTER *, INTEGER);
extern  void        RTFM_seek (INTEGER, INTEGER);
extern  INTEGER     RTFM_size (INTEGER);
extern  void        RTFM_write (INTEGER, CHARACTER *, INTEGER);
extern  void        RTFS_add_cluster (POINTER, POINTER);
extern  void        RTFS_add_file (POINTER, POINTER);
extern  void        RTFS_change_cluster (POINTER);
extern  void        RTFS_change_cluster_perm (POINTER, POINTER);
extern  void        RTFS_change_file_perm (POINTER, POINTER);
extern  BOOLEAN     RTFS_cluster_exists (POINTER);
extern  POINTER     RTFS_cluster_perm (POINTER);
extern  REAL        RTFS_cluster_time (POINTER);
extern  CHARACTER   *RTFS_concat_paths (POINTER, POINTER);
extern  void        RTFS_copy_file (POINTER, POINTER);
extern  POINTER     RTFS_current_cluster (void);
extern  INTEGER     RTFS_file_count (POINTER);
extern  BOOLEAN     RTFS_file_exists (POINTER);
extern  CHARACTER   *RTFS_file_perm (POINTER);
extern  REAL        RTFS_file_time (POINTER);
extern  BOOLEAN     RTFS_has_execperm (POINTER);
extern  BOOLEAN     RTFS_has_listperm (POINTER);
extern  BOOLEAN     RTFS_has_modperm (POINTER);
extern  BOOLEAN     RTFS_has_readperm (POINTER);
extern  BOOLEAN     RTFS_has_writeperm (POINTER);
extern  POINTER     RTFS_my_cluster_perm (POINTER);
extern  CHARACTER   *RTFS_my_file_perm (POINTER);
extern  CHARACTER   *RTFS_path_prefix (POINTER);
extern  CHARACTER   *RTFS_path_suffix (POINTER);
extern  void        RTFS_remove_cluster (POINTER);
extern  void        RTFS_remove_file (POINTER);
extern  void        RTFS_rename_file (POINTER, POINTER);
extern  CHARACTER   *RTFS_temp_file (void);
extern  OBJREF      RTMM_create (ECDESC *);
extern  void        RTMM_disable_collector (void);
extern  void        RTMM_enable_collector (void);
extern  void        RTMM_force_collection (void);
extern  ECDESC      *RTMM_get_cdesc (CHARACTER *);
extern  void        RTMM_notify (ECDESC *, ECDESC *);
extern  void        RTMM_protect (OBJREF *, INTEGER);
extern  void        RTMM_run (void);
extern  void        RTMM_set_root (RTF *);
extern  void        RTMM_set_threshold (INTEGER);
extern  void        RTMM_unprotect (OBJREF *);
extern  void        RTsjp (char *);
extern  void        RTTR1 (char *, char *, ...);
extern  void        RTTR2 (char *, char *, ...);
extern  void        RT_end (INTEGER);
extern  void        RT_null (RTF *, OBJREF);
extern  void        RT_start (int, char **);
extern  int         setjmp (int *);

#else

extern  void        _eprof_increment_v ();
extern  void        _eprof_increment_r ();
extern  void        _eprof_end ();
extern  void        _rtf_check_in ();
extern  void        _rtf_check_out ();

extern  CHARACTER   *OS_alloc ();
extern  void        OS_free ();
extern  void        OS_memcpy ();
extern  CHARACTER   *OS_realloc ();
extern  CHARACTER   *RARR_seq ();
extern  INTEGER     RARR_size ();
extern  CHARACTER   RARR_type ();
extern  OBJREF      RTC11_assign ();
extern  OBJREF      RTC11_expand ();
extern  INTEGER     RTC11_inspect ();
extern  BOOLEAN     RTC11_is_equal ();
extern  OBJREF      RTC11_reverse_assign ();
extern  INTEGER     RTC12_clock ();
extern  REAL        RTC12_localtime ();
extern  REAL        RTC12_now ();
extern  INTEGER     RTC2_count ();
extern  OBJREF      RTC2_create ();
extern  OBJREF      RTC2_c_create ();
extern  CHARACTER   *RTC2_seq ();
extern  INTEGER     RTC3_count ();
extern  OBJREF      RTC3_l_make ();
extern  OBJREF      RTC3_make ();
extern  void        RTC3_reset ();
extern  CHARACTER   *RTC3_seq ();
extern  void        RTC4_fail ();
extern  OBJREF      RTC4_last_ecall ();
extern  INTEGER     RTC4_last_ecode ();
extern  OBJREF      RTC4_last_eobj ();
extern  OBJREF      RTC4_last_etext ();
extern  void        RTC4_pop ();
extern  int         *RTC4_push ();
extern  void        RTC4_raise ();
extern  INTEGER     RTC5_arg_count ();
extern  CHARACTER   *RTC5_arg_item ();
extern  CHARACTER   *RTC5_env_item ();
extern  void        RTC5_env_put ();
extern  CHARACTER   *RTC5_program_name ();
extern  OBJREF      RTC6_create ();
extern  INTEGER     RTC6_power ();
extern  OBJREF      RTC7_create ();
extern  OBJREF      RTC8_create ();
extern  OBJREF      RTC9_create ();
extern  REAL        RTC9_power ();
extern  OBJREF      RTCA_ma ();
extern  OBJREF      RTCA_mb ();
extern  OBJREF      RTCA_mc ();
extern  OBJREF      RTCA_mi ();
extern  OBJREF      RTCA_mr ();
extern  void        RTFM_close ();
extern  INTEGER     RTFM_open ();
extern  INTEGER     RTFM_read ();
extern  void        RTFM_seek ();
extern  INTEGER     RTFM_size ();
extern  void        RTFM_write ();
extern  void        RTFS_add_cluster ();
extern  void        RTFS_add_file ();
extern  void        RTFS_change_cluster ();
extern  void        RTFS_change_cluster_perm ();
extern  void        RTFS_change_file_perm ();
extern  BOOLEAN     RTFS_cluster_exists ();
extern  POINTER     RTFS_cluster_perm ();
extern  REAL        RTFS_cluster_time ();
extern  CHARACTER   *RTFS_concat_paths ();
extern  void        RTFS_copy_file ();
extern  POINTER     RTFS_current_cluster ();
extern  INTEGER     RTFS_file_count ();
extern  BOOLEAN     RTFS_file_exists ();
extern  CHARACTER   *RTFS_file_perm ();
extern  REAL        RTFS_file_time ();
extern  BOOLEAN     RTFS_has_execperm ();
extern  BOOLEAN     RTFS_has_listperm ();
extern  BOOLEAN     RTFS_has_modperm ();
extern  BOOLEAN     RTFS_has_readperm ();
extern  BOOLEAN     RTFS_has_writeperm ();
extern  POINTER     RTFS_my_cluster_perm ();
extern  CHARACTER   *RTFS_my_file_perm ();
extern  CHARACTER   *RTFS_path_prefix ();
extern  CHARACTER   *RTFS_path_suffix ();
extern  void        RTFS_remove_cluster ();
extern  void        RTFS_remove_file ();
extern  void        RTFS_rename_file ();
extern  CHARACTER   *RTFS_temp_file ();
extern  OBJREF      RTMM_create ();
extern  void        RTMM_disable_collector ();
extern  void        RTMM_enable_collector ();
extern  void        RTMM_force_collection ();
extern  ECDESC      *RTMM_get_cdesc ();
extern  void        RTMM_notify ();
extern  void        RTMM_protect ();
extern  void        RTMM_run ();
extern  void        RTMM_set_root ();
extern  void        RTMM_set_threshold ();
extern  void        RTMM_unprotect ();
extern  void        RTsjp ();
extern  void        RTTR1 ();
extern  void        RTTR2 ();
extern  void        RT_end ();
extern  void        RT_null ();
extern  void        RT_start ();
extern  int         setjmp ();

#endif
/*------------------------------------------------------------------*/
/* external variables                                               */
/*------------------------------------------------------------------*/

extern      OBJREF          VOIDREF;
extern      INTEGER         RTMM_stop;
extern      ECDESC          **RTMM_cdescs;
extern      BOOLEAN         EFinvcheck;
extern      INTEGER         EFrec;

/*------------------------------------------------------------------*/
/* Exception codes                                                  */
/*------------------------------------------------------------------*/

#define     INTERRUPT               (INTEGER) 10000
#define     PRECONDITION            (INTEGER) 10001
#define     POSTCONDITION           (INTEGER) 10002
#define     CLASS_INVARIANT         (INTEGER) 10003
#define     LOOP_VARIANT            (INTEGER) 10004
#define     LOOP_INVARIANT          (INTEGER) 10005
#define     CHECK_INSTRUCTION       (INTEGER) 10006
#define     INVALID_INSPECT_VALUE   (INTEGER) 10007
#define     NO_MORE_MEMORY          (INTEGER) 10008
#define     VOID_CALL_TARGET        (INTEGER) 10009
#define     ARITH_DOMAIN            (INTEGER) 10010
#define     ARITH_SINGULAR          (INTEGER) 10011
#define     ARITH_OVERFLOW          (INTEGER) 10012
#define     ARITH_UNDERFLOW         (INTEGER) 10013
#define     ARITH_TOTAL_LOSS        (INTEGER) 10014
#define     ARITH_PARTIAL_LOSS      (INTEGER) 10015
#define     ARITH_ERROR             (INTEGER) 10016
#define     SIGNAL                  (INTEGER) 10017
#define     ILLEGAL_FREE            (INTEGER) 10018
#define     INTERNAL                (INTEGER) 10019
#define     NO_PERMISSION           (INTEGER) 10020
#define     INVALID_PATH            (INTEGER) 10021
#define     INTERRUPTED             (INTEGER) 10022
#define     PHYSICAL_IO_ERROR       (INTEGER) 10023
#define     DRIVE_NOT_READY         (INTEGER) 10024
#define     BAD_FILE_DESCRIPTOR     (INTEGER) 10025
#define     NOT_A_DIRECTORY         (INTEGER) 10026
#define     IS_A_DIRECTORY          (INTEGER) 10027
#define     FILE_TOO_LARGE          (INTEGER) 10028
#define     NO_MORE_SPACE           (INTEGER) 10029
#define     OS_ERROR                (INTEGER) 10030
#define     ILLEGAL_HOOK            (INTEGER) 10031
#define     VOID_ASSIGNED_TO_EXP    (INTEGER) 10032
#define     TYPE_MISMATCH           (INTEGER) 10033
#define     NOT_IN_UNIVERSE         (INTEGER) 10034
#define     DCR_ERROR               (INTEGER) 10035

/*------------------------------------------------------------------*/
/* Macros for compatibility with previous versions                  */
/*------------------------------------------------------------------*/

#define     RSTR_seq                RTC2_seq
#define     RSTR_count              RTC2_count
#define     RSTR_create             RTC2_c_create

/*------------------------------------------------------------------*/

#define     RBIT_seq                RTC3_seq
#define     RBIT_count              RTC3_count
#define     RBIT_create             RTC3_l_make

/*------------------------------------------------------------------*/

#define     RGAC_protect            RTMM_protect
#define     RGAC_unprotect          RTMM_unprotect
#define     RGAC_set_threshold      RTMM_set_threshold
#define     RGAC_enable_collector   RTMM_enable_collector
#define     RGAC_disable_collector  RTMM_disable_collector
#define     RGAC_force_collection   RTMM_force_collection

/*------------------------------------------------------------------*/

#define     RFM_open                RTFM_open
#define     RFM_close               RTFM_close
#define     RFM_read                RTFM_read
#define     RFM_write               RTFM_write
#define     RFM_seek                RTFM_seek

/*------------------------------------------------------------------*/

#define     RFS_add_cluster         RTFS_add_cluster
#define     RFS_remove_cluster      RTFS_remove_cluster
#define     RFS_cluster_exists      RTFS_cluster_exists
#define     RFS_change_cluster      RTFS_change_cluster
#define     RFS_cluster_perm        RTFS_cluster_perm
#define     RFS_my_cluster_perm     RTFS_my_cluster_perm
#define     RFS_cluster_time        RTFS_cluster_time
#define     RFS_cluster_count       RTFS_cluster_count
#define     RFS_subcluster_count    RTFS_subcluster_count
#define     RFS_change_cluster_perm RTFS_change_cluster_perm
#define     RFS_current_cluster     RTFS_current_cluster
#define     RFS_add_file            RTFS_add_file
#define     RFS_remove_file         RTFS_remove_file
#define     RFS_file_exists         RTFS_file_exists
#define     RFS_file_perm           RTFS_file_perm
#define     RFS_my_file_perm        RTFS_my_file_perm
#define     RFS_file_time           RTFS_file_time
#define     RFS_file_count          RTFS_file_count
#define     RFS_change_file_perm    RTFS_change_file_perm
#define     RFS_copy_file           RTFS_copy_file
#define     RFS_rename_file         RTFS_rename_file
#define     RFS_temp_file           RTFS_temp_file
#define     RFS_path_prefix         RTFS_path_prefix
#define     RFS_path_suffix         RTFS_path_suffix
#define     RFS_concat_paths        RTFS_concat_paths
#define     RFS_absolute_path       RTFS_absolute_path
#define     RFS_same_path           RTFS_same_path

/*------------------------------------------------------------------*/

#define     RENV_program_name       RTC5_program_name
#define     RENV_arg_item           RTC5_arg_item
#define     RENV_arg_count          RTC5_arg_count
#define     RENV_env_item           RTC5_env_item
#define     RENV_env_put            RTC5_env_put

/*------------------------------------------------------------------*/

#define     RMM_alloc               OS_alloc
#define     RMM_realloc             OS_realloc
#define     RMM_free                OS_free

/*------------------------------------------------------------------*/

#define     RTM_now                 RTC12_now
#define     RTM_clock               RTC12_clock

/*------------------------------------------------------------------*/

#define     RXM_raise               RTC4_raise
#define     RXM_last_ecall          RTC4_last_ecall
#define     RXM_last_etext          RTC4_last_etext
#define     RXM_last_ecode          RTC4_last_ecode
#define     RXM_last_eobj           RTC4_last_eobj

/*------------------------------------------------------------------*/
#define setjmp _setjmp

