-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   MATH

feature {ANY}

    pi  : REAL is  3.14159265358979323846
    e   : REAL is  2.71828182845904523536 
    deg : REAL is 57.29577951308232087680   -- deg/radian
    phi : REAL is  1.61803398874989484820   -- golden ratio

-----------------------------------------------------------

    arccos (x : REAL) : REAL is

        require
            legal_argument : -1.0 <= x and then x <= 1.0

        external "C" -- changed by x_c_cwc
        alias "OS8_acos"
        end
-----------------------------------------------------------
 
    arccosh (x : REAL) : REAL is

        require
            non_negative_argument : x >= 1.0

        external "C" -- changed by x_c_cwc
        alias "OS8_acosh"
        end
-----------------------------------------------------------
 
    arcsin (x : REAL) : REAL is

        require
            legal_argument : -1.0 <= x and then x <= 1.0

        external "C" -- changed by x_c_cwc
        alias "OS8_asin"
        end
-----------------------------------------------------------

    arcsinh (x : REAL) : REAL is

        external "C" -- changed by x_c_cwc
        alias "OS8_asinh"
        end
-----------------------------------------------------------
 
    arctan (x : REAL) : REAL is
                -- Value in the range [-pi/2, pi/2]

        external "C" -- changed by x_c_cwc
        alias "OS8_atan"
        end
-----------------------------------------------------------

    arctan2 (y, x : REAL) : REAL is
                -- Inverse tangent of y/x in range (-pi, pi]
                -- Quadrant depends on signs of x, y

         require
           non_zero_x : -- x /= 0.0

        external "C" -- changed by x_c_cwc
         alias "OS8_atan2"
         end
-----------------------------------------------------------

    arctanh (x : REAL) : REAL is

        require
            non_negative_argument: x >= 0.0

        external "C" -- changed by x_c_cwc
        alias "OS8_atanh"
        end
-----------------------------------------------------------
 
    ceiling (x : REAL) : INTEGER is
              -- smallest integer >= x

        external "C" -- changed by x_c_cwc
        alias "OS8_ceil"
        end
-----------------------------------------------------------
 
    cos (x : REAL) : REAL is

        external "C" -- changed by x_c_cwc
        alias "OS8_cos"
        end
-----------------------------------------------------------
 
    cosh (x : REAL) : REAL is

        external "C" -- changed by x_c_cwc
        alias "OS8_cosh"
        end
-----------------------------------------------------------

    exp (x : REAL) : REAL is

        external "C" -- changed by x_c_cwc
        alias "OS8_exp"
        end
-----------------------------------------------------------
 
    abs (x : REAL) : REAL is

        do
            Result := x

            if x < 0.0 then
                Result := -x
            end
        end
-----------------------------------------------------------
 
    floor (x : REAL) : INTEGER is
              -- largest integer <= x

        external "C" -- changed by x_c_cwc
        alias "OS8_floor"
        end
-----------------------------------------------------------
 
    log (x : REAL) : REAL is

        require
            positive_argument : x > 0.0

        external "C" -- changed by x_c_cwc
        alias "OS8_log"
        end
-----------------------------------------------------------

    sin (x : REAL) : REAL is

        external "C" -- changed by x_c_cwc
        alias "OS8_sin"
        end
-----------------------------------------------------------
 
    sinh (x : REAL) : REAL is

        external "C" -- changed by x_c_cwc
        alias "OS8_sinh"
        end
-----------------------------------------------------------
 
    sqrt (x : REAL) : REAL is

        require
            non_negative_argument : x >= 0.0

        external "C" -- changed by x_c_cwc
        alias "OS8_sqrt"
        end
-----------------------------------------------------------
 
    tan (x : REAL) : REAL is

        external "C" -- changed by x_c_cwc
        alias "OS8_tan"
        end
-----------------------------------------------------------
 
    tanh (x : REAL) : REAL is

        external "C" -- changed by x_c_cwc
        alias "OS8_tanh"
        end
-----------------------------------------------------------
 
    rand : INTEGER is

        external "C" -- changed by x_c_cwc
        alias "OS8_rand"
        end
-----------------------------------------------------------

    srand (seed : INTEGER) is

        external "C" -- changed by x_c_cwc
        alias "OS8_srand"
        end
-----------------------------------------------------------

end -- class MATH

