-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------

deferred class PART_COMPARABLE
                        -- This class describes a 
                        -- partial order relation.
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    infix "<" (other : like Current) : BOOLEAN is
                    -- Is 'Current' strictly less than 'other'?
        require
            other_not_void : other /= Void
        deferred
        ensure
            consistent    : Result implies not (other <= Current) 
            not_reflexive : (Current = other) implies not Result
        end
-----------------------------------------------------------

    infix "<=" (other : like Current) : BOOLEAN is
                    -- Is 'Current' less or equal 'other'?
        require
            other_not_void : other /= Void
        deferred
        ensure
            consistent : Result implies not (other < Current) 
            reflexive  : (Current = other) implies Result
        end
-----------------------------------------------------------

    infix ">" (other : like Current) : BOOLEAN is
                        -- Is 'Current' strictly greater than 'other'?
        require
            other_not_void : other /= Void
        do
            Result := (other < Current)
        ensure
            other_is_less : Result = (other < Current)
        end
-----------------------------------------------------------

    infix ">=" (other : like Current) : BOOLEAN is
                        -- Is 'Current' greater or equal than 'other'?
        require
            other_not_void : other /= Void
        do
            Result := (other <= Current)
        ensure
            other_is_less_or_equal : Result = (other <= Current)
        end
-----------------------------------------------------------

end -- class PART_COMPARABLE

