-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   INTERNAL
                        -- Garbage collector control

-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    enable_collector is
                        -- Enable garbage collector
                        -- NOTE: The GC is enabled by default!
        external "C" -- changed by x_c_cwc
        alias    "RTMM_enable_collector"
        end
-----------------------------------------------------------

    disable_collector is
                        -- Disable garbage collector
        external "C" -- changed by x_c_cwc
        alias    "RTMM_disable_collector"
        end
-----------------------------------------------------------

    force_collection is
                        -- Force garbage colletion 
                        -- NOTE: A collection will be done
                        --       even if the GC is disabled!
        external "C" -- changed by x_c_cwc
        alias    "RTMM_force_collection"
        end
-----------------------------------------------------------

    set_threshold (mem_size : INTEGER) is
                        -- The GC will never be called if
                        -- less than `mem_size' memory is
                        -- used so far. Default depends on OS.
        external "C" -- changed by x_c_cwc
        alias    "RTMM_set_threshold"
        end
-----------------------------------------------------------

end -- class INTERNAL

