-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
expanded class  CHARACTER

inherit

    CHARACTER_REF
        rename
            make as char_useless
        redefine
            infix "<", compare, to_integer, to_lower, to_upper
    end
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    infix "<" (other : CHARACTER) : BOOLEAN is
                        -- Is Current less than `other'?
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    compare (other : CHARACTER) : INTEGER is
                        -- Compare Current with `other'.
                        -- '<' <==> Result < 0
                        -- '>' <==> Result > 0
                        -- Otherwise Result = 0
        do
            Result := to_integer - other.to_integer
        end
-----------------------------------------------------------

    to_integer : INTEGER is
                        -- Integer code of Current
                        -- NOTE: Always >= 0
        external "CWC" -- changed by x_c_cwc
        alias    "RTC7_to_integer"
        end
-----------------------------------------------------------

    to_upper : CHARACTER is
                        -- Conversion of Current to upper case
        external "CWC" -- changed by x_c_cwc
        alias    "RTC7_to_upper"
        end
-----------------------------------------------------------

    to_lower : CHARACTER is
                        -- Conversion of Current to lower case
        external "CWC" -- changed by x_c_cwc
        alias    "RTC7_to_lower"
        end
-----------------------------------------------------------

end -- class CHARACTER

