-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class  CHARACTER_REF

inherit

    COMPARABLE
        redefine
            infix "<", compare
    end
-----------------------------------------------------------
creation {ANY}
    make
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    item : CHARACTER

-----------------------------------------------------------

    make (value : CHARACTER) is

        do
            item := value
        end
-----------------------------------------------------------

    infix "<" (other : CHARACTER_REF) : BOOLEAN is
                        -- Is Current less than `other'?
        do
            Result := item < other.item
        end
-----------------------------------------------------------

    compare (other : CHARACTER_REF) : INTEGER is
                        -- Compare Current with `other'.
                        -- '<' <==> Result < 0
                        -- '>' <==> Result > 0
                        -- Otherwise Result = 0
        do
            Result := to_integer - other.to_integer
        end
-----------------------------------------------------------

    to_integer : INTEGER is
                        -- Integer code of Current
                        -- NOTE: Always >= 0
        do
            Result := item.to_integer
        end
-----------------------------------------------------------

    to_upper : CHARACTER_REF is
                        -- Conversion of Current to upper case
        do
            !!Result.make (item.to_upper)
        end
-----------------------------------------------------------

    to_lower : CHARACTER_REF is
                        -- Conversion of Current to lower case
        do
            !!Result.make (item.to_lower)
        end
-----------------------------------------------------------

end -- class CHARACTER_REF

