-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class BOOLEAN_REF

-----------------------------------------------------------
creation {ANY}
    make
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    item : BOOLEAN      -- Value of Current

-----------------------------------------------------------

    make (value : BOOLEAN) is
                        -- Initialize object
        do  
            item := value
        end
-----------------------------------------------------------


    infix "and" (other : BOOLEAN_REF) : BOOLEAN_REF is
                        -- `and' of Current with `other'.
        require
            other_not_void : other /= Void
        do
            !!Result.make (item and other.item)
        end
-----------------------------------------------------------

    infix "and then" (other : BOOLEAN_REF) : BOOLEAN_REF is
                        -- Semi-strict `and' of Current with `other'.
        require
            other_not_void : other /= Void
        do
            !!Result.make (item and then other.item)
        end
-----------------------------------------------------------

    infix "implies" (other : BOOLEAN_REF) : BOOLEAN_REF is
                        -- Does Current imply `other'.
        require
            other_not_void : other /= Void
        do
            !!Result.make (item implies other.item)
        end
-----------------------------------------------------------

    infix "or" (other : BOOLEAN_REF) : BOOLEAN_REF is
                        -- `or' of Current with `other'
        require
            other_not_void : other /= Void
        do
            !!Result.make (item or other.item)
        end
-----------------------------------------------------------

    infix "or else" (other : BOOLEAN_REF) : BOOLEAN_REF is
                        -- Semi-strict `or' of Current with `other'
        require
            other_not_void : other /= Void
        do
            !!Result.make (item or else other.item)
        end
-----------------------------------------------------------

    infix "xor" (other : BOOLEAN_REF) : BOOLEAN_REF is
                        -- `xor' of Current with `other'
        require
            other_not_void : other /= Void
        do
            !!Result.make (item xor other.item)
        end
-----------------------------------------------------------

    prefix "not" : BOOLEAN_REF is
                        -- `not' of Current.
        do
            !!Result.make (not item)
        end
-----------------------------------------------------------

end -- class BOOLEAN_REF

