-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
expanded  class BIT_N
                        -- NOTE: This class is a template. It
                        -- describes the features applicable
                        -- to entities of type BIT n.
inherit
    ANY
        redefine
            is_equal, copy
    end
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    count   : INTEGER   -- Nr of bits in sequence

-----------------------------------------------------------

    infix "and" (other : BIT_N) : BIT_N is
                        -- Bitwise `and' of Current with `other'
        do
            Result := rt_and (special, count, other.special, other.count)
        end
-----------------------------------------------------------

    infix "or" (other : BIT_N) : BIT_N is
                        -- Bitwise `or' of Current with `other'
        do
            Result := rt_or (special, count, other.special, other.count)
        end
-----------------------------------------------------------

    infix "xor" (other : BIT_N) : BIT_N is
                        -- Bitwise `xor' of Current with `other'
        do
            Result := rt_xor (special, count, other.special, other.count)
        end
-----------------------------------------------------------

    infix "implies" (other : BIT_N) : BIT_N is
                    -- Bitwise implication of Current with `other'
        do
            Result := rt_implies (special, count, other.special, other.count)
        end
-----------------------------------------------------------

    prefix "not" : BIT_N is
                    -- Bitwise `not' of Current.

        do
            Result := rt_not (special, count)
        end
-----------------------------------------------------------

    put (value : BOOLEAN, idx : INTEGER) is
                    -- Set bit at position `idx' to '0', if
                    -- value = false, to '1' otherwise.
        require
            inside_bounds : 1 <= idx and then idx <= count
        do
            rt_put (special, value, idx)
        end
-----------------------------------------------------------

    copy (other : BIT_N) is
                    -- Copy other onto Current
        do
            if special = Void then
                !!special.make (0)
            end
            special.copy (other.special)
            count := other.count
        end
-----------------------------------------------------------

    is_equal (other : BIT_N) : BOOLEAN is
                    -- Is Current bitwise equal to `other'?
        do
            Result := (count = other.count) and then
                      special.is_equal (other.special)
        end
-----------------------------------------------------------

    item (idx : INTEGER) : BOOLEAN is
                    -- Bit at position `idx', interpreted
                    -- as boolean value (0 = false).
        require
            inside_bounds : 1 <= idx and then idx <= count
        do
            Result := rt_item (special, idx)
        end
-----------------------------------------------------------

    to_string : STRING is
                    -- String representation of bit sequence
                    -- A zero bit is mapped to '0', a one bit 
                    -- to '1'. item (1) is rightmost character
                    -- in string.
        do
            Result := rt_string (special, count)
        ensure
            same_count : Result.count = count
        end
-----------------------------------------------------------

    from_string (s : STRING) is
                    -- Fill sequence from string `s'. `s'
                    -- must contain `0' and `1' characters only.
        require
            string_not_void   : s /= Void
            valid_initializer : -- `s' contains `0' and `1' only
            not_too_long      : s.count <= count
        do
            rt_fill (special, s.to_external)
        end 
-----------------------------------------------------------
feature {BIT_N}
-----------------------------------------------------------

    special : ES3_SPEC [CHARACTER]   -- For internal use only

-----------------------------------------------------------

    rt_and (s1 : ES3_SPEC [CHARACTER], c1 : INTEGER,
                s2 : ES3_SPEC [CHARACTER], c2 : INTEGER) : BIT_N is

        external "C" -- changed by x_c_cwc
        alias    "RTC3_and"
        end
-----------------------------------------------------------

    rt_or (s1 : ES3_SPEC [CHARACTER], c1 : INTEGER,
                s2 : ES3_SPEC [CHARACTER], c2 : INTEGER) : BIT_N is

        external "C" -- changed by x_c_cwc
        alias    "RTC3_or"
        end
-----------------------------------------------------------

    rt_xor (s1 : ES3_SPEC [CHARACTER], c1 : INTEGER,
                s2 : ES3_SPEC [CHARACTER], c2 : INTEGER) : BIT_N is

        external "C" -- changed by x_c_cwc
        alias    "RTC3_xor"
        end
-----------------------------------------------------------

    rt_implies (s1 : ES3_SPEC [CHARACTER], c1 : INTEGER,
                s2 : ES3_SPEC [CHARACTER], c2 : INTEGER) : BIT_N is

        external "C" -- changed by x_c_cwc
        alias    "RTC3_implies"
        end
-----------------------------------------------------------

    rt_not (s1 : ES3_SPEC [CHARACTER], c1 : INTEGER) : BIT_N is

        external "C" -- changed by x_c_cwc
        alias    "RTC3_not"
        end
-----------------------------------------------------------

    rt_item (s : ES3_SPEC [CHARACTER], idx : INTEGER) : BOOLEAN is

        external "C" -- changed by x_c_cwc
        alias    "RTC3_item"
        end
-----------------------------------------------------------

    rt_put (s : ES3_SPEC [CHARACTER], v : BOOLEAN, idx : INTEGER) is

        external "C" -- changed by x_c_cwc
        alias    "RTC3_put"
        end
-----------------------------------------------------------

    rt_string (s : ES3_SPEC [CHARACTER], c : INTEGER) : STRING is

        external "C" -- changed by x_c_cwc
        alias    "RTC3_string"
        end
-----------------------------------------------------------

    rt_fill (s : ES3_SPEC [CHARACTER], str : POINTER) is

        external "C" -- changed by x_c_cwc
        alias    "RTC3_fill"
        end
-----------------------------------------------------------

end -- class BIT_N

