-----------------------------------------------------------
--                   Eiffel/S examples                   --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------

  
  
class   M_DEMO
                -- Manifest arrays and basic reference types

-----------------------------------------------------------
creation {ANY}
    make
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    io : BASIC_IO
-----------------------------------------------------------

    make is

        local
            matrix : ARRAY [ARRAY [INTEGER]]
            row1   : ARRAY [INTEGER]
            row2   : ARRAY [INTEGER]
            row3   : ARRAY [INTEGER]
        do
            !!io

            io.put_string ("Print empty list:  ")

            print (<<>>)

            io.put_string ("Print list with five elements:  ")

            print (<< 1, 'X', "Hello World!", 2.3, true >>)

            row1 := << 1, 2, 3 >>
            row2 := << 4, 5, 6 >>
            row3 := << 7, 8, 9 >>

            matrix := << row1, row2, row3 >>

            io.put_string ("%NPrint an integer matrix:%N")

            print_matrix (matrix)
        end
-----------------------------------------------------------

    print (var : ARRAY [ANY]) is

        require
            non_void_argument_list : var /= Void

        local
            i  : INTEGER
            ir : INTEGER_REF
            cr : CHARACTER_REF
            rr : REAL_REF
            br : BOOLEAN_REF
            a  : ANY
            s  : STRING
        do
            io.put_string ("<< ")

            from
                i := var.lower
            until
                i > var.upper
            loop
                a := var.item (i)

                ir ?= a

                if ir /= Void then              -- It's an integer
                    io.put_int (ir.item)
                else
                    cr ?= a
            
                    if cr /= Void then          -- It's a character
                        io.put_char ('%'')
                        io.put_char (cr.item)
                        io.put_char ('%'')
                    else
                        rr ?= a
        
                        if rr /= Void then      -- It's a real
                            io.put_real (rr.item)
                        else
                            br ?= a

                            if br /= Void then  -- It's a boolean
                                io.put_bool (br.item)
                            else
                                s ?= a

                                if s /= Void then
                                    io.put_char ('%"')
                                    io.put_string (s)
                                    io.put_char ('%"')
                                else
                                    io.put_string ("?")
                                end
                            end
                        end
                    end
                end
                i := i + 1

                if i <= var.upper then
                    io.put_string (", ")
                end
            end

            io.put_string (" >>%N")
        end
-----------------------------------------------------------

    print_matrix (m : ARRAY [ARRAY [INTEGER]]) is

        require
            matrix_not_void : m /= Void

        local
            i, j : INTEGER
            row  : ARRAY [INTEGER]
        do
            from
                i := m.lower
            until
                i > m.upper
            loop
                row := m.item (i)

                if row /= Void then
                    from
                        j := row.lower
                    until
                        j > row.upper
                    loop
                        io.put_int (row.item (j))
                        io.put_string ("  ")
                        j := j + 1
                    end
                else
                    io.put_string (" ---- Row is Void ")
                end
                io.put_string ("%N")
                i := i + 1
            end
        end
-----------------------------------------------------------

end -- class M_DEMO

