

/* DEFINITIONS */
/*{{{  states*/
%x endoffile

%{
%}

/*}}}  */
/*{{{  global includes and variables*/

%{
#include <string.h>

int put_lval_number(char *sst);
int put_lval_name(char *str);
int put_lval_integer(void);
int put_lval_double(void);
int put_lval_string(void);
int put_lval_short(void);
int put_lval_typedef(void);
int put_lval_struct(void);
int put_lval_endfile(void);
int put_lval_extern(void);
int put_lval_define(void);
int put_lval_ifdef(void);
int put_lval_endif(void);
int put_lval_pgmname(void);
int put_lval_mfxinit(void);

int ignore=0;
 
%}
/*}}}  */

/* PATTERNS */
 
NAME              [a-zA-Z][a-zA-Z0-9_]*
BLANK             " "|[\t\n]
NUMBER            [0-9][0-9]*

%%
            /* RULES */
int         { if (!ignore){ return(put_lval_integer());}     }
short       { if (!ignore){ return(put_lval_short());}       }
double      { if (!ignore){ return(put_lval_double());}      }
char        { if (!ignore){ return(put_lval_string());}      }
typedef     { if (!ignore){ return(put_lval_typedef());}     }
struct      { if (!ignore){ return(put_lval_struct());}      }
extern      { if (!ignore){ return(put_lval_extern());}      }
#define     { if (!ignore){ return(put_lval_define());}      }
#ifdef      {     ignore=1; return(put_lval_ifdef());        }
#endif      {     ignore=0; return(put_lval_endif());        }
ProgramName { if (!ignore){ return(put_lval_pgmname());}     }
MFX_INIT    { if (!ignore){ return(put_lval_mfxinit());}     }
{NAME}+     { if (!ignore){ return(put_lval_name(yytext));}  }
{NUMBER}+   { if (!ignore){ return(put_lval_number(yytext));}}
"/*"        { register int c;
              /*{{{  */
              for (;;){
                while(( (c=input()) !=  '*') && c != EOF)
                  ;
                if (c=='*'){
                  while( (c=input())== '*')
                    ;
                  if (c=='/') break;
                  }
                if (c==EOF){
                  puts("Error: EOF in comment. Exiting program.");
                  exit(1);
                  break;
                  }
                }
              }
              
              /*}}}  */
(" "|[\t\n])+
<<EOF>> {
  /*{{{  */
  return(0);
  /*}}}  */
  }
.           { if (!ignore){ return(yytext[0]);}              }
 
%%
/* USER CODE */


