%{

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

int yyerror(char*s){ printf(s); return(0); }
void create_c_files(void);
int write_c_files(char *s, char *pgm);

int struct_defined=0;
 
FILE *fp_xbc;
FILE *fp_xbm;
FILE *fp_wdw;
FILE *fp_trl;

FILE *fp_wmfx;
FILE *fp_rmfx;
FILE *fp_dmfx;
FILE *fp_dwdw;

char pgmname[100];
char c_struct_name[100];
char c_var_name[100];
int obj=0;

int wdwnr=0;
 
%}

%union { char sstr[100]; int val; };
 
%token <sstr>  NUMBER
%token <sstr>  NAME
%token <sstr>  INT
%token <sstr>  DOUBLE
%token <sstr>  STRING
%token <sstr>  SHORT
%token <sstr>  TYPEDEF
%token <sstr>  STRUCT
%token <sstr>  EXTERN
%token <sstr>  DEFINE
%token <sstr>  IFDEF
%token <sstr>  ENDIF
%token <sstr>  PGMNAME
%token <sstr>  MFXINIT
%type  <sstr>  v

%left  ']'
%right  '['
%left  '}'
%right  '{'
%left   ';'

%left  HIPREC

%%
 
 
input:   /* empty */
       | input v { }
       ;
v:  TYPEDEF STRUCT '{'            {
    printf("PARSING typedef struct {\n");
    create_c_files();
    }
  | '}' NAME ';' {
    printf("} PARSED: %s\n",$2);
    sprintf(c_struct_name,$2);
    }
  | EXTERN NAME NAME ';'          {
    sprintf(c_var_name,$3);
    printf("\nJust found \"extern %s %s\"; I will use that declaration.\n",
      $2,$3);
    }
  | DEFINE NAME NAME            { }
  | DEFINE NAME NUMBER          { }
  | DEFINE PGMNAME NAME           {
    char sstr[100];
    int ii;
    strcpy(pgmname,$3);
    printf("\nI think \"%s\" is the program you want to execute.\n",pgmname);
 
    sprintf(sstr,"%smfx.c",pgmname); for(ii=0;ii<strlen(sstr);ii++){sstr[ii]=tolower(sstr[ii]);}
    fp_xbc=fopen(sstr,"w"); if (fp_xbc==NULL){puts("ERR: can't write output file!");exit(1);}
    sprintf(sstr,"%smfx.mta",pgmname); for(ii=0;ii<strlen(sstr);ii++){sstr[ii]=tolower(sstr[ii]);}
    fp_xbm=fopen(sstr,"w"); if (fp_xbm==NULL){puts("ERR: can't write output file!");exit(1);}
    sprintf(sstr,"%swdw.mta",pgmname); for(ii=0;ii<strlen(sstr);ii++){sstr[ii]=tolower(sstr[ii]);}
    fp_wdw=fopen(sstr,"w"); if (fp_wdw==NULL){puts("ERR: can't write output file!");exit(1);}
 
    fprintf(fp_wdw,"Malloc(300); @start( (\"%s\") (\"bw\") );\n",pgmname);
    fprintf(fp_wdw,"@%smfx();            %% Read MFX Group Definitions\n",pgmname);
    }
  | IFDEF         { puts("Found MFX Data Initialization..."); }
  | ENDIF         {
    puts("End of MFX Data Initialization");
    write_c_files(c_var_name,pgmname);
    }
  | INT NAME ';'                  {
    /*{{{  */
    fprintf(fp_dmfx,"i( (\"%s\") 0 );\n",$2);
    obj++;
    fprintf(fp_dwdw,"o( $WDW,(\"%02dt\") S . 1 %d 8 1 Remark);bg( $WDW,(\"%02dt\") . (\"%s\") ); eg(); %% Description\n",obj,obj,obj,$2);
    fprintf(fp_dwdw,"o( $WDW,(\"%02d\") I I 9 %d 8 1 Standard);bg( $WDW,(\"%02d\") . (ptr)MFX:$MFX.%s ); %% Integer Object\n",obj,obj,obj,$2);
    fprintf(fp_dwdw,"  cn(epO $WDW,(\"%02d\") );",obj-1);
    fprintf(fp_dwdw,"cn(edO $WDW,(\"%02d\") );eg(); \n",obj+1);
    fprintf(fp_wmfx,"XbWMFX_PutInteger(&thestruct.%s,\"%s\");\n",$2,$2);
    fprintf(fp_rmfx,"if(XbWMFX_GetInteger(&thestruct.%s)){goto error;}\n",$2);
    printf("short %s\n",$2);
    }
    /*}}}  */
  | INT NAME '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii, no;
      no=atoi($4);
      for (ii=0;ii<no;ii++){
        fprintf(fp_dmfx,"i( (\"%s[%d]\") 0);\n",$2,ii);
        fprintf(fp_wmfx,"XbWMFX_PutInteger(&thestruct.%s[%d],\"%s[%d]\");\n",$2,ii,$2,ii);
        fprintf(fp_rmfx,"if(XbWMFX_GetInteger(&thestruct.%s[%d])){goto error;}\n",$2,ii);
        }
      printf("integer %s[%s]\n",$2,$4);
      }
    }
    /*}}}  */
  | INT NAME '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii,jj, nox,noy;
      nox=atoi($4);
      noy=atoi($7);
      for (ii=0;ii<nox;ii++){
        for (jj=0;jj<noy;jj++){
          fprintf(fp_dmfx,"i( (\"%s[%d][%d]\") 0);\n",$2,ii,jj);
          fprintf(fp_wmfx,"XbWMFX_PutInteger(&thestruct.%s[%d][%d],\"%s[%d][%d]\");\n",$2,ii,jj,$2,ii,jj);
          fprintf(fp_rmfx,"if(XbWMFX_GetInteger(&thestruct.%s[%d][%d])){goto error;}\n",$2,ii,jj);
          }
        }
      printf("integer %s[%s][%s]\n",$2,$4,$7);
      }
    }
    /*}}}  */
  | INT NAME '[' NUMBER ']' '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii,jj,kk, nox,noy,noz;
      nox=atoi($4);
      noy=atoi($7);
      noz=atoi($10);
      for (ii=0;ii<nox;ii++){
        for (jj=0;jj<noy;jj++){
          for (kk=0;kk<noz;kk++){
            fprintf(fp_dmfx,"i( (\"%s[%d][%d][%d]\") 0);\n",$2,ii,jj,kk);
            fprintf(fp_wmfx,"XbWMFX_PutInteger(&thestruct.%s[%d][%d][%d],\"%s[%d][%d][%d]\");\n",$2,ii,jj,kk,$2,ii,jj,kk);
            fprintf(fp_rmfx,"if(XbWMFX_GetInteger(&thestruct.%s[%d][%d][%d])){goto error;}\n",$2,ii,jj,kk);
            }
          }
        }
      printf("integer %s[%s][%s][%s]\n",$2,$4,$7,$10);
      }
    }
    /*}}}  */
  | DOUBLE NAME ';'               {
    /*{{{  */
    fprintf(fp_dmfx,"d( (\"%s\") 0.0000001);\n",$2);
    obj++;
    fprintf(fp_dwdw,"o( $WDW,(\"%02dt\") S . 1 %d 8 1 Remark);bg( $WDW,(\"%02dt\") . (\"%s\") ); eg(); %% Description\n",obj,obj,obj,$2);
    fprintf(fp_dwdw,"o( $WDW,(\"%02d\") S . 9 %d 15 1 Standard);  %% Double Float Object\n",obj,obj);
    fprintf(fp_dwdw,"bg( $WDW,(\"%02d\") . (ptr)MFX:$MFX.%s );  %% Object Head\n",obj,$2);
    fprintf(fp_dwdw,"  ff( (\"%%14.7f\") (\"\") 1 );\n          %% Object Body with Display Format\n");
    fprintf(fp_dwdw,"  cn(epO $WDW,(\"%02d\") );",obj-1);
    fprintf(fp_dwdw,"cn(edO $WDW,(\"%02d\") );eg(); \n",obj+1);
    fprintf(fp_wmfx,"XbWMFX_PutDouble(&thestruct.%s,\"%s\");\n",$2,$2);
    fprintf(fp_rmfx,"if(XbWMFX_GetDouble(&thestruct.%s)){goto error;}\n",$2);
    printf("double %s\n",$2);
    }
    /*}}}  */
  | DOUBLE NAME '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii, no;
      no=atoi($4);
      for (ii=0;ii<no;ii++){
        fprintf(fp_dmfx,"d( (\"%s[%d]\") 0.0000001 );\n",$2,ii);
        fprintf(fp_wmfx,"XbWMFX_PutDouble(&thestruct.%s[%d],\"%s[%d]\");\n",$2,ii,$2,ii);
        fprintf(fp_rmfx,"if(XbWMFX_GetDouble(&thestruct.%s[%d])){goto error;}\n",$2,ii);
        }
      printf("double %s[%s]\n",$2,$4);
      }
    }
    /*}}}  */
  | DOUBLE NAME '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii,jj, nox,noy;
      nox=atoi($4);
      noy=atoi($7);
      for (ii=0;ii<nox;ii++){
        for (jj=0;jj<noy;jj++){
          fprintf(fp_dmfx,"d( (\"%s[%d][%d]\") 0.0000001 );\n",$2,ii,jj);
          fprintf(fp_wmfx,"XbWMFX_PutDouble(&thestruct.%s[%d][%d],\"%s[%d][%d]\");\n",$2,ii,jj,$2,ii,jj);
          fprintf(fp_rmfx,"if(XbWMFX_GetDouble(&thestruct.%s[%d][%d])){goto error;}\n",$2,ii,jj);
          }
        }
      printf("double %s[%s][%s]\n",$2,$4,$7);
      }
    }
    /*}}}  */
  | DOUBLE NAME '[' NUMBER ']' '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii,jj,kk, nox,noy,noz;
      nox=atoi($4);
      noy=atoi($7);
      noz=atoi($10);
      for (ii=0;ii<nox;ii++){
        for (jj=0;jj<noy;jj++){
          for (kk=0;kk<noz;kk++){
            fprintf(fp_dmfx,"d( (\"%s[%d][%d][%d]\") 0.0000001 );\n",$2,ii,jj,kk);
            fprintf(fp_wmfx,"XbWMFX_PutDouble(&thestruct.%s[%d][%d][%d],\"%s[%d][%d][%d]\");\n",$2,ii,jj,kk,$2,ii,jj,kk);
            fprintf(fp_rmfx,"if(XbWMFX_GetDouble(&thestruct.%s[%d][%d][%d])){goto error;}\n",$2,ii,jj,kk);
            }
          }
        }
      printf("double %s[%s][%s][%s]\n",$2,$4,$7,$10);
      }
    }
    /*}}}  */
  | STRING NAME '[' NUMBER ']' ';'{
    /*{{{  */
    fprintf(fp_dmfx,"s( (\"%s\") %s (\" \") );\n",$2,$4);
    obj++;
    fprintf(fp_dwdw,"o( $WDW,(\"%02dt\") S . 1 %d 8 1 Remark);bg( $WDW,(\"%02dt\") . (\"%s\") ); eg(); %% Description\n",obj,obj,obj,$2);
    fprintf(fp_dwdw,"o( $WDW,(\"%02d\") S S 9 %d 40 1 Standard);bg( $WDW,(\"%02d\") . (ptr)MFX:$MFX.%s );       %% String Object\n",obj,obj,obj,$2);
    fprintf(fp_dwdw,"  cn(epO $WDW,(\"%02d\") );",obj-1);
    fprintf(fp_dwdw,"cn(edO $WDW,(\"%02d\") );eg(); \n",obj+1);
    fprintf(fp_wmfx,"XbWMFX_PutString(thestruct.%s,\"%s\");\n",$2,$2);
    fprintf(fp_rmfx,"if(XbWMFX_GetString(thestruct.%s)){goto error;}\n",$2);
    printf("string %s\n",$2);
    }
    /*}}}  */
  | STRING NAME '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii, nox;
      nox=atoi($4);
      for (ii=0;ii<nox;ii++){
        fprintf(fp_dmfx,"s( (\"%s[%d]\") %s (\" \") );\n",$2,ii,$4);
        fprintf(fp_wmfx,"XbWMFX_PutString(&thestruct.%s[%d][0],\"%s[%d]\");\n",$2,ii,$2,ii);
        fprintf(fp_rmfx,"if(XbWMFX_GetString(&thestruct.%s[%d][0])){goto error;}\n",$2,ii);
        }
      printf("string %s[%s]\n",$2,$4);
      }
    }
    /*}}}  */
  | SHORT NAME ';'                {
    /*{{{  */
    fprintf(fp_dmfx,"i( (\"%s\") 0 );\n",$2);
    obj++;
    fprintf(fp_dwdw,"o( $WDW,(\"%02dt\") S . 1 %d 8 1 Remark);bg( $WDW,(\"%02dt\") . (\"%s\") ); eg(); %% Description\n",obj,obj,obj,$2);
    fprintf(fp_dwdw,"o( $WDW,(\"%02d\") I I 9 %d 8 1 Standard);bg( $WDW,(\"%02d\") . (ptr)MFX:$MFX.%s );  %% Integer Object\n",obj,obj,obj,$2);
    fprintf(fp_dwdw,"  cn(epO $WDW,(\"%02d\") );",obj-1);
    fprintf(fp_dwdw,"cn(edO $WDW,(\"%02d\") );eg(); \n",obj+1);
    fprintf(fp_wmfx,"XbWMFX_PutShort(&thestruct.%s,\"%s\");\n",$2,$2);
    fprintf(fp_rmfx,"if(XbWMFX_GetShort(&thestruct.%s)){goto error;}\n",$2);
    printf("short %s\n",$2);
    }
    /*}}}  */
  | SHORT NAME '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii, no;
      no=atoi($4);
      for (ii=0;ii<no;ii++){
        fprintf(fp_dmfx,"i( (\"%s[%d]\") 0);\n",$2,ii);
        fprintf(fp_wmfx,"XbWMFX_PutShort(&thestruct.%s[%d],\"%s[%d]\");\n",$2,ii,$2,ii);
        fprintf(fp_rmfx,"if(XbWMFX_GetShort(&thestruct.%s[%d])){goto error;}\n",$2,ii);
        }
      printf("short %s[%s]\n",$2,$4);
      }
    }
    /*}}}  */
  | SHORT NAME '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii,jj, nox,noy;
      nox=atoi($4);
      noy=atoi($7);
      for (ii=0;ii<nox;ii++){
        for (jj=0;jj<noy;jj++){
          fprintf(fp_dmfx,"i( (\"%s[%d][%d]\") 0);\n",$2,ii,jj);
          fprintf(fp_wmfx,"XbWMFX_PutShort(&thestruct.%s[%d][%d],\"%s[%d][%d]\");\n",$2,ii,jj,$2,ii,jj);
          fprintf(fp_rmfx,"if(XbWMFX_GetShort(&thestruct.%s[%d][%d])){goto error;}\n",$2,ii,jj);
          }
        }
      printf("short %s[%s][%s]\n",$2,$4,$7);
      }
    }
    /*}}}  */
  | SHORT NAME '[' NUMBER ']' '[' NUMBER ']' '[' NUMBER ']' ';'   {
    /*{{{  */
    { int ii,jj,kk, nox,noy,noz;
      nox=atoi($4);
      noy=atoi($7);
      noz=atoi($10);
      for (ii=0;ii<nox;ii++){
        for (jj=0;jj<noy;jj++){
          for (kk=0;kk<noz;kk++){
            fprintf(fp_dmfx,"i( (\"%s[%d][%d][%d]\") 0);\n",$2,ii,jj,kk);
            fprintf(fp_wmfx,"XbWMFX_PutShort(&thestruct.%s[%d][%d][%d],\"%s[%d][%d][%d]\");\n",$2,ii,jj,kk,$2,ii,jj,kk);
            fprintf(fp_rmfx,"if(XbWMFX_GetShort(&thestruct.%s[%d][%d][%d])){goto error;}\n",$2,ii,jj,kk);
            }
          }
        }
      printf("short %s[%s][%s][%s]\n",$2,$4,$7,$10);
      }
    }
    /*}}}  */
  ;
%%
 
int put_lval_number(char *sst){strcpy(yylval.sstr,sst);      return(NUMBER); }
int put_lval_name(char *sst){  strcpy(yylval.sstr,sst);      return(NAME);   }
int put_lval_integer(void){    strcpy(yylval.sstr,"int");    return(INT);    }
int put_lval_double(void){     strcpy(yylval.sstr,"double"); return(DOUBLE); }
int put_lval_string(void){     strcpy(yylval.sstr,"char");   return(STRING); }
int put_lval_short(void){      strcpy(yylval.sstr,"short");  return(SHORT);  }
int put_lval_typedef(void){    strcpy(yylval.sstr,"typedef");return(TYPEDEF);}
int put_lval_struct(void){     strcpy(yylval.sstr,"struct"); return(STRUCT); }
int put_lval_extern(void){     strcpy(yylval.sstr,"extern"); return(EXTERN); }
int put_lval_define(void){     strcpy(yylval.sstr,"define"); return(DEFINE); }
int put_lval_ifdef(void){      strcpy(yylval.sstr,"ifdef");  return(IFDEF);  }
int put_lval_endif(void){      strcpy(yylval.sstr,"endif");  return(ENDIF);  }
int put_lval_pgmname(void){    strcpy(yylval.sstr,"pgmname");return(PGMNAME);}
int put_lval_mfxinit(void){    strcpy(yylval.sstr,"mfxinit");return(MFXINIT);}


void create_c_files(void){
  c_var_name[0]=0;
  obj=4;
  fp_wmfx=fopen("makemfx.wmfx","w"); if (fp_wmfx==NULL){puts("ERR: can't write scratch file!");exit(1);}
  fp_rmfx=fopen("makemfx.rmfx","w"); if (fp_rmfx==NULL){puts("ERR: can't write scratch file!");exit(1);}
  fp_dmfx=fopen("makemfx.dmfx","w"); if (fp_dmfx==NULL){puts("ERR: can't write scratch file!");exit(1);}
  fp_dwdw=fopen("makemfx.dwdw","w"); if (fp_dwdw==NULL){puts("ERR: can't write scratch file!");exit(1);}
  }

int write_c_files(char *s, char *pgm){
  char sstr[100];
  int ii;
 
  fclose(fp_dmfx);
  fclose(fp_rmfx);
  fclose(fp_wmfx);
  fclose(fp_dwdw);
 
  system("cp /xw/xbmfx/* .");
  fprintf(fp_xbc,"/*  XbW MetaFile eXchange (Interface to Applications): XBMFX  */\n");
 
  if (!struct_defined){
    struct_defined = 1;
    fprintf(fp_xbc,"\n#ifdef ALREADY_DEFINED_MFX_%s /* Schon #defined ? */\n",s);
    fprintf(fp_xbc,"\n#else \n");
    fprintf(fp_xbc,"\n#define ALREADY_DEFINED_MFX_%s 1 \n",s);
    fprintf(fp_xbc,"\n#ifndef ProgramName /* Extra Module */\n");
    fprintf(fp_xbc,"#include <stdlib.h>\n");
    fprintf(fp_xbc,"#include <stdio.h>\n");
    fprintf(fp_xbc,"#include <string.h>\n");
    fprintf(fp_xbc,"#define MFX_INIT 1\n");
    fprintf(fp_xbc,"#include \"xbmfx.h\"\n");
    fprintf(fp_xbc,"#include \"%smfx.h\"\n",pgm);
    fprintf(fp_xbc,"\n#endif /*ProgramName*/\n");
    }
 
  fprintf(fp_xbc,"\n#ifdef thestruct\n");
  fprintf(fp_xbc,"#undef thestruct\n");
  fprintf(fp_xbc,"#endif\n");
 
  if (!c_var_name[0]){
    fprintf(fp_xbc,"#define thestruct MFX_%s\n\n",s);
    fprintf(fp_xbc,"%s MFX_%s;\n\n",s,s);
  } else {
    fprintf(fp_xbc,"#define thestruct %s\n\n",c_var_name);
    }
 
  fprintf(fp_xbc,"int WriteMFXGroup_%s(char*filename, char*dataset, char *mode){\n",c_var_name);
  /*{{{  */
  fprintf(fp_xbc,"  if (filename == NULL) { filename = \"%s.mfx\"; } \n",c_var_name);
  fprintf(fp_xbc,"  if (dataset == NULL) { dataset = \"%s\"; }\n",s);
  fprintf(fp_xbc,"  if (mode == NULL) { mode = \"w\"; }\n");
  fprintf(fp_xbc,"  if (XbWMFX_WriteSet(filename,dataset,mode)) {\n");
  fprintf(fp_xbc,"    return(1);\n");
  fprintf(fp_xbc,"    }\n");
  {
    char li[1000];
    fp_wmfx=fopen("makemfx.wmfx","r");
    if (fp_wmfx==NULL){puts("ERR: can't read scratch file!");exit(1);}
    while(!feof(fp_wmfx)){
      if (fgets(li,1000,fp_wmfx)){
        fputs(li,fp_xbc);
        }
      }
    }
  
  fclose(fp_wmfx);
  unlink("makemfx.wmfx");
  
  fprintf(fp_xbc,"  XbWMFX_WriteEnd();\n");
  fprintf(fp_xbc,"  XbWMFX_CloseSet();\n");
  fprintf(fp_xbc,"  return(0);\n");
  fprintf(fp_xbc,"  }\n\n");
  
  /*}}}  */
  fprintf(fp_xbc,"int ReadMFXGroup_%s(char*filename, char*dataset){\n",c_var_name);
  /*{{{  */
  fprintf(fp_xbc,"  if (filename == NULL) { filename = \"%s.mfx\"; } \n",c_var_name);
  fprintf(fp_xbc,"  if (dataset == NULL) { dataset = \"%s\"; }\n",s);
  fprintf(fp_xbc,"  if (XbWMFX_ReadSet(filename,dataset)) {\n");
  fprintf(fp_xbc,"    puts(\"ERR on opening MFX file; I will now try to append\");\n");
  fprintf(fp_xbc,"    ropenerr:;\n");
  fprintf(fp_xbc,"    printf(\"a working MFX Group %%s to the end of file %%s...\\n\",dataset,filename);\n");
  fprintf(fp_xbc,"    if (!WriteMFXGroup_%s(filename,dataset,\"a\")){\n",c_var_name);
  fprintf(fp_xbc,"      puts(\"...done. Exiting with error code.\");\n");
  fprintf(fp_xbc,"      printf(\"The end of file %%s should now be readable. Please check its contents!\\n\",filename);\n");
  fprintf(fp_xbc,"      printf(\"If %%s did not exist until now, don't get crazy :)\\n\",filename);\n");
  fprintf(fp_xbc,"      return(1);\n");
  fprintf(fp_xbc,"      }\n");
  fprintf(fp_xbc,"    else {\n");
  fprintf(fp_xbc,"      puts(\"...did not work. Exiting with error code.\");\n");
  fprintf(fp_xbc,"      printf(\"I must now overwrite your file %%s, sorry. Please check its contents!\\n\",filename);\n");
  fprintf(fp_xbc,"      WriteMFXGroup_%s(filename,dataset,\"w\");\n",c_var_name);
  fprintf(fp_xbc,"      printf(\"If %%s did not exist until now, don't get crazy :)\\n\",filename);\n");
  fprintf(fp_xbc,"      return(1);\n");
  fprintf(fp_xbc,"      }\n");
  fprintf(fp_xbc,"    }\n");
  {
    char li[1000];
    fp_rmfx=fopen("makemfx.rmfx","r");
    if (fp_rmfx==NULL){puts("ERR: can't read scratch file!");exit(1);}
    while(!feof(fp_rmfx)){
      if (fgets(li,1000,fp_rmfx)>0){
        fputs(li,fp_xbc);
        }
      }
    }
  
  fprintf(fp_xbc,"  XbWMFX_CloseSet();\n");
  fprintf(fp_xbc,"  return(0);\n");
  fprintf(fp_xbc,"error:;\n");
  fprintf(fp_xbc,"  printf(\"Error while reading MFX Group %s\\n\");",c_var_name);
  fprintf(fp_xbc,"  XbWMFX_CloseSet();\n");
  fprintf(fp_xbc,"  puts(\"I will now try to append\");\n");
  fprintf(fp_xbc,"  goto ropenerr;\n");
  fprintf(fp_xbc,"  }\n\n\n");
  
  fclose(fp_rmfx);
  unlink("makemfx.rmfx");
  
  /*}}}  */
  fprintf(fp_xbc,"\n#undef thestruct\n");
 
  fprintf(fp_xbm," %% XbW MFX Group %s\n",s);
  /*{{{  */
  sprintf(sstr,"%s",s); for(ii=0;ii<strlen(sstr);ii++){sstr[ii]=tolower(sstr[ii]);}
  fprintf(fp_xbm,"@mfxgroup/begin( %s (\"%s.mfx\") (\"xbwmfx.\") );\n",s,sstr);
  {
    char li[1000];
    fp_dmfx=fopen("makemfx.dmfx","r");
    if (fp_dmfx==NULL){puts("ERR: can't read scratch file!");exit(1);}
    while(!feof(fp_dmfx)){
      if(fgets(li,1000,fp_dmfx)){
        fputs(li,fp_xbm);
        }
      }
    }
  fclose(fp_dmfx);
  unlink("makemfx.dmfx");
  
  fprintf(fp_xbm,"@mfxgroup/end();\n\n");
  
  /*}}}  */
  fprintf(fp_trl,"MFXGroup( Read %s );\n",s);
 
  /* write window */
  /*{{{  */
  {
    char wdwname[4];
    char li[1000];
    wdwnr++;
    sprintf(wdwname,"WD%02d",wdwnr);
    fprintf(fp_wdw," %% XbW Window definition for MFX Group %s\n",c_var_name);
    fprintf(fp_wdw,"wdw( %s %d %d 60 40 StandardWDW );     %% Get a Window\n",wdwname,wdwnr,wdwnr);
    fprintf(fp_wdw,"@window/gimmicks( (\"%s\") (\" Program '%s' Test-Window '%s' (P) by XbW\") );  %% Get some buttons\n",wdwname,pgmname,wdwname);
    fprintf(fp_wdw,"$MFX:=%s;   %% Set MFX Group Name\n",c_var_name);
    fprintf(fp_wdw,"$WDW:=%s;   %% Set Window Name\n",wdwname);
  
    fprintf(fp_wdw,"o( $WDW,(\"01\") S . 1 3 9 1 Secure );   %% This Object Exits XBW\n");
    fprintf(fp_wdw,"bg( $WDW,(\"01\") . (\"Exit XbW\") );\n");
    fprintf(fp_wdw,"  cn( raK (\"@stop();\") );               %% Macro to Exit XbW\n");
    fprintf(fp_wdw,"  eg();\n");
  
    fprintf(fp_wdw,"o( $WDW,(\"02\") S T 11 3 30 1 Secure );   %% This Object starts the User Program\n");
    fprintf(fp_wdw,"bg( $WDW,(\"02\") . (\" Start Program %s\") );\n",pgmname);
    fprintf(fp_wdw,"  tk( (\"\") (\"%s\") );             %% Program name\n",pgmname);
    fprintf(fp_wdw,"  cn( wbX (\"%s\") );                %% Write MFX Group Before Start\n",c_var_name);
    fprintf(fp_wdw,"  cn( raX (\"%s\") );                %% Read MFX Group after End\n",c_var_name);
    fprintf(fp_wdw,"  eg();\n");
  
    fp_dwdw=fopen("makemfx.dwdw","r");
    if (fp_dwdw==NULL){puts("ERR: can't read scratch file!");exit(1);}
    while(!feof(fp_dwdw)){
      if(fgets(li,1000,fp_dwdw)){
        fputs(li,fp_wdw);
        }
      }
    }
  fclose(fp_dwdw);
  unlink("makemfx.dwdw");
  
  /*}}}  */
  return(0);
  }

int main(int argc, char **argv){
  extern FILE *yyin;
 
  yyin=NULL;
  if (argc>0){     yyin = fopen(argv[1],"r"); }
  if (yyin==NULL){ yyin = stdin; }
 
/*  yydebug = 1; */
 
  fp_trl=fopen("makemfx.emfx","w"); if (fp_trl==NULL){puts("ERR: can't write scratch file!");exit(1);}
 
  yyparse();
 
  fclose(fp_trl);
  {
    char li[1000];
    fp_trl=fopen("makemfx.emfx","r");
    if (fp_trl==NULL){puts("ERR: can't read scratch file!");exit(1);}
    while(!feof(fp_trl)){
      if(fgets(li,1000,fp_trl)){
        fputs(li,fp_wdw);
        }
      }
    }
 
  fprintf(fp_wdw,"SelectWdw( (\"W001\") );\n");
 
  fclose(fp_trl);
  unlink("makemfx.emfx");
 
  fprintf(fp_wdw,"End();\n\n");
 
  fprintf(fp_xbm,"End();\n\n");
  fprintf(fp_xbc,"\n#endif /* ALREADY_DEFINED_MFX_... */\n");
  fclose(fp_xbc);
  fclose(fp_xbm);
  fclose(fp_wdw);
 
  return(0);
  }

