/************************************************/
/*                                              */
/*    Visual X windows Programming Interface    */
/*    ======================================    */
/*                                              */
/*      Copyright (C) 1994  by  Yong Chen       */
/*                                              */
/************************************************/

/* application C source code */

/* include part */

/* X11 and Motif includes part */
#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/Separator.h>
#include <Xm/DrawnB.h>
#include <Xm/BulletinB.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>
#include <X11/Shell.h>

/* application's include part */






/* global definition part */

/* Defines object's Global Access Array */
typedef struct {
	Widget color_slide;
	Widget BulletinBoard1;
	Widget Salmon;
	Widget SkyBlue;
	Widget gold;
	Widget snow;
	Widget Separator3;
	Widget quit;
	Widget Separator2;
	Widget blue;
	Widget green;
	Widget red;
	Widget Separator1;
	Widget Frame1;
	Widget colorwindow;
} _GAArray;
static _GAArray vxpOBJ;

/* application's global definitions */
XColor color;
void new_value();





/*
 *main()
*/
void
main(int argc, char **argv)
{
	/* variable & prototype declaration */
	XtAppContext app_context;
	void vxpInitial();
	Widget color_slide;
	Widget BulletinBoard1;
	Widget Salmon;
	void Salmon_activate_cb();
	Widget SkyBlue;
	void SkyBlue_activate_cb();
	Widget gold;
	void gold_activate_cb();
	Widget snow;
	void snow_activate_cb();
	Widget Separator3;
	Widget quit;
	void quit_activate_cb();
	Widget Separator2;
	Widget blue;
	void blue_valueChanged_cb();
	void blue_drag_cb();
	Widget green;
	void green_valueChanged_cb();
	void green_drag_cb();
	Widget red;
	void red_drag_cb();
	void red_valueChanged_cb();
	Widget Separator1;
	Widget Frame1;
	Widget colorwindow;

	/* create topLevel widget, initialize application */
	color_slide = XtVaAppInitialize(&app_context, "Color_slide",
		NULL, 0, &argc, argv, NULL, NULL);
	vxpOBJ.color_slide = color_slide;

	/* widgets creation */

	BulletinBoard1 = XtVaCreateWidget("BulletinBoard1",
		xmBulletinBoardWidgetClass,
		color_slide, NULL);
	XtVaSetValues(BulletinBoard1, XmNx, 0, XmNy, 0,
		XmNwidth, 546, XmNheight, 454,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		NULL );
	vxpOBJ.BulletinBoard1 = BulletinBoard1;

	Salmon = XtVaCreateWidget("Salmon",
		xmDrawnButtonWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Salmon, XmNx, 35, XmNy, 309,
		XmNwidth, 186, XmNheight, 46,
		XtVaTypedArg, XmNlabelString, XmRString,
		"Salmon", 7,
		XtVaTypedArg, XmNbackground, XmRString,
		"salmon", 7,
		NULL );
	XtAddCallback(Salmon, XmNactivateCallback,
		Salmon_activate_cb, (XtPointer) NULL);
	XtManageChild(Salmon);
	vxpOBJ.Salmon = Salmon;

	SkyBlue = XtVaCreateWidget("SkyBlue",
		xmDrawnButtonWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(SkyBlue, XmNx, 35, XmNy, 246,
		XmNwidth, 186, XmNheight, 45,
		XtVaTypedArg, XmNlabelString, XmRString,
		"SkyBlue", 8,
		XtVaTypedArg, XmNbackground, XmRString,
		"SkyBlue", 8,
		NULL );
	XtAddCallback(SkyBlue, XmNactivateCallback,
		SkyBlue_activate_cb, (XtPointer) NULL);
	XtManageChild(SkyBlue);
	vxpOBJ.SkyBlue = SkyBlue;

	gold = XtVaCreateWidget("gold",
		xmDrawnButtonWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(gold, XmNx, 34, XmNy, 187,
		XmNwidth, 189, XmNheight, 43,
		XtVaTypedArg, XmNlabelString, XmRString,
		"gold", 5,
		XtVaTypedArg, XmNbackground, XmRString,
		"gold", 5,
		NULL );
	XtAddCallback(gold, XmNactivateCallback,
		gold_activate_cb, (XtPointer) NULL);
	XtManageChild(gold);
	vxpOBJ.gold = gold;

	snow = XtVaCreateWidget("snow",
		xmDrawnButtonWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(snow, XmNx, 35, XmNy, 134,
		XmNwidth, 190, XmNheight, 40,
		XtVaTypedArg, XmNlabelString, XmRString,
		"snow", 5,
		XtVaTypedArg, XmNbackground, XmRString,
		"snow", 5,
		NULL );
	XtAddCallback(snow, XmNactivateCallback,
		snow_activate_cb, (XtPointer) NULL);
	XtManageChild(snow);
	vxpOBJ.snow = snow;

	Separator3 = XtVaCreateWidget("Separator3",
		xmSeparatorWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Separator3, XmNx, 232, XmNy, 122,
		XmNwidth, 19, XmNheight, 245,
		XtVaTypedArg, XmNseparatorType, XmRString,
		"XmSHADOW_ETCHED_OUT", 20,
		XtVaTypedArg, XmNorientation, XmRString,
		"XmVERTICAL", 11,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		NULL );
	XtManageChild(Separator3);
	vxpOBJ.Separator3 = Separator3;

	quit = XtVaCreateWidget("quit",
		xmDrawnButtonWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(quit, XmNx, 211, XmNy, 388,
		XmNwidth, 110, XmNheight, 42,
		XtVaTypedArg, XmNfontList, XmRString,
		"-adobe-helvetica-medium-r-normal--18-180-75-75-p-98-iso8859-1", 62,
		XtVaTypedArg, XmNlabelString, XmRString,
		"QUIT", 5,
		XtVaTypedArg, XmNlabelPixmap, XmRString,
		"Excl", 5,
		XtVaTypedArg, XmNlabelType, XmRString,
		"XmSTRING", 9,
		XtVaTypedArg, XmNshadowType, XmRString,
		"XmSHADOW_OUT", 13,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		NULL );
	XtAddCallback(quit, XmNactivateCallback,
		quit_activate_cb, (XtPointer) NULL);
	XtManageChild(quit);
	vxpOBJ.quit = quit;

	Separator2 = XtVaCreateWidget("Separator2",
		xmSeparatorWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Separator2, XmNx, 11, XmNy, 363,
		XmNwidth, 515, XmNheight, 13,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		NULL );
	XtManageChild(Separator2);
	vxpOBJ.Separator2 = Separator2;

	blue = XtVaCreateWidget("blue",
		xmScaleWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(blue, XmNx, 272, XmNy, 285,
		XmNwidth, 235, XmNheight, 73,
		XtVaTypedArg, XmNfontList, XmRString,
		"-adobe-times-bold-r-normal--18-180-75-75-p-99-iso8859-1", 56,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		XtVaTypedArg, XmNforeground, XmRString,
		"blue", 5,
		XtVaTypedArg, XmNtitleString, XmRString,
		"Blue", 5,
		XtVaTypedArg, XmNshowValue, XmRString,
		"True", 5,
		XtVaTypedArg, XmNscaleMultiple, XmRString,
		"5", 2,
		XtVaTypedArg, XmNorientation, XmRString,
		"XmHORIZONTAL", 13,
		XtVaTypedArg, XmNmaximum, XmRString,
		"255", 4,
		NULL );
	XtAddCallback(blue, XmNvalueChangedCallback,
		blue_valueChanged_cb, (XtPointer) DoBlue);
	XtAddCallback(blue, XmNdragCallback,
		blue_drag_cb, (XtPointer) DoBlue);
	XtManageChild(blue);
	vxpOBJ.blue = blue;

	green = XtVaCreateWidget("green",
		xmScaleWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(green, XmNx, 271, XmNy, 204,
		XmNwidth, 238, XmNheight, 76,
		XtVaTypedArg, XmNfontList, XmRString,
		"-adobe-times-bold-r-normal--18-180-75-75-p-99-iso8859-1", 56,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		XtVaTypedArg, XmNforeground, XmRString,
		"green", 6,
		XtVaTypedArg, XmNtitleString, XmRString,
		"Green", 6,
		XtVaTypedArg, XmNshowValue, XmRString,
		"True", 5,
		XtVaTypedArg, XmNscaleMultiple, XmRString,
		"5", 2,
		XtVaTypedArg, XmNorientation, XmRString,
		"XmHORIZONTAL", 13,
		XtVaTypedArg, XmNmaximum, XmRString,
		"255", 4,
		NULL );
	XtAddCallback(green, XmNvalueChangedCallback,
		green_valueChanged_cb, (XtPointer) DoGreen);
	XtAddCallback(green, XmNdragCallback,
		green_drag_cb, (XtPointer) DoGreen);
	XtManageChild(green);
	vxpOBJ.green = green;

	red = XtVaCreateWidget("red",
		xmScaleWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(red, XmNx, 274, XmNy, 130,
		XmNwidth, 234, XmNheight, 62,
		XtVaTypedArg, XmNfontList, XmRString,
		"-adobe-times-bold-r-normal--18-180-75-75-p-99-iso8859-1", 56,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		XtVaTypedArg, XmNforeground, XmRString,
		"red", 4,
		XtVaTypedArg, XmNtitleString, XmRString,
		"Red", 4,
		XtVaTypedArg, XmNshowValue, XmRString,
		"True", 5,
		XtVaTypedArg, XmNscaleMultiple, XmRString,
		"5", 2,
		XtVaTypedArg, XmNmaximum, XmRString,
		"255", 4,
		XtVaTypedArg, XmNorientation, XmRString,
		"XmHORIZONTAL", 13,
		NULL );
	XtAddCallback(red, XmNdragCallback,
		red_drag_cb, (XtPointer) DoRed);
	XtAddCallback(red, XmNvalueChangedCallback,
		red_valueChanged_cb, (XtPointer) DoRed);
	XtManageChild(red);
	vxpOBJ.red = red;

	Separator1 = XtVaCreateWidget("Separator1",
		xmSeparatorWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Separator1, XmNx, 15, XmNy, 114,
		XmNwidth, 513, XmNheight, 13,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		NULL );
	XtManageChild(Separator1);
	vxpOBJ.Separator1 = Separator1;

	Frame1 = XtVaCreateWidget("Frame1",
		xmFrameWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Frame1, XmNx, 31, XmNy, 19,
		XmNwidth, 484, XmNheight, 78,
		XtVaTypedArg, XmNshadowType, XmRString,
		"XmSHADOW_IN", 12,
		NULL );
	vxpOBJ.Frame1 = Frame1;

	colorwindow = XtVaCreateWidget("colorwindow",
		xmDrawnButtonWidgetClass,
		Frame1, NULL);
	XtVaSetValues(colorwindow, XmNx, 3, XmNy, 3,
		XmNwidth, 478, XmNheight, 72,
		XtVaTypedArg, XmNfontList, XmRString,
		"-adobe-times-medium-r-normal--24-240-75-75-p-124-iso8859-1", 59,
		XtVaTypedArg, XmNlabelString, XmRString,
		"COLOR WINDOW", 13,
		XtVaTypedArg, XmNlabelType, XmRString,
		"XmSTRING", 9,
		XtVaTypedArg, XmNshadowType, XmRString,
		"XmSHADOW_OUT", 13,
		NULL );
	XtManageChild(colorwindow);
	vxpOBJ.colorwindow = colorwindow;

	XtManageChild(Frame1);
	XtManageChild(BulletinBoard1);

	/* Create windows for widgets and map them. */
	XtRealizeWidget(color_slide);
	vxpInitial();
	/* Loop for events. */
	XtAppMainLoop(app_context);
}


void Salmon_activate_cb
(Widget w, XtPointer client_data, XmDrawnButtonCallbackStruct *cbs)
{
    XtVaSetValues(vxpOBJ.colorwindow, XtVaTypedArg, XmNbackground,
        XmRString, "Salmon", strlen("Salmon") + 1, NULL);
}


void SkyBlue_activate_cb
(Widget w, XtPointer client_data, XmDrawnButtonCallbackStruct *cbs)
{
    XtVaSetValues(vxpOBJ.colorwindow, XtVaTypedArg, XmNbackground,
        XmRString, "SkyBlue", strlen("SkyBlue") + 1, NULL);
}


void gold_activate_cb
(Widget w, XtPointer client_data, XmDrawnButtonCallbackStruct *cbs)
{
    XtVaSetValues(vxpOBJ.colorwindow, XtVaTypedArg, XmNbackground,
        XmRString, "gold", strlen("gold") + 1, NULL);
}


void snow_activate_cb
(Widget w, XtPointer client_data, XmDrawnButtonCallbackStruct *cbs)
{
    XtVaSetValues(vxpOBJ.colorwindow, XtVaTypedArg, XmNbackground,
        XmRString, "snow", strlen("snow") + 1, NULL);
}


void quit_activate_cb
(Widget w, XtPointer client_data, XmDrawnButtonCallbackStruct *cbs)
{
	exit(0);
}




void blue_valueChanged_cb
(Widget w, int rgb, XmScaleCallbackStruct *cbs)
{
	new_value(w,rgb,cbs);
}




void blue_drag_cb
(Widget w, int rgb, XmScaleCallbackStruct *cbs)
{
	new_value(w,rgb,cbs);	
}




void green_valueChanged_cb
(Widget w, int rgb, XmScaleCallbackStruct *cbs)
{
	new_value(w, rgb, cbs);
}




void green_drag_cb
(Widget w, int rgb, XmScaleCallbackStruct *cbs)
{
	new_value(w,rgb,cbs);
}




void red_drag_cb
(Widget w, int rgb, XmScaleCallbackStruct *cbs)
{
	new_value(w, rgb, cbs);
}





void red_valueChanged_cb
(Widget w, int rgb, XmScaleCallbackStruct *cbs)
{
	new_value(w, rgb, cbs);
}





/* application's initial routine */
void vxpInitial()
{
    color.flags = DoRed|DoGreen|DoBlue;
    /* initialize first color */
    XAllocColor(XtDisplay(vxpOBJ.color_slide),
	DefaultColormapOfScreen(XtScreen(vxpOBJ.color_slide)),
	&color);
    /* set color to colorwindow */
    XtVaSetValues(vxpOBJ.colorwindow, XmNbackground, color.pixel, NULL);
}





void
new_value(Widget w, int rgb, XmScaleCallbackStruct *cbs)
{
    Colormap cmap = DefaultColormapOfScreen(XtScreen(w));

    switch (rgb) {
	case DoRed :
	    color.red = (cbs->value << 8);
	    break;
	case DoGreen :
	    color.green = (cbs->value << 8);
	    break;
	case DoBlue :
	    color.blue = (cbs->value << 8);
            break;
    }

    XFreeColors(XtDisplay(w), cmap, &color.pixel, 1, 0);
    if (!XAllocColor(XtDisplay(w), cmap, &color)) {
	puts("Couldn't XAllocColor!"); exit(1); }
    XtVaSetValues(vxpOBJ.colorwindow, XmNbackground, color.pixel, NULL);
}



