/*
 * pthread_dce.h
 */

#ifndef _pthread_dce_
#define _pthread_dce_

#ifdef __cplusplus
    extern "C" {
#endif

#include "pthread.h"

/*
 * These data types are used by POSIX Draft 4 and DCE threads, but not by
 * Linux (POSIX) threads.
 */
typedef void *pthread_addr_t;
typedef void *any_t;

typedef void *(*pthread_startroutine_t)(void *);
typedef void  (*pthread_cleanup_t)(void *);
typedef void  (*pthread_destructor_t)(void *);
typedef void  (*pthread_initroutine_t)(void);

#define pthread_attr_default        NULL
#define pthread_mutexattr_default   NULL
#define pthread_condattr_default    NULL

#ifdef _DCE_COMPAT_
#define pthread_attr_create         (pthd4_attr_create)
#define pthread_attr_delete         (pthd4_attr_delete )
#define pthread_attr_setstacksize   (pthd4_attr_setstacksize)
#define pthread_attr_getstacksize   (pthd4_attr_getstacksize)
#define pthread_create              (pthd4_create)
#define pthread_detach              (pthd4_detach)
#define pthread_exit                (pthd4_exit)
#define pthread_join                (pthd4_join)
#define pthread_self                (pthd4_self)
#define pthread_mutex_init          (pthd4_mutex_init)
#define pthread_mutex_destroy       (pthd4_mutex_destroy)
#define pthread_mutex_lock          (pthd4_mutex_lock)
#define pthread_mutex_trylock       (pthd4_mutex_trylock)
#define pthread_mutex_unlock        (pthd4_mutex_unlock)
#define pthread_cond_init           (pthd4_cond_init)
#define pthread_cond_destroy        (pthd4_cond_destroy)
#define pthread_cond_broadcast      (pthd4_cond_broadcast)
#define pthread_cond_signal         (pthd4_cond_signal)
#define pthread_cond_wait           (pthd4_cond_wait)
#define pthread_cond_timedwait      (pthd4_cond_timedwait)
#define pthread_once                (pthd4_once)
#define pthread_keycreate           (pthd4_keycreate)
#define pthread_setspecific         (pthd4_setspecific)
#define pthread_getspecific         (pthd4_getspecific)
#define pthread_cancel              (pthd4_cancel)
#define pthread_testcancel          (pthd4_testcancel)
#define pthread_setasynccancel      (pthd4_setasynccancel)
#define pthread_setcancel           (pthd4_setcancel)
#define pthread_get_expiration_np   (pthd4_get_expiration_np)
#define pthread_delay_np            (pthd4_delay_np)


#endif

extern int
pthd4_attr_create( pthread_attr_t *attr );

extern int 
pthd4_attr_delete ( pthread_attr_t *attr);

extern long
pthd4_attr_getstacksize( pthread_attr_t attr );

extern int
pthd4_attr_setstacksize( pthread_attr_t *attr, long stacksize );

extern int 
pthd4_create( pthread_t *thread,
              pthread_attr_t attr,
              pthread_startroutine_t start_routine,
              pthread_addr_t arg );

extern int
pthd4_detach( pthread_t *thread );

extern void
pthd4_exit( pthread_addr_t status );

extern int 
pthd4_join( pthread_t thread, pthread_addr_t *status );

extern pthread_t 
pthd4_self( void );

extern int 
pthd4_mutex_init( pthread_mutex_t *mutex, pthread_mutexattr_t attr );

extern int 
pthd4_mutex_destroy( pthread_mutex_t *mutex );

extern int
pthd4_mutex_lock( pthread_mutex_t *mutex );

extern int 
pthd4_mutex_trylock( pthread_mutex_t *mutex );

extern int 
pthd4_mutex_unlock( pthread_mutex_t *mutex );

extern int 
pthd4_cond_init( pthread_cond_t *cond, pthread_condattr_t attr );


extern int 
pthd4_cond_destroy( pthread_cond_t *cond );

extern int 
pthd4_cond_broadcast( pthread_cond_t *cond );

extern int 
pthd4_cond_signal( pthread_cond_t *cond );

extern int 
pthd4_cond_wait( pthread_cond_t *cond, pthread_mutex_t *mutex );

extern int 
pthd4_cond_timedwait( pthread_cond_t *cond,
                      pthread_mutex_t *mutex,
                      struct timespec *abstime );

extern int 
pthd4_once( pthread_once_t *once_block, void (*init_routine)(void) );

extern int 
pthd4_keycreate( pthread_key_t *key, pthread_destructor_t destructor );

int 
pthd4_setspecific( pthread_key_t key, pthread_addr_t value );

extern int 
pthd4_getspecific( pthread_key_t key, pthread_addr_t *value );

extern int 
pthd4_cancel( pthread_t thread );

extern void 
pthd4_testcancel( void );

extern int 
pthd4_setasynccancel( int state );

extern int 
pthd4_setcancel( int state );

extern int 
pthd4_get_expiration_np( struct timespec *delta, struct timespec *abstime );

extern int 
pthd4_delay_np( struct timespec *interval );

#ifdef __cplusplus
}
#endif

#endif






