#include <stdlib.h>
#include <stdio.h>
#include "utils.h"

char *h1 = "  Timer          Preemptions     Elapsed Time";
char *h2 = "Interrupts    Async       Sync    Secs:Usec";
char *h3 = "----------    ----------------  --------------";

void
print_system_counters( void )
{
   unsigned long cpu_intr_count, cpu_ctxsw_count, cpu_elapsed_usec,
                 cpu_async_count, seconds, usec;

   (void) system_get_state( &cpu_intr_count, 
                            &cpu_ctxsw_count, 
                            &cpu_async_count,
                            &cpu_elapsed_usec, 
                            NULL );

   seconds = cpu_elapsed_usec / 1000000;
   usec = cpu_elapsed_usec % 1000000;

   pthread_lock_global_np();
   
   printf("\n");
   printf("\t  *** PTHREADS RUNTIME STATS ***\n\n");
   printf("%s\n", h1 );
   printf("%s\n", h2 );
   printf("%s\n", h3 );
   printf("%5ld   %10ld  %8ld %7ld:%ld\n", cpu_intr_count, 
                                           cpu_async_count,
                                           cpu_ctxsw_count, 
                                           seconds, usec );
   printf("\n");

   pthread_unlock_global_np();
}

void
error_msg( const char *msg )
{
   int err;

   (void) pthread_errno_np( NULL, &err );
   pthread_lock_global_np();
   fprintf( stderr, ">> %s failed: %s\n", msg, sys_errlist[err] );
   pthread_unlock_global_np();
}   
