#include <assert.h>
#include <stdio.h>

#include "hash.h"

int
main ()
{
    struct hash_table *table;

    assert ((table = hash_table_build ()) != NULL);
    assert (hash_table_add (table, "hello") == HASH_OK);
    assert (hash_table_add (table, "world") == HASH_OK);
    assert (hash_table_add (table, "cat") == HASH_OK);
    assert (hash_table_lookup (table, "dd") == HASH_NOT_FOUND);
    assert (hash_table_lookup (table, "f") == HASH_NOT_FOUND);
    assert (hash_table_lookup (table, "hello") == HASH_OK);
    assert (hash_table_lookup (table, "cat") == HASH_OK);
    assert (hash_table_lookup (table, "world") == HASH_OK);
    assert (hash_table_free (table) == HASH_OK);

    printf ("all seems ok\n");

    return 0;
}
