/* stripcr.c -- remove carriage returns from input file */

#include <string.h>
#include <stdio.h>

#include <ctype.h>
#include <assert.h>

int main(int argc, char **argv)
{
    FILE *fin = stdin, *fout = stdout;
    int c;

    if (argc > 1) {
	if (!strcmp(argv[1], "-h") || argc > 3) {
	    fprintf(stderr, "\
%s: remove carriage returns from input file\n\
usage: %s [input] [[output]]\n", argv[0], argv[0]);
	    exit(0);
	} else {
	    if (strcmp(argv[1], "-") != 0 &&
		(fin = fopen(argv[1], "rb")) == NULL) {
		fprintf(stderr, "%s: no such file\n", argv[1]);
		exit(1);
	    }
	}
	if (argc == 3) {
	    if ((fout = fopen(argv[2], "wb")) == NULL) {
		fprintf(stderr, "%s: cannot open output file\n", argv[2]);
		exit(1);
	    }
	}
    }
    while ((c = fgetc(fin)) != EOF)
	if (c != 0x0d)
	    fputc(c, fout);

    fclose(fin);
    fclose(fout);

    return 0;
}

/* stripcr.c ends here */
